/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.multipiston.network;

import com.ldtteam.multipiston.TileEntityMultiPiston;
import com.ldtteam.multipiston.network.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class MultiPistonChangeMessage
implements IMessage {
    private Direction direction;
    private Direction output;
    private int range;
    private int speed;
    private BlockPos pos;

    public MultiPistonChangeMessage() {
    }

    public MultiPistonChangeMessage(BlockPos pos, Direction facing, Direction output, int range, int speed) {
        this.pos = pos;
        this.direction = facing;
        this.range = range;
        this.output = output;
        this.speed = speed;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.direction.ordinal());
        buf.writeInt(this.output.ordinal());
        buf.writeInt(this.range);
        buf.writeInt(this.speed);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.direction = Direction.values()[buf.readInt()];
        this.output = Direction.values()[buf.readInt()];
        this.range = buf.readInt();
        this.speed = buf.readInt();
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerLevel world = ctxIn.getSender().m_183503_();
        BlockEntity entity = world.m_7702_(this.pos);
        if (entity instanceof TileEntityMultiPiston) {
            ((TileEntityMultiPiston)entity).setDirection(this.direction);
            ((TileEntityMultiPiston)entity).setOutput(this.output);
            ((TileEntityMultiPiston)entity).setRange(this.range);
            ((TileEntityMultiPiston)entity).setSpeed(this.speed);
            BlockState state = world.m_8055_(this.pos);
            world.m_7260_(this.pos, state, state, 3);
        }
    }
}

