/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.door.fancy;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.models.block.BlockModelJson;
import com.ldtteam.domumornamentum.block.types.FancyDoorType;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class FancyDoorsBlockModelProvider
implements DataProvider {
    private final DataGenerator generator;

    public FancyDoorsBlockModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@NotNull HashCache cache) throws IOException {
        HashSet<String> uniqueValues = new HashSet<String>();
        for (FancyDoorType doorsShape : FancyDoorType.values()) {
            String shapeName = doorsShape.m_7912_();
            if (!uniqueValues.add(shapeName)) continue;
            BlockModelJson bottomJson = new BlockModelJson();
            bottomJson.setLoader("domum_ornamentum:materially_textured".toString());
            bottomJson.setParent(new ResourceLocation("domum_ornamentum", "block/doors/fancy/door_" + shapeName + "_spec").toString());
            String bottomName = "door_" + shapeName + ".json";
            Path bottomPath = this.generator.m_123916_().resolve("assets/domum_ornamentum/models/block/doors/fancy/").resolve(bottomName);
            DataProvider.m_123920_((Gson)DataGeneratorConstants.GSON, (HashCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)bottomJson), (Path)bottomPath);
            BlockModelJson topJson = new BlockModelJson();
            topJson.setLoader("domum_ornamentum:materially_textured".toString());
            topJson.setParent(new ResourceLocation("domum_ornamentum", "block/doors/fancy/door_top_" + shapeName + "_spec").toString());
            String topName = "door_top_" + shapeName + ".json";
            Path topPath = this.generator.m_123916_().resolve("assets/domum_ornamentum/models/block/doors/fancy/").resolve(topName);
            DataProvider.m_123920_((Gson)DataGeneratorConstants.GSON, (HashCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)topJson), (Path)topPath);
        }
    }

    @NotNull
    public String m_6055_() {
        return "Fancy Doors Block Model Provider";
    }
}

