/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.container;

import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IModBlocks;
import com.ldtteam.domumornamentum.block.MateriallyTexturedBlockManager;
import com.ldtteam.domumornamentum.container.ModContainerTypes;
import com.ldtteam.domumornamentum.recipe.ModRecipeTypes;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ArchitectsCutterContainer
extends AbstractContainerMenu {
    private final ContainerLevelAccess worldPosCallable;
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    private final Level world;
    private List<ArchitectsCutterRecipe> recipes = Lists.newArrayList();
    private final NonNullList<ItemStack> inputItemStacks = NonNullList.m_122780_((int)MateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount(), (Object)ItemStack.f_41583_);
    private long lastOnTake;
    final List<Slot> inputInventorySlots = Lists.newArrayList();
    final Slot outputInventorySlot;
    private Runnable inventoryUpdateListener = () -> {};
    public final Container inputInventory = new SimpleContainer(MateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount()){

        public void m_6596_() {
            super.m_6596_();
            ArchitectsCutterContainer.this.m_6199_((Container)this);
            ArchitectsCutterContainer.this.inventoryUpdateListener.run();
        }
    };
    private final ResultContainer inventory = new ResultContainer();

    public ArchitectsCutterContainer(int windowIdIn, Inventory playerInventoryIn) {
        this(windowIdIn, playerInventoryIn, ContainerLevelAccess.f_39287_);
    }

    public ArchitectsCutterContainer(int windowIdIn, Inventory playerInventoryIn, final ContainerLevelAccess worldPosCallableIn) {
        super(ModContainerTypes.ARCHITECTS_CUTTER, windowIdIn);
        int i;
        this.worldPosCallable = worldPosCallableIn;
        this.world = playerInventoryIn.f_35978_.f_19853_;
        for (i = 0; i < MateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount(); ++i) {
            int rowIndex = i / 2;
            int columnIndex = i % 2;
            int x = 10 + columnIndex * 20;
            int y = 16 + rowIndex * 18;
            this.inputInventorySlots.add(this.m_38897_(new Slot(this.inputInventory, i, x, y){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return MateriallyTexturedBlockManager.getInstance().doesItemStackContainsMaterialForSlot(this.getSlotIndex(), stack);
                }
            }));
        }
        this.outputInventorySlot = this.m_38897_(new Slot((Container)this.inventory, 1, 143, 33){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }

            public void m_142406_(@NotNull Player thePlayer, @NotNull ItemStack stack) {
                BlockItem blockItem;
                stack.m_41678_(thePlayer.f_19853_, thePlayer, stack.m_41613_());
                ArchitectsCutterContainer.this.inventory.m_8015_(thePlayer);
                boolean anyEmpty = false;
                List<Slot> inventorySlots = ArchitectsCutterContainer.this.inputInventorySlots;
                Item item = stack.m_41720_();
                boolean craftingMateriallyTexturedBlock = item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof IMateriallyTexturedBlock;
                ArrayList components = craftingMateriallyTexturedBlock ? Lists.newArrayList(((IMateriallyTexturedBlock)((BlockItem)stack.m_41720_()).m_40614_()).getComponents()) : Collections.emptyList();
                int componentSize = craftingMateriallyTexturedBlock ? components.size() : 1;
                for (int i = 0; i < inventorySlots.size(); ++i) {
                    boolean isRequiredBlock;
                    Slot inputInventorySlot = inventorySlots.get(i);
                    boolean bl = isRequiredBlock = i < componentSize;
                    if (inputInventorySlot.m_7993_().m_41619_() || !isRequiredBlock || thePlayer.m_7500_() || !inputInventorySlot.m_6201_(1).m_41619_()) continue;
                    anyEmpty = true;
                }
                if (!anyEmpty) {
                    ArchitectsCutterContainer.this.updateRecipeResultSlot();
                }
                worldPosCallableIn.m_39292_((world, pos) -> {
                    long gameTime = world.m_46467_();
                    if (ArchitectsCutterContainer.this.lastOnTake != gameTime) {
                        world.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        ArchitectsCutterContainer.this.lastOnTake = gameTime;
                    }
                });
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventoryIn, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSelectedRecipe() {
        return this.selectedRecipe.m_6501_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ArchitectsCutterRecipe> getRecipeList() {
        return this.recipes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRecipeListSize() {
        return this.recipes.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasItemsInInputSlots() {
        return this.inputInventorySlots.stream().anyMatch(Slot::m_6657_) && !this.recipes.isEmpty();
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return ArchitectsCutterContainer.m_38889_((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)IModBlocks.getInstance().getArchitectsCutter());
    }

    public boolean m_6366_(@NotNull Player playerIn, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipe.m_6422_(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int p_241818_1_) {
        return p_241818_1_ >= 0 && p_241818_1_ < this.recipes.size();
    }

    public void m_6199_(@NotNull Container inventoryIn) {
        boolean anyChanged = false;
        List<Slot> slots = this.inputInventorySlots;
        for (int i = 0; i < slots.size(); ++i) {
            Slot inputInventorySlot = slots.get(i);
            ItemStack inputStack = (ItemStack)this.inputItemStacks.get(i);
            if (inputInventorySlot.m_7993_().m_41720_() == inputStack.m_41720_()) continue;
            anyChanged = true;
        }
        if (anyChanged) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < slots.size(); ++i) {
                ItemStack itemStack = this.inputInventorySlots.get(i).m_7993_();
                stacks.add(itemStack);
                this.inputItemStacks.set(i, (Object)itemStack.m_41777_());
            }
            this.updateAvailableRecipes(inventoryIn, stacks);
        }
    }

    private void updateAvailableRecipes(Container inventoryIn, List<ItemStack> stacks) {
        this.recipes.clear();
        this.selectedRecipe.m_6422_(-1);
        this.outputInventorySlot.m_5852_(ItemStack.f_41583_);
        if (!stacks.stream().allMatch(ItemStack::m_41619_)) {
            this.recipes = this.world.m_7465_().m_44056_(ModRecipeTypes.ARCHITECTS_CUTTER, inventoryIn, this.world);
            this.recipes.sort(Comparator.comparing(ArchitectsCutterRecipe::getBlockName).thenComparing(ArchitectsCutterRecipe::m_6423_));
        }
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipe.m_6501_())) {
            Recipe recipe = this.recipes.get(this.selectedRecipe.m_6501_());
            this.inventory.m_6029_(recipe);
            this.outputInventorySlot.m_5852_(recipe.m_5874_(this.inputInventory));
        } else {
            this.outputInventorySlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    @NotNull
    public MenuType<?> m_6772_() {
        return ModContainerTypes.ARCHITECTS_CUTTER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean m_5882_(@NotNull ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.inventory && super.m_5882_(stack, slotIn);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int clickedSlot) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(clickedSlot);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (clickedSlot == 3) {
                if (!this.m_38903_(itemstack1, 4, 40, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
                slot.m_142406_(player, itemstack);
                return itemstack;
            }
            if (clickedSlot > 3) {
                if (!this.m_38903_(itemstack1, 0, 2, false)) {
                    return ItemStack.f_41583_;
                }
                if (clickedSlot < 31 ? !this.m_38903_(itemstack1, 31, 40, false) : clickedSlot < 40 && !this.m_38903_(itemstack1, 3, 30, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(itemstack1, 4, 40, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public void m_6877_(@NotNull Player playerIn) {
        super.m_6877_(playerIn);
        this.inventory.m_8016_(1);
        this.worldPosCallable.m_39292_((p_217079_2_, p_217079_3_) -> this.m_150411_(playerIn, this.inputInventory));
    }
}

