/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.model.data;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class MaterialTextureData
implements INBTSerializable<CompoundTag> {
    public static final MaterialTextureData EMPTY = new MaterialTextureData();
    private final Map<ResourceLocation, Block> texturedComponents;

    public MaterialTextureData() {
        this.texturedComponents = Maps.newHashMap();
    }

    public MaterialTextureData(Map<ResourceLocation, Block> texturedComponents) {
        this.texturedComponents = texturedComponents;
    }

    public Map<ResourceLocation, Block> getTexturedComponents() {
        return this.texturedComponents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaterialTextureData)) {
            return false;
        }
        MaterialTextureData that = (MaterialTextureData)o;
        return Objects.equals(this.getTexturedComponents(), that.getTexturedComponents());
    }

    public int hashCode() {
        return Objects.hash(this.getTexturedComponents());
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this == EMPTY) {
            return nbt;
        }
        this.getTexturedComponents().forEach((key, value) -> nbt.m_128359_(key.toString(), Objects.requireNonNull(value.getRegistryName()).toString()));
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.texturedComponents.clear();
        nbt.m_128431_().forEach(key -> {
            ResourceLocation name = new ResourceLocation(nbt.m_128461_(key));
            if (ForgeRegistries.BLOCKS.getValue(name) != Blocks.f_50016_) {
                this.texturedComponents.put(new ResourceLocation(key), (Block)ForgeRegistries.BLOCKS.getValue(name));
            }
        });
    }

    public static MaterialTextureData deserializeFromNBT(CompoundTag nbt) {
        if (nbt.m_128431_().isEmpty()) {
            return EMPTY;
        }
        MaterialTextureData newData = new MaterialTextureData();
        newData.deserializeNBT(nbt);
        return newData;
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }
}

