/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CreativeCrafter.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class TooltipBuilder {
    List<Component> tooltip = new ArrayList<Component>();

    public TooltipBuilder addTip(String text) {
        this.tooltip.add((Component)new TextComponent(text));
        return this;
    }

    public TooltipBuilder addTip(String text, ChatFormatting formatting) {
        this.tooltip.add((Component)new TextComponent(formatting + text));
        return this;
    }

    public TooltipBuilder addTranslatableTip(String key, ChatFormatting formatting) {
        this.tooltip.add((Component)new TranslatableComponent(key).m_130940_(formatting));
        return this;
    }

    public TooltipBuilder addTranslatableTip(String key) {
        this.tooltip.add((Component)new TranslatableComponent(key));
        return this;
    }

    public TooltipBuilder applyStyle(ChatFormatting formatting) {
        TextComponent textComponent = new TextComponent(formatting + this.tooltip.remove(this.tooltip.size() - 1).getString());
        this.tooltip.add((Component)textComponent);
        return this;
    }

    public TooltipBuilder appendText(String text) {
        MutableComponent textComponent = (MutableComponent)this.tooltip.remove(this.tooltip.size() - 1);
        textComponent.m_130946_(text);
        this.tooltip.add((Component)textComponent);
        return this;
    }

    public TooltipBuilder appendText(String text, ChatFormatting formatting) {
        MutableComponent textComponent = (MutableComponent)this.tooltip.remove(this.tooltip.size() - 1);
        textComponent.m_130946_(formatting + text);
        this.tooltip.add((Component)textComponent);
        return this;
    }

    public List<Component> build() {
        return this.tooltip.isEmpty() ? null : this.tooltip;
    }
}

