/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CreativeCrafter.node;

import com.YTrollman.CreativeCrafter.config.CreativeCrafterConfig;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.PatternItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class CreativeCrafterNetworkNode
extends NetworkNode
implements ICraftingPatternContainer {
    private static final String NBT_DISPLAY_NAME = "DisplayName";
    private static final String NBT_UUID = "CrafterUuid";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_LOCKED = "Locked";
    private static final String NBT_WAS_POWERED = "WasPowered";
    private final BaseItemHandler patternsInventory;
    private final ICraftingPattern[] patterns;
    private boolean visited;
    private boolean invalidateNextTick;
    private CrafterMode mode;
    private boolean locked;
    private boolean wasPowered;
    @Nullable
    private Component displayName;
    @Nullable
    private UUID uuid;
    public static final ResourceLocation ID = new ResourceLocation("creativecrafter", "creative_crafter");
    private static final Component DEFAULT_NAME = new TranslatableComponent("gui.creativecrafter.creative_crafter");

    public CreativeCrafterNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
        this.patternsInventory = new BaseItemHandler(108){

            public int getSlotLimit(int slot) {
                return 1;
            }
        }.addValidator((Predicate)new PatternItemValidator(this.level)).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
            if (!reading) {
                if (!this.level.f_46443_) {
                    this.invalidateSlot(slot);
                }
                this.invalidateNextTick = true;
            }
        });
        this.patterns = new ICraftingPattern[this.patternsInventory.getSlots()];
        this.visited = false;
        this.invalidateNextTick = false;
        this.mode = CrafterMode.IGNORE;
        this.locked = false;
        this.uuid = null;
    }

    private void invalidate() {
        for (int slot = 0; slot < this.patternsInventory.getSlots(); ++slot) {
            this.invalidateSlot(slot);
        }
    }

    private void invalidateSlot(int slot) {
        this.patterns[slot] = null;
        ItemStack patternStack = this.patternsInventory.getStackInSlot(slot);
        if (patternStack.m_41619_()) {
            return;
        }
        ICraftingPattern pattern = ((ICraftingPatternProvider)patternStack.m_41720_()).create(this.level, patternStack, (ICraftingPatternContainer)this);
        if (pattern.isValid()) {
            this.patterns[slot] = pattern;
        }
    }

    public int getEnergyUsage() {
        return (Integer)CreativeCrafterConfig.CREATIVE_CRAFTER_RF_CONSUME.get();
    }

    public void update() {
        super.update();
        if (this.ticks == 1) {
            this.invalidate();
        }
        if (this.invalidateNextTick) {
            this.invalidateNextTick = false;
            if (this.network != null) {
                this.network.getCraftingManager().invalidate();
            }
        }
        if (this.mode == CrafterMode.PULSE_INSERTS_NEXT_SET && this.level.m_46749_(this.pos)) {
            if (this.level.m_46753_(this.pos)) {
                this.wasPowered = true;
                this.markDirty();
            } else if (this.wasPowered) {
                this.wasPowered = false;
                this.locked = false;
                this.markDirty();
            }
        }
    }

    protected void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
        super.onConnectedStateChange(network, state, cause);
        network.getCraftingManager().invalidate();
    }

    public void onDisconnected(INetwork network) {
        super.onDisconnected(network);
        network.getCraftingManager().getTasks().stream().filter(task -> task.getPattern().getContainer().getPosition().equals((Object)this.pos)).forEach(task -> network.getCraftingManager().cancel(task.getId()));
    }

    public void onDirectionChanged(Direction direction) {
        super.onDirectionChanged(direction);
        if (this.network != null) {
            this.network.getCraftingManager().invalidate();
        }
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.patternsInventory, (int)0, (CompoundTag)tag);
        this.invalidate();
        if (tag.m_128441_(NBT_DISPLAY_NAME)) {
            this.displayName = Component.Serializer.m_130701_((String)tag.m_128461_(NBT_DISPLAY_NAME));
        }
        if (tag.m_128403_(NBT_UUID)) {
            this.uuid = tag.m_128342_(NBT_UUID);
        }
        if (tag.m_128441_(NBT_MODE)) {
            this.mode = CrafterMode.getById(tag.m_128451_(NBT_MODE));
        }
        if (tag.m_128441_(NBT_LOCKED)) {
            this.locked = tag.m_128471_(NBT_LOCKED);
        }
        if (tag.m_128441_(NBT_WAS_POWERED)) {
            this.wasPowered = tag.m_128471_(NBT_WAS_POWERED);
        }
    }

    public ResourceLocation getId() {
        return ID;
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.patternsInventory, (int)0, (CompoundTag)tag);
        if (this.displayName != null) {
            tag.m_128359_(NBT_DISPLAY_NAME, Component.Serializer.m_130703_((Component)this.displayName));
        }
        if (this.uuid != null) {
            tag.m_128362_(NBT_UUID, this.uuid);
        }
        tag.m_128405_(NBT_MODE, this.mode.ordinal());
        tag.m_128379_(NBT_LOCKED, this.locked);
        tag.m_128379_(NBT_WAS_POWERED, this.wasPowered);
        return tag;
    }

    public int getUpdateInterval() {
        return 0;
    }

    public int getMaximumSuccessfulCraftingUpdates() {
        return (Integer)CreativeCrafterConfig.CREATIVE_CRAFTER_SPEED.get();
    }

    @Nullable
    public IItemHandler getConnectedInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return LevelUtils.getItemHandler((BlockEntity)proxy.getFacingBlockEntity(), (Direction)proxy.getDirection().m_122424_());
    }

    @Nullable
    public IFluidHandler getConnectedFluidInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return LevelUtils.getFluidHandler((BlockEntity)proxy.getFacingBlockEntity(), (Direction)proxy.getDirection().m_122424_());
    }

    @Nullable
    public BlockEntity getConnectedBlockEntity() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return proxy.getFacingBlockEntity();
    }

    @Nullable
    public BlockEntity getFacingBlockEntity() {
        BlockPos facingPos = this.pos.m_142300_(this.getDirection());
        if (!this.level.m_46749_(facingPos)) {
            return null;
        }
        return this.level.m_7702_(facingPos);
    }

    public List<ICraftingPattern> getPatterns() {
        return Arrays.stream(this.patterns).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public IItemHandlerModifiable getPatternInventory() {
        return this.patternsInventory;
    }

    public Component getName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        BlockEntity facing = this.getConnectedBlockEntity();
        if (facing instanceof Nameable && ((Nameable)facing).m_7755_() != null) {
            return ((Nameable)facing).m_7755_();
        }
        if (facing != null) {
            return new TranslatableComponent(this.level.m_8055_(facing.m_58899_()).m_60734_().m_7705_());
        }
        return DEFAULT_NAME;
    }

    public void setDisplayName(Component displayName) {
        this.displayName = displayName;
    }

    @Nullable
    public Component getDisplayName() {
        return this.displayName;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public CrafterMode getMode() {
        return this.mode;
    }

    public void setMode(CrafterMode mode) {
        this.mode = mode;
        this.wasPowered = false;
        this.locked = false;
        this.markDirty();
    }

    public IItemHandler getPatternItems() {
        return this.patternsInventory;
    }

    @Nullable
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.patternsInventory});
    }

    @Nullable
    public ICraftingPatternContainer getRootContainer() {
        if (this.visited) {
            return null;
        }
        INetworkNode facing = API.instance().getNetworkNodeManager((ServerLevel)this.level).getNode(this.pos.m_142300_(this.getDirection()));
        if (!(facing instanceof ICraftingPatternContainer) || facing.getNetwork() != this.network) {
            return this;
        }
        this.visited = true;
        ICraftingPatternContainer facingContainer = ((ICraftingPatternContainer)facing).getRootContainer();
        this.visited = false;
        return facingContainer;
    }

    public Optional<ICraftingPatternContainer> getRootContainerNotSelf() {
        ICraftingPatternContainer root = this.getRootContainer();
        if (root != null && root != this) {
            return Optional.of(root);
        }
        return Optional.empty();
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.markDirty();
        }
        return this.uuid;
    }

    public boolean isLocked() {
        Optional<ICraftingPatternContainer> root = this.getRootContainerNotSelf();
        if (root.isPresent()) {
            return root.get().isLocked();
        }
        switch (this.mode) {
            case SIGNAL_LOCKS_AUTOCRAFTING: {
                return this.level.m_46753_(this.pos);
            }
            case SIGNAL_UNLOCKS_AUTOCRAFTING: {
                return !this.level.m_46753_(this.pos);
            }
            case PULSE_INSERTS_NEXT_SET: {
                return this.locked;
            }
        }
        return false;
    }

    public void unlock() {
        this.locked = false;
    }

    public void onUsedForProcessing() {
        Optional<ICraftingPatternContainer> root = this.getRootContainerNotSelf();
        if (root.isPresent()) {
            root.get().onUsedForProcessing();
        } else if (this.mode == CrafterMode.PULSE_INSERTS_NEXT_SET) {
            this.locked = true;
            this.markDirty();
        }
    }

    public static enum CrafterMode {
        IGNORE,
        SIGNAL_UNLOCKS_AUTOCRAFTING,
        SIGNAL_LOCKS_AUTOCRAFTING,
        PULSE_INSERTS_NEXT_SET;


        public static CrafterMode getById(int id) {
            if (id >= 0 && id < CrafterMode.values().length) {
                return CrafterMode.values()[id];
            }
            return IGNORE;
        }
    }
}

