/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.util;

import de.melanx.utilitix.UtilitiX;
import io.github.noeppi_noeppi.libx.util.ResourceList;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class MobUtil {
    public static final String ENTITY_TYPE_TAG = "Entity";
    public static final String ENTITY_DATA_TAG = "EntityData";
    public static final MutableComponent NO_MOB = new TranslatableComponent("tooltip." + UtilitiX.getInstance().modid + ".no_mob").m_130940_(ChatFormatting.DARK_RED);
    private static final MutableComponent DENYLISTED_MOB = new TranslatableComponent("tooltip." + UtilitiX.getInstance().modid + ".blacklisted_mob").m_130940_(ChatFormatting.DARK_RED);

    public static boolean storeEntityData(Player player, InteractionHand hand, LivingEntity entity, ResourceList denylist, boolean typeKeyOnly) {
        String entityKey = entity.m_20078_();
        ItemStack stack = player.m_21120_(hand);
        CompoundTag nbt = stack.m_41784_();
        if (entityKey == null || entityKey.equals(nbt.m_128461_(ENTITY_TYPE_TAG))) {
            return false;
        }
        if (!denylist.test(new ResourceLocation(entityKey))) {
            player.m_5661_((Component)DENYLISTED_MOB, true);
            return false;
        }
        nbt.m_128359_(ENTITY_TYPE_TAG, entityKey);
        if (!typeKeyOnly) {
            nbt.m_128365_(ENTITY_DATA_TAG, (Tag)entity.m_20240_(new CompoundTag()));
        }
        player.m_21008_(hand, stack);
        player.m_5661_((Component)MobUtil.getCurrentMob(entity.m_6095_()), true);
        return true;
    }

    @Nullable
    public static MutableComponent getCurrentMob(ItemStack stack) {
        String s = stack.m_41784_().m_128461_(ENTITY_TYPE_TAG);
        Optional entityType = EntityType.m_20632_((String)s);
        return entityType.map(MobUtil::getCurrentMob).orElse(null);
    }

    @Nonnull
    public static MutableComponent getCurrentMob(EntityType<?> entityType) {
        Component name = entityType.m_20676_();
        TranslatableComponent component = new TranslatableComponent("tooltip." + UtilitiX.getInstance().modid + ".current_mob");
        component.m_130940_(entityType.m_20674_() == MobCategory.MONSTER ? ChatFormatting.RED : ChatFormatting.GOLD);
        return component.m_130946_(": ").m_7220_(name);
    }
}

