/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.network;

import de.melanx.utilitix.content.experiencecrystal.ScreenExperienceCrystal;
import de.melanx.utilitix.content.experiencecrystal.TileExperienceCrystal;
import de.melanx.utilitix.util.XPUtils;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClickScreenButtonHandler {
    public static void handle(Message msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_183503_();
            ScreenExperienceCrystal.Button button = msg.button;
            BlockEntity be = level.m_7702_(msg.pos);
            if (be instanceof TileExperienceCrystal) {
                TileExperienceCrystal tile = (TileExperienceCrystal)be;
                int playerXP = XPUtils.getExpPoints(player.f_36078_, player.f_36080_);
                switch (button) {
                    case ADD_ONE: {
                        ClickScreenButtonHandler.normalizeAddition((Player)player, tile);
                        int xp = XPUtils.getXpBarCap(player.f_36078_ - 1);
                        int i = tile.addXp(xp);
                        player.m_6756_(-i);
                        break;
                    }
                    case ADD_TEN: {
                        int i;
                        ClickScreenButtonHandler.normalizeAddition((Player)player, tile);
                        int xp = 0;
                        for (i = 0; i < 10; ++i) {
                            xp += XPUtils.getXpBarCap(player.f_36078_ - 1 - i);
                        }
                        i = tile.addXp(xp);
                        player.m_6756_(-i);
                        break;
                    }
                    case ADD_ALL: {
                        int xp = tile.addXp(playerXP);
                        player.m_6756_(-xp);
                        break;
                    }
                    case SUB_ONE: {
                        ClickScreenButtonHandler.normalizeSubtraction((Player)player, tile, 1);
                        break;
                    }
                    case SUB_TEN: {
                        ClickScreenButtonHandler.normalizeSubtraction((Player)player, tile, 10);
                        break;
                    }
                    case SUB_ALL: {
                        int xp = tile.subtractXp(Integer.MAX_VALUE);
                        player.m_6756_(xp);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void normalizeAddition(Player player, TileExperienceCrystal tile) {
        int transfer = (int)(player.f_36080_ * (float)player.m_36323_());
        int i = tile.addXp(transfer);
        player.m_6756_(-i);
    }

    private static void normalizeSubtraction(Player player, TileExperienceCrystal tile, int levels) {
        int newV = XPUtils.getExpPoints(player.f_36078_ + levels, 0.0f);
        int oldV = XPUtils.getExpPoints(player.f_36078_, player.f_36080_);
        int xp = newV - oldV;
        int i = tile.subtractXp(xp);
        player.m_6756_(i);
        if (Math.round(player.f_36080_) == 1) {
            i = tile.subtractXp(1);
            player.m_6756_(i);
        }
    }

    public static class Message {
        public final BlockPos pos;
        public final ScreenExperienceCrystal.Button button;

        public Message(BlockPos pos, ScreenExperienceCrystal.Button button) {
            this.pos = pos;
            this.button = button;
        }
    }

    public static class ClickScreenButtonSerializer
    implements PacketSerializer<Message> {
        public Class<Message> messageClass() {
            return Message.class;
        }

        public void encode(Message msg, FriendlyByteBuf buffer) {
            buffer.m_130064_(msg.pos);
            buffer.m_130068_((Enum)msg.button);
        }

        public Message decode(FriendlyByteBuf buffer) {
            return new Message(buffer.m_130135_(), (ScreenExperienceCrystal.Button)buffer.m_130066_(ScreenExperienceCrystal.Button.class));
        }
    }
}

