/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.rails;

import de.melanx.utilitix.content.track.ItemMinecartTinkerer;
import de.melanx.utilitix.content.track.carts.PistonCart;
import de.melanx.utilitix.content.track.carts.piston.PistonCartMode;
import de.melanx.utilitix.content.track.rails.BlockControllerRail;
import de.melanx.utilitix.content.track.rails.TilePistonControllerRail;
import de.melanx.utilitix.registration.ModItems;
import io.github.noeppi_noeppi.libx.mod.ModX;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BlockPistonControllerRail
extends BlockControllerRail<TilePistonControllerRail> {
    public BlockPistonControllerRail(ModX mod, boolean reinforced, BlockBehaviour.Properties properties) {
        super(mod, TilePistonControllerRail::new, reinforced, properties);
    }

    public BlockPistonControllerRail(ModX mod, boolean reinforced, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, TilePistonControllerRail::new, reinforced, properties, itemProperties);
    }

    @Override
    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        InteractionResult result = super.m_6227_(state, level, pos, player, hand, hit);
        if (result.m_19077_()) {
            return result;
        }
        ItemStack held = player.m_21120_(hand);
        if (!held.m_41619_() && held.m_41720_() == ModItems.minecartTinkerer) {
            if (!level.f_46443_) {
                TilePistonControllerRail tile = (TilePistonControllerRail)((Object)this.getTile((BlockGetter)level, pos));
                int modeIdx = tile.getMode().ordinal();
                PistonCartMode[] modes = PistonCartMode.values();
                tile.setMode(modes[(modeIdx + 1) % modes.length]);
                player.m_6352_((Component)new TranslatableComponent("tooltip.utilitix.piston_cart_mode", new Object[]{tile.getMode().name}), player.m_142081_());
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        if (!(cart instanceof PistonCart)) {
            return;
        }
        TilePistonControllerRail tile = (TilePistonControllerRail)((Object)this.getTile((BlockGetter)level, pos));
        ItemStack filterThis = tile.getFilterStack();
        if (!filterThis.m_41619_()) {
            ItemStack filterCart = ItemMinecartTinkerer.getLabelStack(cart);
            if (filterCart.m_41619_()) {
                return;
            }
            if (!ItemStack.m_41746_((ItemStack)filterThis, (ItemStack)filterCart) || !ItemStack.m_41658_((ItemStack)filterThis, (ItemStack)filterCart)) {
                return;
            }
        }
        ((PistonCart)cart).setMode(tile.getMode());
    }
}

