/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.rails;

import de.melanx.utilitix.block.ModProperties;
import de.melanx.utilitix.content.track.ItemMinecartTinkerer;
import de.melanx.utilitix.content.track.TrackUtil;
import de.melanx.utilitix.content.track.rails.BlockControllerRail;
import de.melanx.utilitix.content.track.rails.TileFilterRail;
import io.github.noeppi_noeppi.libx.mod.ModX;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class BlockFilterRail
extends BlockControllerRail<TileFilterRail> {
    public BlockFilterRail(ModX mod, boolean reinforced, BlockBehaviour.Properties properties) {
        super(mod, TileFilterRail::new, reinforced, properties);
    }

    public BlockFilterRail(ModX mod, boolean reinforced, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, TileFilterRail::new, reinforced, properties, itemProperties);
    }

    @Override
    @Nonnull
    public Property<RailShape> m_7978_() {
        return ModProperties.RAIL_SHAPE_FLAT_STRAIGHT;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ModProperties.REVERSE});
        builder.m_61104_(new Property[]{ModProperties.RAIL_SIDE});
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        Direction direction = context.m_8125_();
        Pair<RailShape, Boolean> properties = TrackUtil.getForPlacement(direction);
        state = (BlockState)((BlockState)state.m_61124_(this.m_7978_(), (Comparable)((RailShape)properties.getLeft()))).m_61124_((Property)ModProperties.REVERSE, (Comparable)((Boolean)properties.getRight()));
        Vec3 hitVec = context.m_43720_();
        double xd = hitVec.f_82479_ - (double)context.m_8083_().m_123341_();
        double zd = hitVec.f_82481_ - (double)context.m_8083_().m_123343_();
        boolean side = !(direction.m_122429_() < 0 && zd < 0.5 || direction.m_122429_() > 0 && zd > 0.5 || direction.m_122431_() < 0 && xd > 0.5 || direction.m_122431_() > 0 && xd < 0.5);
        return (BlockState)state.m_61124_((Property)ModProperties.RAIL_SIDE, (Comparable)Boolean.valueOf(!side));
    }

    @Nonnull
    public RailShape getRailDirection(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nullable AbstractMinecart cart) {
        ItemStack filterCart;
        RailShape baseShape = (RailShape)state.m_61143_(this.m_7978_());
        ItemStack itemStack = filterCart = cart == null ? ItemStack.f_41583_ : ItemMinecartTinkerer.getLabelStack(cart);
        if (filterCart.m_41619_()) {
            return baseShape;
        }
        ItemStack filterThis = ((TileFilterRail)((Object)this.getTile(level, pos))).getFilterStack();
        if (filterThis.m_41619_()) {
            return baseShape;
        }
        if (!ItemStack.m_41746_((ItemStack)filterThis, (ItemStack)filterCart) || !ItemStack.m_41658_((ItemStack)filterThis, (ItemStack)filterCart)) {
            return baseShape;
        }
        boolean reverse = (Boolean)state.m_61143_((Property)ModProperties.REVERSE);
        boolean side = (Boolean)state.m_61143_((Property)ModProperties.RAIL_SIDE);
        if (baseShape == RailShape.NORTH_SOUTH) {
            if (reverse && side) {
                return RailShape.NORTH_WEST;
            }
            if (reverse) {
                return RailShape.NORTH_EAST;
            }
            if (side) {
                return RailShape.SOUTH_WEST;
            }
            return RailShape.SOUTH_EAST;
        }
        if (reverse && side) {
            return RailShape.NORTH_WEST;
        }
        if (reverse) {
            return RailShape.SOUTH_WEST;
        }
        if (side) {
            return RailShape.NORTH_EAST;
        }
        return RailShape.SOUTH_EAST;
    }
}

