/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.carts;

import com.google.common.collect.ImmutableList;
import de.melanx.utilitix.content.track.carts.Cart;
import de.melanx.utilitix.content.track.carts.piston.PistonCartContainerMenu;
import de.melanx.utilitix.content.track.carts.piston.PistonCartMode;
import de.melanx.utilitix.content.track.rails.BlockPistonControllerRail;
import de.melanx.utilitix.registration.ModItemTags;
import de.melanx.utilitix.registration.ModSerializers;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;

public class PistonCart
extends Cart {
    private static final EntityDataAccessor<PistonCartMode> MODE = SynchedEntityData.m_135353_(PistonCart.class, ModSerializers.pistonCartMode);
    private PistonCartMode mode = PistonCartMode.IDLE;
    private final BaseItemStackHandler railIn = BaseItemStackHandler.builder((int)12).validator(stack -> stack.m_204117_(ItemTags.f_13142_), new int[0]).build();
    private final BaseItemStackHandler torchIn;
    private final BaseItemStackHandler railOut = BaseItemStackHandler.builder((int)12).validator(stack -> stack.m_204117_(ItemTags.f_13142_), new int[0]).build();

    public PistonCart(EntityType<?> type, Level level) {
        super(type, level);
        this.torchIn = BaseItemStackHandler.builder((int)12).validator(stack -> stack.m_204117_(ModItemTags.RAIL_POWER_SOURCES), new int[0]).build();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MODE, (Object)PistonCartMode.IDLE);
    }

    public void m_7350_(@Nonnull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (MODE.equals(key)) {
            this.mode = (PistonCartMode)((Object)this.f_19804_.m_135370_(MODE));
        }
    }

    @Nonnull
    public BlockState m_6390_() {
        if (this.mode == PistonCartMode.PLACE) {
            return (BlockState)Blocks.f_50039_.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP);
        }
        if (this.mode == PistonCartMode.REPLACE) {
            return (BlockState)Blocks.f_50032_.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP);
        }
        return (BlockState)((BlockState)Blocks.f_50039_.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP)).m_61124_((Property)BlockStateProperties.f_61432_, (Comparable)Boolean.valueOf(true));
    }

    public void m_7617_(@Nonnull DamageSource source) {
        int i;
        super.m_7617_(source);
        this.m_19998_((ItemLike)Items.f_41869_);
        for (i = 0; i < this.railIn.getSlots(); ++i) {
            this.m_19983_(this.railIn.getStackInSlot(i));
        }
        for (i = 0; i < this.torchIn.getSlots(); ++i) {
            this.m_19983_(this.torchIn.getStackInSlot(i));
        }
        for (i = 0; i < this.railOut.getSlots(); ++i) {
            this.m_19983_(this.railOut.getStackInSlot(i));
        }
    }

    @Nonnull
    public InteractionResult m_6096_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        InteractionResult ret = super.m_6096_(player, hand);
        if (ret.m_19077_()) {
            return ret;
        }
        if (player instanceof ServerPlayer) {
            MenuProvider containerProvider = new MenuProvider(){

                @Nonnull
                public Component m_5446_() {
                    return PistonCart.this.m_5446_();
                }

                public AbstractContainerMenu m_7208_(int containerId, @Nonnull Inventory inventory, @Nonnull Player player) {
                    FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                    buffer.writeInt(PistonCart.this.m_142049_());
                    return PistonCartContainerMenu.TYPE.create(containerId, inventory, buffer);
                }
            };
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, buffer -> buffer.writeInt(this.m_142049_()));
        }
        return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
    }

    public void m_8119_() {
        block7: {
            block8: {
                List<ItemStack> placeResult;
                super.m_8119_();
                if (this.f_19853_.f_46443_) break block7;
                if (this.mode != PistonCartMode.PLACE || !this.shouldDoRailFunctions()) break block8;
                BlockPos pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)this.m_20189_()));
                if (this.f_19853_.m_8055_(pos).m_204336_(BlockTags.f_13034_) || this.f_19853_.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13034_)) break block7;
                Pair<ItemStack, Integer> result = this.findRail((IItemHandlerModifiable)this.railIn);
                ItemStack railStack = (ItemStack)result.getLeft();
                int railSlot = (Integer)result.getRight();
                if (!railStack.m_41619_() && railSlot >= 0 && (placeResult = this.placeRail(railStack, pos, false)) != null) {
                    this.railIn.extractItem(railSlot, 1, false);
                    for (ItemStack drop : placeResult) {
                        this.depositOrDrop(drop.m_41777_());
                    }
                }
                break block7;
            }
            if (this.mode == PistonCartMode.REPLACE && this.shouldDoRailFunctions()) {
                BlockPos pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)this.m_20189_()));
                if (!this.f_19853_.m_8055_(pos).m_204336_(BlockTags.f_13034_) && this.f_19853_.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13034_)) {
                    pos = pos.m_7495_();
                }
                if (this.f_19853_.m_8055_(pos).m_204336_(BlockTags.f_13034_)) {
                    List<ItemStack> placeResult;
                    Pair<ItemStack, Integer> result = this.findRail((IItemHandlerModifiable)this.railIn);
                    ItemStack railStack = (ItemStack)result.getLeft();
                    int railSlot = (Integer)result.getRight();
                    if (!railStack.m_41619_() && railSlot >= 0 && (placeResult = this.placeRail(railStack, pos, true)) != null) {
                        this.railIn.extractItem(railSlot, 1, false);
                        for (ItemStack drop : placeResult) {
                            this.depositOrDrop(drop.m_41777_());
                        }
                    }
                }
            }
        }
    }

    private Pair<ItemStack, Integer> findRail(IItemHandlerModifiable inventory) {
        for (int slot = inventory.getSlots() - 1; slot >= 0; --slot) {
            ItemStack extracted = inventory.extractItem(slot, 1, true);
            if (extracted.m_41619_()) continue;
            return Pair.of((Object)extracted.m_41777_(), (Object)slot);
        }
        return Pair.of((Object)ItemStack.f_41583_, (Object)-1);
    }

    private void depositOrDrop(ItemStack rail) {
        ItemStack remainder = rail;
        for (int slot = 0; slot < this.railOut.getSlots(); ++slot) {
            if (!(remainder = this.railOut.insertItem(slot, remainder, false)).m_41619_()) continue;
            return;
        }
        if (!remainder.m_41619_()) {
            ItemEntity ie = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), remainder);
            this.f_19853_.m_7967_((Entity)ie);
        }
    }

    @Nullable
    private List<ItemStack> placeRail(ItemStack railStack, BlockPos pos, boolean replace) {
        BlockState oldState = this.f_19853_.m_8055_(pos);
        if (replace) {
            RailShape shape;
            switch (this.m_6374_()) {
                case WEST: 
                case EAST: {
                    RailShape railShape = RailShape.EAST_WEST;
                    break;
                }
                default: {
                    RailShape railShape = shape = RailShape.NORTH_SOUTH;
                }
            }
            if (oldState.m_60734_() instanceof BaseRailBlock) {
                shape = ((BaseRailBlock)oldState.m_60734_()).getRailDirection(oldState, (BlockGetter)this.f_19853_, pos, (AbstractMinecart)this);
            }
            List drops = null;
            if (this.f_19853_ instanceof ServerLevel) {
                drops = Block.m_49869_((BlockState)oldState, (ServerLevel)((ServerLevel)this.f_19853_), (BlockPos)pos, (BlockEntity)this.f_19853_.m_7702_(pos));
            }
            if (this.doPlaceRail(railStack, shape, pos, oldState.m_60734_())) {
                return drops == null ? ImmutableList.of() : drops;
            }
            return null;
        }
        if (oldState.m_60795_() || oldState.m_60767_().m_76336_()) {
            RailShape shape = switch (this.m_6374_()) {
                case Direction.WEST, Direction.EAST -> RailShape.EAST_WEST;
                default -> RailShape.NORTH_SOUTH;
            };
            return this.doPlaceRail(railStack, shape, pos, null) ? ImmutableList.of() : null;
        }
        return null;
    }

    private boolean doPlaceRail(ItemStack railStack, RailShape shape, BlockPos pos, @Nullable Block oldBlock) {
        if (railStack.m_41720_() instanceof BlockItem) {
            Block railBlock = ((BlockItem)railStack.m_41720_()).m_40614_();
            if (railBlock instanceof BlockPistonControllerRail) {
                return false;
            }
            if (oldBlock != null && railBlock == oldBlock) {
                this.tryPower(pos);
                return false;
            }
            if (railBlock instanceof BaseRailBlock && ((BaseRailBlock)railBlock).m_7978_().m_6908_().contains(shape)) {
                BlockState railState = railBlock.m_5573_((BlockPlaceContext)new DirectionalPlaceContext(this.f_19853_, pos, this.m_6374_(), railStack.m_41777_(), Direction.UP));
                if (railState == null) {
                    railState = railBlock.m_49966_();
                }
                if (!(railState = (BlockState)railState.m_61124_(((BaseRailBlock)railBlock).m_7978_(), (Comparable)shape)).m_60710_((LevelReader)this.f_19853_, pos)) {
                    return false;
                }
                this.f_19853_.m_7731_(pos, railState, 11);
                this.tryPower(pos);
                return true;
            }
        }
        return false;
    }

    private void tryPower(BlockPos railPos) {
        BlockState railState = this.f_19853_.m_8055_(railPos);
        if (railState.m_61138_((Property)BlockStateProperties.f_61448_) && !((Boolean)railState.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue() && this.f_19853_.m_8055_(railPos.m_7495_()).m_60815_()) {
            BlockPos pos = railPos.m_6625_(2);
            Pair<ItemStack, Integer> result = this.findRail((IItemHandlerModifiable)this.torchIn);
            ItemStack torchStack = (ItemStack)result.getLeft();
            int torchSlot = (Integer)result.getRight();
            if (!torchStack.m_41619_() && torchSlot >= 0 && torchStack.m_41720_() instanceof BlockItem) {
                BlockState oldState = this.f_19853_.m_8055_(pos);
                BlockState state = ((BlockItem)torchStack.m_41720_()).m_40614_().m_49966_();
                if (state.m_60710_((LevelReader)this.f_19853_, pos)) {
                    List drops = null;
                    if (this.f_19853_ instanceof ServerLevel) {
                        drops = Block.m_49869_((BlockState)oldState, (ServerLevel)((ServerLevel)this.f_19853_), (BlockPos)pos, (BlockEntity)this.f_19853_.m_7702_(pos));
                    }
                    this.f_19853_.m_7731_(pos, state, 11);
                    this.torchIn.extractItem(torchSlot, 1, false);
                    if (drops != null) {
                        for (ItemStack drop : drops) {
                            ItemEntity ie = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), drop.m_41777_());
                            this.f_19853_.m_7967_((Entity)ie);
                        }
                    }
                }
            }
        }
    }

    public IItemHandlerModifiable getRailInputInventory() {
        return this.railIn;
    }

    public IItemHandlerModifiable getRailOutputInventory() {
        return this.railOut;
    }

    public IItemHandlerModifiable getTorchInventory() {
        return this.torchIn;
    }

    public PistonCartMode getMode() {
        return this.mode;
    }

    public void setMode(PistonCartMode mode) {
        this.mode = mode;
        this.f_19804_.m_135381_(MODE, (Object)mode);
    }

    protected void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.railIn.deserializeNBT(compound.m_128469_("RailInput"));
        this.torchIn.deserializeNBT(compound.m_128469_("TorchIn"));
        this.railOut.deserializeNBT(compound.m_128469_("RailOut"));
        String modeName = compound.m_128461_("Mode");
        try {
            this.mode = PistonCartMode.valueOf(modeName);
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            this.mode = PistonCartMode.IDLE;
        }
        if (this.mode != this.f_19804_.m_135370_(MODE)) {
            this.f_19804_.m_135381_(MODE, (Object)this.mode);
        }
    }

    protected void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("RailInput", (Tag)this.railIn.serializeNBT());
        compound.m_128365_("TorchIn", (Tag)this.torchIn.serializeNBT());
        compound.m_128365_("RailOut", (Tag)this.railOut.serializeNBT());
        compound.m_128359_("Mode", this.mode.name());
    }
}

