/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.slime;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.slime.StickySection;
import de.melanx.utilitix.network.StickyChunkUpdateSerializer;
import io.github.noeppi_noeppi.libx.annotation.meta.RemoveIn;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.PacketDistributor;

public class StickyChunk {
    @Nullable
    private LevelChunk chunk;
    private final Map<Integer, StickySection> sections = new HashMap<Integer, StickySection>();

    public boolean get(int x, int y, int z, Direction dir) {
        StickySection section = this.getSection(y);
        return section != null && section.get(x, y & 0xF, z, dir);
    }

    public void set(int x, int y, int z, Direction dir, boolean sticky) {
        StickySection section = this.getOrCreateSection(y);
        section.set(x, y & 0xF, z, dir, sticky);
    }

    public byte getData(int x, int y, int z) {
        StickySection section = this.getSection(y);
        return section == null ? (byte)0 : section.getData(x, y & 0xF, z);
    }

    public void setData(int x, int y, int z, byte data) {
        StickySection section = this.getOrCreateSection(y);
        section.setData(x, y & 0xF, z, data);
    }

    public void clearData(int x, int y, int z) {
        StickySection section = this.getOrCreateSection(y);
        section.clearData(x, y & 0xF, z);
    }

    public void foreach(ChunkAction action) {
        for (Map.Entry<Integer, StickySection> entry : this.sections.entrySet()) {
            SectionAction sectionAction;
            if (entry.getValue().canBeDiscarded() || (sectionAction = action.section(entry.getKey(), entry.getKey() << 4)) == null) continue;
            entry.getValue().foreach(sectionAction);
        }
    }

    public void sync() {
        if (this.chunk != null && !this.chunk.m_62953_().f_46443_) {
            this.chunk.m_8092_(true);
            UtilitiX.getNetwork().channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.chunk), (Object)new StickyChunkUpdateSerializer.StickyChunkUpdateMessage(this.chunk.m_7697_(), this));
        }
    }

    @Nullable
    private StickySection getSection(int y) {
        return this.sections.getOrDefault(y >> 4, null);
    }

    private StickySection getOrCreateSection(int y) {
        return this.sections.computeIfAbsent(y >> 4, k -> new StickySection(this));
    }

    public void attach(LevelChunk chunk) {
        this.chunk = chunk;
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<Integer, StickySection> entry : this.sections.entrySet()) {
            if (entry.getValue().canBeDiscarded()) continue;
            nbt.m_128382_(Integer.toString(entry.getKey()), entry.getValue().getStickies());
        }
        return nbt;
    }

    @Deprecated(forRemoval=true)
    @RemoveIn(minecraft="1.19")
    public void readLegacy(ByteArrayTag nbt) {
        try {
            byte[] data = nbt.m_128227_();
            this.sections.clear();
            for (int sectionId = 0; sectionId < 16; ++sectionId) {
                byte[] newData = new byte[4096];
                int sectionOffset = sectionId << 4;
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            int newIdx = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
                            int oldIdx = (y + sectionOffset & 0xFF) << 8 | (z & 0xF) << 4 | x & 0xF;
                            newData[newIdx] = data[oldIdx];
                        }
                    }
                }
                StickySection section = new StickySection(this);
                section.setStickies(newData);
                if (section.canBeDiscarded()) continue;
                this.sections.put(sectionId, section);
            }
        }
        catch (Exception e) {
            UtilitiX.getInstance().logger.error("Something went wrong during loading old chunks stickiness", (Throwable)e);
        }
    }

    public void read(CompoundTag nbt) {
        this.sections.clear();
        for (String key : nbt.m_128431_()) {
            if (!nbt.m_128425_(key, 7)) {
                UtilitiX.getInstance().logger.error("Invalid chunk section value in sticky chunk for: " + key);
                continue;
            }
            try {
                int sectionId = Integer.parseInt(key);
                StickySection section = new StickySection(this);
                section.setStickies(nbt.m_128463_(key));
                this.sections.put(sectionId, section);
            }
            catch (NumberFormatException e) {
                UtilitiX.getInstance().logger.error("Invalid chunk section id in sticky chunk: " + key);
            }
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.sections.size());
        for (Map.Entry<Integer, StickySection> entry : this.sections.entrySet()) {
            buffer.m_130130_(entry.getKey().intValue());
            entry.getValue().writeRawDataToBuffer(buffer);
        }
    }

    public void read(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        this.sections.clear();
        for (int i = 0; i < size; ++i) {
            int sectionId = buffer.m_130242_();
            StickySection section = new StickySection(this);
            section.readRawDataFromBuffer(buffer);
            this.sections.put(sectionId, section);
        }
    }

    public void loadFrom(StickyChunk networkChunk) {
        if (networkChunk.chunk != null) {
            throw new IllegalArgumentException("Can't copy data from attached chunk");
        }
        this.sections.clear();
        this.sections.putAll(networkChunk.sections);
        networkChunk.sections.clear();
    }

    public static interface ChunkAction {
        @Nullable
        public SectionAction section(int var1, int var2);
    }

    public static interface SectionAction {
        public void start();

        public void accept(int var1, int var2, int var3, byte var4);

        public void stop();
    }
}

