/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.gildingarmor;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.registration.ModItems;
import de.melanx.utilitix.registration.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.compress.utils.Lists;

public class GildingArmorRecipe
extends UpgradeRecipe {
    public GildingArmorRecipe(ResourceLocation id) {
        super(id, Ingredient.f_43901_, Ingredient.f_43901_, ItemStack.f_41583_);
    }

    public boolean m_5818_(@Nonnull Container inv, @Nonnull Level level) {
        ItemStack input = inv.m_8020_(0);
        ItemStack addition = inv.m_8020_(1);
        if (input.m_41720_() instanceof ArmorItem && !GildingArmorRecipe.isGilded(input) && GildingArmorRecipe.canGild((ArmorItem)input.m_41720_())) {
            return addition.m_41720_() == ModItems.gildingCrystal;
        }
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull Container inv) {
        ItemStack stack = inv.m_8020_(0).m_41777_();
        stack.m_41784_().m_128379_("Gilded_UtilitiX", true);
        return stack;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public boolean m_44535_(@Nonnull ItemStack addition) {
        return addition.m_41720_() == ModItems.gildingCrystal;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.GILDING_SERIALIZER;
    }

    public static boolean isGilded(ItemStack stack) {
        return stack.m_41782_() && stack.m_41784_().m_128471_("Gilded_UtilitiX");
    }

    public static boolean canGild(ArmorItem item) {
        return !item.makesPiglinsNeutral(new ItemStack((ItemLike)item), null) && item.m_40401_() != ArmorMaterials.GOLD;
    }

    public static List<UpgradeRecipe> getRecipes() {
        ArrayList recipes = Lists.newArrayList();
        Ingredient gildingItem = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.gildingCrystal});
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (!(item instanceof ArmorItem) || !GildingArmorRecipe.canGild((ArmorItem)item)) continue;
            ResourceLocation id = new ResourceLocation(UtilitiX.getInstance().modid, "gilding." + item.m_5524_());
            ItemStack output = new ItemStack((ItemLike)item);
            output.m_41784_().m_128379_("Gilded_UtilitiX", true);
            UpgradeRecipe recipe = new UpgradeRecipe(id, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), gildingItem, output);
            recipes.add(recipe);
        }
        return recipes;
    }
}

