/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.bell;

import de.melanx.utilitix.UtilitiXConfig;
import de.melanx.utilitix.content.bell.RenderBell;
import de.melanx.utilitix.registration.ModEnchantments;
import io.github.noeppi_noeppi.libx.base.ItemBase;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.fml.ModList;

public abstract class BellBase
extends ItemBase {
    public BellBase(ModX mod, Item.Properties properties) {
        super(mod, properties);
    }

    public void initializeClient(@Nonnull Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return new RenderBell(new BlockEntityRendererProvider.Context(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_91289_(), Minecraft.m_91087_().m_167973_(), Minecraft.m_91087_().f_91062_));
            }
        });
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        boolean ringed;
        if (count % 4 == 0 && (ringed = this.dinkDonk(entity, stack)) && entity instanceof Player) {
            ((Player)entity).m_36220_(Stats.f_12979_);
        }
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return UtilitiXConfig.HandBells.ringTime;
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity entityLiving) {
        double range = (double)UtilitiXConfig.HandBells.glowRadius * (1.0 + (double)EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.bellRange, (ItemStack)stack) * 0.25);
        List entities = level.m_6443_(LivingEntity.class, new AABB(entityLiving.m_20185_() - range, entityLiving.m_20186_() - range, entityLiving.m_20189_() - range, entityLiving.m_20185_() + range, entityLiving.m_20186_() + range, entityLiving.m_20189_() + range), livingEntity -> this.entityFilter((LivingEntity)livingEntity, stack));
        entities.forEach(e -> e.m_7292_(new MobEffectInstance(MobEffects.f_19619_, UtilitiXConfig.HandBells.glowTime)));
        return super.m_5922_(stack, level, entityLiving);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public boolean dinkDonk(LivingEntity entity, ItemStack stack) {
        Level level = entity.m_20193_();
        BlockPos pos = entity.m_142538_();
        if (!level.f_46443_) {
            if (this.notifyNearbyEntities()) {
                double range = (double)UtilitiXConfig.HandBells.notifyRadius * (1.0 + (double)EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.bellRange, (ItemStack)stack) * 0.25);
                List entities = entity.m_20193_().m_45976_(LivingEntity.class, new AABB(entity.m_20185_() - range, entity.m_20186_() - range, entity.m_20189_() - range, entity.m_20185_() + range, entity.m_20186_() + range, entity.m_20189_() + range));
                for (LivingEntity e : entities) {
                    e.m_6274_().m_21879_(MemoryModuleType.f_26325_, (Object)level.m_46467_());
                }
            }
            level.m_5594_(null, pos, SoundEvents.f_11699_, SoundSource.BLOCKS, 2.0f, 1.0f);
            return true;
        }
        return false;
    }

    protected abstract boolean entityFilter(LivingEntity var1, ItemStack var2);

    protected abstract boolean notifyNearbyEntities();

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (ModList.get().isLoaded("emojiful")) {
            tooltip.add((Component)new TextComponent(":DinkDonk:"));
        }
    }
}

