/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.xplat;

import at.petrak.hexcasting.api.addldata.Colorizer;
import at.petrak.hexcasting.api.addldata.DataHolder;
import at.petrak.hexcasting.api.addldata.HexHolder;
import at.petrak.hexcasting.api.addldata.ManaHolder;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.mod.HexItemTags;
import at.petrak.hexcasting.api.player.FlightAbility;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ResolvedPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.network.IMessage;
import at.petrak.hexcasting.forge.cap.CapSyncers;
import at.petrak.hexcasting.forge.cap.HexCapabilities;
import at.petrak.hexcasting.forge.interop.curios.CuriosApiInterop;
import at.petrak.hexcasting.forge.network.ForgePacketHandler;
import at.petrak.hexcasting.forge.network.MsgBrainsweepAck;
import at.petrak.hexcasting.forge.recipe.ForgeUnsealedIngredient;
import at.petrak.hexcasting.interop.pehkui.PehkuiInterop;
import at.petrak.hexcasting.mixin.accessor.AccessorVillager;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import at.petrak.hexcasting.xplat.IXplatTags;
import at.petrak.hexcasting.xplat.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.api.ScaleTypes;

public class ForgeXplatImpl
implements IXplatAbstractions {
    private static CreativeModeTab TAB = null;
    private static final IXplatTags TAGS = new IXplatTags(){

        @Override
        public TagKey<Item> amethystDust() {
            return HexItemTags.create(new ResourceLocation("forge", "dusts/amethyst"));
        }

        @Override
        public TagKey<Item> gems() {
            return HexItemTags.create(new ResourceLocation("forge", "gems"));
        }
    };
    private static PehkuiInterop.ApiAbstraction PEHKUI_API = null;
    public static final String TAG_BRAINSWEPT = "hexcasting:brainswept";
    public static final String TAG_SENTINEL_EXISTS = "hexcasting:sentinel_exists";
    public static final String TAG_SENTINEL_GREATER = "hexcasting:sentinel_extends_range";
    public static final String TAG_SENTINEL_POSITION = "hexcasting:sentinel_position";
    public static final String TAG_SENTINEL_DIMENSION = "hexcasting:sentinel_dimension";
    public static final String TAG_COLOR = "hexcasting:colorizer";
    public static final String TAG_FLIGHT_ALLOWED = "hexcasting:flight_allowed";
    public static final String TAG_FLIGHT_TIME = "hexcasting:flight_time";
    public static final String TAG_FLIGHT_ORIGIN = "hexcasting:flight_origin";
    public static final String TAG_FLIGHT_DIMENSION = "hexcasting:flight_dimension";
    public static final String TAG_FLIGHT_RADIUS = "hexcasting:flight_radius";
    public static final String TAG_HARNESS = "hexcasting:spell_harness";
    public static final String TAG_PATTERNS = "hexcasting:spell_patterns";

    @Override
    public Platform platform() {
        return Platform.FORGE;
    }

    @Override
    public boolean isPhysicalClient() {
        return FMLLoader.getDist() == Dist.CLIENT;
    }

    @Override
    public boolean isModPresent(String id) {
        return ModList.get().isLoaded(id);
    }

    @Override
    public void initPlatformSpecific() {
        if (this.isModPresent("curios")) {
            CuriosApiInterop.init();
        }
    }

    @Override
    public double getReachDistance(Player player) {
        return player.m_21133_((Attribute)ForgeMod.REACH_DISTANCE.get());
    }

    @Override
    public void brainsweep(Mob mob) {
        mob.getPersistentData().m_128379_(TAG_BRAINSWEPT, true);
        mob.m_147272_();
        if (mob instanceof Villager) {
            Villager villager2 = (Villager)mob;
            ((AccessorVillager)villager2).hex$releaseAllPois();
        }
        if (mob.f_19853_ instanceof ServerLevel) {
            ForgePacketHandler.getNetwork().send(PacketDistributor.TRACKING_ENTITY.with(() -> mob), (Object)MsgBrainsweepAck.of((Entity)mob));
        }
    }

    @Override
    public void setFlight(ServerPlayer player, FlightAbility flight) {
        CompoundTag tag = player.getPersistentData();
        tag.m_128379_(TAG_FLIGHT_ALLOWED, flight.allowed());
        if (flight.allowed()) {
            tag.m_128405_(TAG_FLIGHT_TIME, flight.timeLeft());
            tag.m_128365_(TAG_FLIGHT_ORIGIN, (Tag)HexUtils.serializeToNBT(flight.origin()));
            tag.m_128359_(TAG_FLIGHT_DIMENSION, flight.dimension().m_135782_().toString());
            tag.m_128347_(TAG_FLIGHT_RADIUS, flight.radius());
        } else {
            tag.m_128473_(TAG_FLIGHT_TIME);
            tag.m_128473_(TAG_FLIGHT_ORIGIN);
            tag.m_128473_(TAG_FLIGHT_DIMENSION);
            tag.m_128473_(TAG_FLIGHT_RADIUS);
        }
    }

    @Override
    public void setColorizer(Player player, FrozenColorizer colorizer) {
        CompoundTag tag = player.getPersistentData();
        tag.m_128365_(TAG_COLOR, (Tag)colorizer.serializeToNBT());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CapSyncers.syncColorizer(serverPlayer);
        }
    }

    @Override
    public void setSentinel(Player player, Sentinel sentinel) {
        CompoundTag tag = player.getPersistentData();
        tag.m_128379_(TAG_SENTINEL_EXISTS, sentinel.hasSentinel());
        if (sentinel.hasSentinel()) {
            tag.m_128379_(TAG_SENTINEL_GREATER, sentinel.extendsRange());
            tag.m_128365_(TAG_SENTINEL_POSITION, (Tag)HexUtils.serializeToNBT(sentinel.position()));
            tag.m_128359_(TAG_SENTINEL_DIMENSION, sentinel.dimension().m_135782_().toString());
        } else {
            tag.m_128473_(TAG_SENTINEL_GREATER);
            tag.m_128473_(TAG_SENTINEL_POSITION);
            tag.m_128473_(TAG_SENTINEL_DIMENSION);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CapSyncers.syncSentinel(serverPlayer);
        }
    }

    @Override
    public void setHarness(ServerPlayer player, CastingHarness harness) {
        player.getPersistentData().m_128365_(TAG_HARNESS, (Tag)(harness == null ? new CompoundTag() : harness.serializeToNBT()));
    }

    @Override
    public void setPatterns(ServerPlayer player, List<ResolvedPattern> patterns) {
        ListTag listTag = new ListTag();
        for (ResolvedPattern pattern : patterns) {
            listTag.add((Object)pattern.serializeToNBT());
        }
        player.getPersistentData().m_128365_(TAG_PATTERNS, (Tag)listTag);
    }

    @Override
    public boolean isBrainswept(Mob e) {
        return e.getPersistentData().m_128471_(TAG_BRAINSWEPT);
    }

    @Override
    public FlightAbility getFlight(ServerPlayer player) {
        CompoundTag tag = player.getPersistentData();
        boolean allowed = tag.m_128471_(TAG_FLIGHT_ALLOWED);
        if (allowed) {
            int timeLeft = tag.m_128451_(TAG_FLIGHT_TIME);
            Vec3 origin = HexUtils.vecFromNBT(tag.m_128467_(TAG_FLIGHT_ORIGIN));
            double radius = tag.m_128459_(TAG_FLIGHT_RADIUS);
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_(TAG_FLIGHT_DIMENSION)));
            return new FlightAbility(true, timeLeft, (ResourceKey<Level>)dimension, origin, radius);
        }
        return FlightAbility.deny();
    }

    @Override
    public FrozenColorizer getColorizer(Player player) {
        return FrozenColorizer.fromNBT(player.getPersistentData().m_128469_(TAG_COLOR));
    }

    @Override
    public Sentinel getSentinel(Player player) {
        CompoundTag tag = player.getPersistentData();
        boolean exists = tag.m_128471_(TAG_SENTINEL_EXISTS);
        if (!exists) {
            return Sentinel.none();
        }
        boolean extendsRange = tag.m_128471_(TAG_SENTINEL_GREATER);
        Vec3 position = HexUtils.vecFromNBT(tag.m_128467_(TAG_SENTINEL_POSITION));
        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_(TAG_SENTINEL_DIMENSION)));
        return new Sentinel(true, extendsRange, position, (ResourceKey<Level>)dimension);
    }

    @Override
    public CastingHarness getHarness(ServerPlayer player, InteractionHand hand) {
        CastingContext ctx = new CastingContext(player, hand);
        return CastingHarness.fromNBT(player.getPersistentData().m_128469_(TAG_HARNESS), ctx);
    }

    @Override
    public List<ResolvedPattern> getPatterns(ServerPlayer player) {
        ListTag patternsTag = player.getPersistentData().m_128437_(TAG_PATTERNS, 10);
        ArrayList<ResolvedPattern> patterns = new ArrayList<ResolvedPattern>(patternsTag.size());
        for (int i = 0; i < patternsTag.size(); ++i) {
            patterns.add(ResolvedPattern.fromNBT(patternsTag.m_128728_(i)));
        }
        return patterns;
    }

    @Override
    public void clearCastingData(ServerPlayer player) {
        player.getPersistentData().m_128473_(TAG_HARNESS);
        player.getPersistentData().m_128473_(TAG_PATTERNS);
    }

    @Override
    @Nullable
    public ManaHolder findManaHolder(ItemStack stack) {
        Optional maybeCap = stack.getCapability(HexCapabilities.MANA).resolve();
        return maybeCap.orElse(null);
    }

    @Override
    @Nullable
    public DataHolder findDataHolder(ItemStack stack) {
        Optional maybeCap = stack.getCapability(HexCapabilities.DATUM).resolve();
        return maybeCap.orElse(null);
    }

    @Override
    @Nullable
    public HexHolder findHexHolder(ItemStack stack) {
        Optional maybeCap = stack.getCapability(HexCapabilities.STORED_HEX).resolve();
        return maybeCap.orElse(null);
    }

    @Override
    public boolean isColorizer(ItemStack stack) {
        return stack.getCapability(HexCapabilities.COLOR).isPresent();
    }

    @Override
    public int getRawColor(FrozenColorizer colorizer, float time, Vec3 position) {
        Optional maybeColorizer = colorizer.item().getCapability(HexCapabilities.COLOR).resolve();
        if (maybeColorizer.isPresent()) {
            Colorizer col = (Colorizer)maybeColorizer.get();
            return col.color(colorizer.owner(), time, position);
        }
        return -65316;
    }

    @Override
    public void sendPacketToPlayer(ServerPlayer target, IMessage packet) {
        ForgePacketHandler.getNetwork().send(PacketDistributor.PLAYER.with(() -> target), (Object)packet);
    }

    @Override
    public void sendPacketNear(Vec3 pos, double radius, ServerLevel dimension, IMessage packet) {
        ForgePacketHandler.getNetwork().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(pos.f_82479_, pos.f_82480_, pos.f_82481_, radius * radius, dimension.m_46472_())), (Object)packet);
    }

    @Override
    public Packet<?> toVanillaClientboundPacket(IMessage message) {
        return ForgePacketHandler.getNetwork().toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> func, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(func::apply, (Block[])blocks).m_58966_(null);
    }

    @Override
    public boolean tryPlaceFluid(Level level, InteractionHand hand, BlockPos pos, Fluid fluid) {
        Optional handler = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)Direction.UP).resolve();
        return handler.isPresent() && ((IFluidHandler)handler.get()).fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE) > 0;
    }

    @Override
    public boolean drainAllFluid(Level level, BlockPos pos) {
        Optional handler = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)Direction.UP).resolve();
        if (handler.isPresent()) {
            boolean any = false;
            IFluidHandler pool = (IFluidHandler)handler.get();
            for (int i = 0; i < pool.getTanks(); ++i) {
                if (pool.drain(pool.getFluidInTank(i), IFluidHandler.FluidAction.EXECUTE).isEmpty()) continue;
                any = true;
            }
            return any;
        }
        return false;
    }

    @Override
    public ResourceLocation getID(Block block) {
        return block.getRegistryName();
    }

    @Override
    public ResourceLocation getID(Item item) {
        return item.getRegistryName();
    }

    @Override
    public ResourceLocation getID(VillagerProfession profession) {
        return profession.getRegistryName();
    }

    @Override
    public Ingredient getUnsealedIngredient(ItemStack stack) {
        return ForgeUnsealedIngredient.of(stack);
    }

    @Override
    public CreativeModeTab getTab() {
        if (TAB == null) {
            TAB = new CreativeModeTab("hexcasting"){

                public ItemStack m_6976_() {
                    return HexItems.tabIcon();
                }

                public void m_6151_(NonNullList<ItemStack> p_40778_) {
                    super.m_6151_(p_40778_);
                }
            };
        }
        return TAB;
    }

    @Override
    public boolean isCorrectTierForDrops(Tier tier, BlockState bs) {
        return !bs.m_60834_() || TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)bs);
    }

    @Override
    public Item.Properties addEquipSlotFabric(EquipmentSlot slot) {
        return new Item.Properties();
    }

    @Override
    public IXplatTags tags() {
        return TAGS;
    }

    @Override
    public LootItemCondition.Builder isShearsCondition() {
        return CanToolPerformAction.canToolPerformAction((ToolAction)ToolActions.SHEARS_DIG);
    }

    @Override
    public String getModName(String namespace) {
        if (namespace.equals("c")) {
            return "Common";
        }
        Optional container = ModList.get().getModContainerById(namespace);
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getModInfo().getDisplayName();
        }
        return namespace;
    }

    @Override
    public boolean isBreakingAllowed(Level world, BlockPos pos, BlockState state, Player player) {
        return !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player));
    }

    @Override
    public boolean isPlacingAllowed(Level world, BlockPos pos, ItemStack blockStack, Player player) {
        ItemStack cached = player.m_21205_();
        player.m_21008_(InteractionHand.MAIN_HAND, blockStack.m_41777_());
        PlayerInteractEvent.RightClickBlock evt = ForgeHooks.onRightClickBlock((Player)player, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.DOWN, pos, true));
        player.m_21008_(InteractionHand.MAIN_HAND, cached);
        return !evt.isCanceled();
    }

    @Override
    public PehkuiInterop.ApiAbstraction getPehkuiApi() {
        if (!this.isModPresent("pehkui")) {
            throw new IllegalArgumentException("cannot get the pehkui api without pehkui");
        }
        if (PEHKUI_API == null) {
            PEHKUI_API = new PehkuiInterop.ApiAbstraction(){

                @Override
                public float getScale(Entity e) {
                    return ScaleTypes.BASE.getScaleData(e).getScale();
                }

                @Override
                public void setScale(Entity e, float scale) {
                    ScaleTypes.BASE.getScaleData(e).setScale(scale);
                }
            };
        }
        return PEHKUI_API;
    }
}

