/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.datagen.xplat;

import at.petrak.hexcasting.common.items.ItemFocus;
import at.petrak.hexcasting.common.items.ItemScroll;
import at.petrak.hexcasting.common.items.ItemSlate;
import at.petrak.hexcasting.common.items.ItemWand;
import at.petrak.hexcasting.common.items.colorizer.ItemPrideColorizer;
import at.petrak.hexcasting.common.items.magic.ItemManaBattery;
import at.petrak.hexcasting.common.items.magic.ItemPackagedHex;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.paucal.api.forge.datagen.PaucalItemModelProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class HexItemModels
extends PaucalItemModelProvider {
    private static final String[] DATUM_TYPES = new String[]{"empty", "entity", "double", "vec3", "widget", "list", "pattern"};
    private static final String[] PHIAL_SIZES = new String[]{"small", "medium", "large"};

    public HexItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "hexcasting", existingFileHelper);
    }

    /*
     * WARNING - void declaration
     */
    protected void registerModels() {
        void var2_6;
        this.simpleItem(HexItems.AMETHYST_DUST);
        this.simpleItem(HexItems.CHARGED_AMETHYST);
        this.simpleItem(HexItems.SUBMARINE_SANDWICH);
        this.simpleItem(HexItems.ABACUS);
        this.brandishedItem((Item)HexItems.JEWELER_HAMMER);
        this.simpleItem(HexItems.CREATIVE_UNLOCKER);
        this.singleTexture(HexBlocks.CONJURED_BLOCK.getRegistryName().m_135815_(), new ResourceLocation("item/generated"), "layer0", new ResourceLocation("item/amethyst_shard"));
        this.singleTexture(HexBlocks.CONJURED_LIGHT.getRegistryName().m_135815_(), new ResourceLocation("item/generated"), "layer0", new ResourceLocation("item/amethyst_shard"));
        for (String age : new String[]{"pristine", "ancient"}) {
            for (String size : new String[]{"small", "medium", "large"}) {
                this.simpleItem(this.modLoc("scroll_" + age + "_" + size));
            }
        }
        this.buildScroll(HexItems.SCROLL_SMOL, "small");
        this.buildScroll(HexItems.SCROLL_MEDIUM, "medium");
        this.buildScroll(HexItems.SCROLL_LARGE, "large");
        this.simpleItem(HexItems.SCRYING_LENS);
        ((ItemModelBuilder)this.getBuilder(HexItems.SCRYING_LENS.getRegistryName().m_135815_())).transforms().transform(ModelBuilder.Perspective.HEAD).rotation(0.0f, 0.0f, 0.0f).translation(-2.5f, 0.0f, -8.0f).scale(0.4f);
        this.singleTexture("wand_old", new ResourceLocation("item/handheld_rod"), "layer0", this.modLoc("item/wands/old"));
        this.singleTexture("wand_bosnia", new ResourceLocation("item/handheld_rod"), "layer0", this.modLoc("item/wands/bosnia"));
        this.buildWand(HexItems.WAND_OAK, "oak");
        this.buildWand(HexItems.WAND_BIRCH, "birch");
        this.buildWand(HexItems.WAND_SPRUCE, "spruce");
        this.buildWand(HexItems.WAND_JUNGLE, "jungle");
        this.buildWand(HexItems.WAND_DARK_OAK, "dark_oak");
        this.buildWand(HexItems.WAND_ACACIA, "acacia");
        this.buildWand(HexItems.WAND_CRIMSON, "crimson");
        this.buildWand(HexItems.WAND_WARPED, "warped");
        this.buildWand(HexItems.WAND_AKASHIC, "akashic");
        this.simpleItem(this.modLoc("patchouli_book"));
        for (int sealedIdx = 0; sealedIdx <= 1; ++sealedIdx) {
            boolean bl = sealedIdx == 1;
            int stringsLength = DATUM_TYPES.length;
            for (int i = 0; i < stringsLength; ++i) {
                String string = DATUM_TYPES[i];
                String suffix = string + (bl ? "_sealed" : "");
                String focusName = "focus_" + suffix;
                this.singleTexture(focusName, new ResourceLocation("item/generated"), "layer0", this.modLoc("item/focus/" + suffix));
                ((ItemModelBuilder)this.getBuilder(HexItems.FOCUS.getRegistryName().m_135815_())).override().predicate(ItemFocus.DATATYPE_PRED, (float)i).predicate(ItemFocus.SEALED_PRED, bl ? 1.0f : 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + focusName))).end();
                String spellbookName = "spellbook_" + string + (bl ? "_sealed" : "");
                this.singleTexture(spellbookName, new ResourceLocation("item/generated"), "layer0", this.modLoc("item/spellbook/" + suffix));
                ((ItemModelBuilder)this.getBuilder(HexItems.SPELLBOOK.getRegistryName().m_135815_())).override().predicate(ItemFocus.DATATYPE_PRED, (float)i).predicate(ItemFocus.SEALED_PRED, bl ? 1.0f : 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + spellbookName))).end();
            }
        }
        this.buildPackagedSpell(HexItems.CYPHER, "cypher");
        this.buildPackagedSpell(HexItems.TRINKET, "trinket");
        this.buildPackagedSpell(HexItems.ARTIFACT, "artifact");
        int maxFill = 4;
        boolean bl = false;
        while (var2_6 < PHIAL_SIZES.length) {
            for (int fill = 0; fill <= maxFill; ++fill) {
                String name = "phial_" + PHIAL_SIZES[var2_6] + "_" + fill;
                this.singleTexture(name, new ResourceLocation("item/generated"), "layer0", this.modLoc("item/phial/" + name));
                float f = (float)fill / (float)maxFill;
                ((ItemModelBuilder)this.getBuilder(HexItems.BATTERY.getRegistryName().m_135815_())).override().predicate(ItemManaBattery.MANA_PREDICATE, f).predicate(ItemManaBattery.MAX_MANA_PREDICATE, (float)var2_6).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + name))).end();
            }
            ++var2_6;
        }
        for (DyeColor dyeColor : DyeColor.values()) {
            this.singleTexture(HexItems.DYE_COLORIZERS.get(dyeColor).getRegistryName().m_135815_(), new ResourceLocation("item/generated"), "layer0", this.modLoc("item/colorizer/dye_" + dyeColor.m_41065_()));
        }
        for (ItemPrideColorizer.Type type : ItemPrideColorizer.Type.values()) {
            this.singleTexture(HexItems.PRIDE_COLORIZERS.get((Object)type).getRegistryName().m_135815_(), new ResourceLocation("item/generated"), "layer0", this.modLoc("item/colorizer/pride_" + type.getName()));
        }
        this.singleTexture(HexItems.UUID_COLORIZER.getRegistryName().m_135815_(), new ResourceLocation("item/generated"), "layer0", this.modLoc("item/colorizer/uuid"));
        this.simpleItem(this.modLoc("slate_blank"));
        this.simpleItem(this.modLoc("slate_written"));
        ((ItemModelBuilder)this.getBuilder(HexItems.SLATE.getRegistryName().m_135815_())).override().predicate(ItemSlate.WRITTEN_PRED, 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/slate_blank"))).end().override().predicate(ItemSlate.WRITTEN_PRED, 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/slate_written"))).end();
        ((ItemModelBuilder)this.getBuilder(HexBlocks.AKASHIC_RECORD.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/akashic_record")));
        this.simpleItem(this.modLoc("akashic_door"));
        ((ItemModelBuilder)this.getBuilder(HexBlocks.AKASHIC_TRAPDOOR.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/akashic_trapdoor_bottom")));
        ((ItemModelBuilder)this.getBuilder(HexBlocks.AKASHIC_LOG.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/akashic_log")));
        ((ItemModelBuilder)this.getBuilder(HexBlocks.AKASHIC_LOG_STRIPPED.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/akashic_log_stripped")));
        ((ItemModelBuilder)this.getBuilder(HexBlocks.AKASHIC_WOOD.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/akashic_wood")));
        ((ItemModelBuilder)this.getBuilder(HexBlocks.AKASHIC_WOOD_STRIPPED.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/akashic_wood_stripped")));
        ((ItemModelBuilder)this.getBuilder(HexBlocks.AKASHIC_STAIRS.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/akashic_stairs")));
        ((ItemModelBuilder)this.getBuilder(HexBlocks.AKASHIC_SLAB.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/akashic_slab")));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(HexBlocks.AKASHIC_BUTTON.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("block/button_inventory")))).texture("texture", this.modLoc("block/akashic/planks1"));
        ((ItemModelBuilder)this.getBuilder(HexBlocks.AKASHIC_PRESSURE_PLATE.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/akashic_pressure_plate")));
    }

    private void buildScroll(Item item, String size) {
        ((ItemModelBuilder)this.getBuilder(item.getRegistryName().m_135815_())).override().predicate(ItemScroll.ANCIENT_PREDICATE, 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/scroll_pristine_" + size))).end().override().predicate(ItemScroll.ANCIENT_PREDICATE, 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/scroll_ancient_" + size))).end();
    }

    private void buildWand(Item item, String name) {
        this.singleTexture(item.getRegistryName().m_135815_(), new ResourceLocation("item/handheld_rod"), "layer0", this.modLoc("item/wands/" + name));
        ((ItemModelBuilder)this.getBuilder(item.getRegistryName().m_135815_())).override().predicate(ItemWand.FUNNY_LEVEL_PREDICATE, 0.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/wand_" + name))).end().override().predicate(ItemWand.FUNNY_LEVEL_PREDICATE, 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/wand_old"))).end().override().predicate(ItemWand.FUNNY_LEVEL_PREDICATE, 2.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/wand_bosnia"))).end();
    }

    private void buildPackagedSpell(Item item, String name) {
        this.simpleItem(this.modLoc(name));
        this.simpleItem(this.modLoc(name + "_filled"));
        ((ItemModelBuilder)this.getBuilder(item.getRegistryName().m_135815_())).override().predicate(ItemPackagedHex.HAS_PATTERNS_PRED, -0.01f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + name))).end().override().predicate(ItemPackagedHex.HAS_PATTERNS_PRED, 0.99f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + name + "_filled"))).end();
    }
}

