/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.datagen;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.loot.HexLootHandler;
import at.petrak.hexcasting.common.loot.PatternScrollFunc;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import at.petrak.paucal.api.datagen.PaucalLootTableProvider;
import java.util.Map;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.AlternativeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class HexLootTables
extends PaucalLootTableProvider {
    public HexLootTables(DataGenerator pGenerator) {
        super(pGenerator);
    }

    protected void makeLootTables(Map<Block, LootTable.Builder> blockTables, Map<ResourceLocation, LootTable.Builder> lootTables) {
        this.dropSelf(blockTables, new Block[]{HexBlocks.EMPTY_IMPETUS, HexBlocks.IMPETUS_RIGHTCLICK, HexBlocks.IMPETUS_LOOK, HexBlocks.IMPETUS_STOREDPLAYER, HexBlocks.DIRECTRIX_REDSTONE, HexBlocks.EMPTY_DIRECTRIX, HexBlocks.AKASHIC_RECORD, HexBlocks.AKASHIC_BOOKSHELF, HexBlocks.AKASHIC_CONNECTOR, HexBlocks.SLATE_BLOCK, HexBlocks.AMETHYST_DUST_BLOCK, HexBlocks.AMETHYST_TILES, HexBlocks.SCROLL_PAPER, HexBlocks.ANCIENT_SCROLL_PAPER, HexBlocks.SCROLL_PAPER_LANTERN, HexBlocks.ANCIENT_SCROLL_PAPER_LANTERN, HexBlocks.SCONCE, HexBlocks.AKASHIC_LOG, HexBlocks.AKASHIC_LOG_STRIPPED, HexBlocks.AKASHIC_WOOD, HexBlocks.AKASHIC_WOOD_STRIPPED, HexBlocks.AKASHIC_PLANKS, HexBlocks.AKASHIC_TILE, HexBlocks.AKASHIC_PANEL, HexBlocks.AKASHIC_TRAPDOOR, HexBlocks.AKASHIC_STAIRS, HexBlocks.AKASHIC_PRESSURE_PLATE, HexBlocks.AKASHIC_BUTTON});
        this.makeSlabTable(blockTables, (Block)HexBlocks.AKASHIC_SLAB);
        this.makeLeafTable(blockTables, (Block)HexBlocks.AKASHIC_LEAVES1);
        this.makeLeafTable(blockTables, (Block)HexBlocks.AKASHIC_LEAVES2);
        this.makeLeafTable(blockTables, (Block)HexBlocks.AKASHIC_LEAVES3);
        LootPool.Builder slatePool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)HexBlocks.SLATE).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("pattern", "BlockEntityTag.pattern")));
        blockTables.put(HexBlocks.SLATE, LootTable.m_79147_().m_79161_(slatePool));
        LootPool.Builder doorPool = this.dropThisPool((ItemLike)HexBlocks.AKASHIC_DOOR, 1).m_6509_((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)HexBlocks.AKASHIC_DOOR).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER)));
        blockTables.put((Block)HexBlocks.AKASHIC_DOOR, LootTable.m_79147_().m_79161_(doorPool));
        LootItemCondition.Builder noSilkTouchCond = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.f_55364_))).m_81807_();
        LootItemCondition.Builder goodAtAmethystingCond = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_144323_));
        LootPool.Builder dustPoolWhenGood = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)HexItems.AMETHYST_DUST)).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_6509_(noSilkTouchCond).m_6509_(goodAtAmethystingCond);
        LootPool.Builder dustPoolWhenBad = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)HexItems.AMETHYST_DUST)).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_6509_(noSilkTouchCond).m_6509_(goodAtAmethystingCond.m_81807_());
        LootPool.Builder isThatAnMFingBrandonSandersonReference = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)HexItems.CHARGED_AMETHYST)).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(noSilkTouchCond).m_6509_(goodAtAmethystingCond).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.25f, 0.35f, 0.5f, 0.75f, 1.0f}));
        LootPool.Builder isThatAnMFingBadBrandonSandersonReference = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)HexItems.CHARGED_AMETHYST)).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(noSilkTouchCond).m_6509_(goodAtAmethystingCond.m_81807_()).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.125f));
        lootTables.put(HexLootHandler.TABLE_INJECT_AMETHYST_CLUSTER, LootTable.m_79147_().m_79161_(dustPoolWhenGood).m_79161_(dustPoolWhenBad).m_79161_(isThatAnMFingBrandonSandersonReference).m_79161_(isThatAnMFingBadBrandonSandersonReference));
        String[] rarities = new String[]{"few", "some", "many"};
        for (int i = 0; i < rarities.length; ++i) {
            LootTable.Builder scrollPool = this.makeScrollAdder(i + 1);
            lootTables.put(HexAPI.modLoc("inject/scroll_loot_" + rarities[i]), scrollPool);
        }
    }

    private void makeLeafTable(Map<Block, LootTable.Builder> lootTables, Block block) {
        LootPool.Builder leafPool = this.dropThisPool((ItemLike)block, 1).m_6509_((LootItemCondition.Builder)new AlternativeLootItemCondition.Builder(new LootItemCondition.Builder[]{IXplatAbstractions.INSTANCE.isShearsCondition(), MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))}));
        lootTables.put(block, LootTable.m_79147_().m_79161_(leafPool));
    }

    private void makeSlabTable(Map<Block, LootTable.Builder> lootTables, Block block) {
        LootPool.Builder leafPool = this.dropThisPool((ItemLike)block, 1).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder(block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))).m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_());
        lootTables.put(block, LootTable.m_79147_().m_79161_(leafPool));
    }

    private LootTable.Builder makeScrollAdder(float stddev) {
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)(-stddev), (float)stddev)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)HexItems.SCROLL_LARGE)).m_5577_(() -> new PatternScrollFunc(new LootItemCondition[0]));
        return LootTable.m_79147_().m_79161_(pool);
    }
}

