/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.item.ManaHolderItem;
import at.petrak.hexcasting.api.utils.ManaHelper;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class ItemManaHolder
extends Item
implements ManaHolderItem {
    public static final String TAG_MANA = "hexcasting:mana";
    public static final String TAG_MAX_MANA = "hexcasting:start_mana";
    public static final TextColor HEX_COLOR = TextColor.m_131266_((int)11767539);
    private static final DecimalFormat PERCENTAGE = new DecimalFormat("####");
    private static final DecimalFormat DUST_AMOUNT;

    public ItemManaHolder(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ItemStack withMana(ItemStack stack, int mana, int maxMana) {
        Item item = stack.m_41720_();
        if (item instanceof ItemManaHolder) {
            NBTHelper.putInt(stack, TAG_MANA, mana);
            NBTHelper.putInt(stack, TAG_MAX_MANA, maxMana);
        }
        return stack;
    }

    @Override
    public int getMana(ItemStack stack) {
        return NBTHelper.getInt(stack, TAG_MANA);
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return NBTHelper.getInt(stack, TAG_MAX_MANA);
    }

    @Override
    public void setMana(ItemStack stack, int mana) {
        NBTHelper.putInt(stack, TAG_MANA, Mth.m_14045_((int)mana, (int)0, (int)this.getMaxMana(stack)));
    }

    public boolean m_142522_(ItemStack pStack) {
        return this.getMaxMana(pStack) > 0;
    }

    public int m_142159_(ItemStack pStack) {
        int mana = this.getMana(pStack);
        int maxMana = this.getMaxMana(pStack);
        return ManaHelper.manaBarColor(mana, maxMana);
    }

    public int m_142158_(ItemStack pStack) {
        int mana = this.getMana(pStack);
        int maxMana = this.getMaxMana(pStack);
        return ManaHelper.manaBarWidth(mana, maxMana);
    }

    public boolean m_41465_() {
        return false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        int maxMana = this.getMaxMana(pStack);
        if (maxMana > 0) {
            int mana = this.getMana(pStack);
            float fullness = this.getManaFullness(pStack);
            TextColor color = TextColor.m_131266_((int)ManaHelper.manaBarColor(mana, maxMana));
            TextComponent manaAmount = new TextComponent(DUST_AMOUNT.format((float)mana / 10000.0f));
            TextComponent percentFull = new TextComponent(PERCENTAGE.format(100.0f * fullness) + "%");
            TranslatableComponent maxCapacity = new TranslatableComponent("hexcasting.tooltip.mana", new Object[]{DUST_AMOUNT.format((float)maxMana / 10000.0f)});
            manaAmount.m_130938_(style -> style.m_131148_(HEX_COLOR));
            maxCapacity.m_130938_(style -> style.m_131148_(HEX_COLOR));
            percentFull.m_130938_(style -> style.m_131148_(color));
            pTooltipComponents.add((Component)new TranslatableComponent("hexcasting.tooltip.mana_amount.advanced", new Object[]{manaAmount, maxCapacity, percentFull}));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    static {
        PERCENTAGE.setRoundingMode(RoundingMode.DOWN);
        DUST_AMOUNT = new DecimalFormat("###,###.##");
    }
}

