/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.command;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.command.PatternResLocArgument;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ListPatternsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hexcasting:patterns").requires(dp -> dp.m_6761_(3))).then(Commands.m_82127_((String)"list").executes(ctx -> {
            Map<String, Pair<ResourceLocation, HexDir>> lookup = PatternRegistry.getPerWorldPatterns(((CommandSourceStack)ctx.getSource()).m_81372_());
            List listing = lookup.entrySet().stream().sorted((a, b) -> ListPatternsCommand.compareResLoc((ResourceLocation)((Pair)a.getValue()).getFirst(), (ResourceLocation)((Pair)b.getValue()).getFirst())).toList();
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("command.hexcasting.pats.listing"), false);
            for (Map.Entry pair : listing) {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent(((ResourceLocation)((Pair)pair.getValue()).getFirst()).toString()).m_130946_(": ").m_7220_(SpellDatum.make(HexPattern.fromAngles((String)pair.getKey(), (HexDir)((Object)((Object)((Pair)pair.getValue()).getSecond())))).display()), false);
            }
            return lookup.size();
        }))).then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"patternName", (ArgumentType)PatternResLocArgument.id()).executes(ctx -> {
            Entity sender = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (sender instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)sender;
                ResourceLocation targetId = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"patternName");
                HexPattern pat = PatternResLocArgument.getPattern((CommandContext<CommandSourceStack>)ctx, "patternName");
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("op_id", targetId.toString());
                tag.m_128365_("pattern", (Tag)pat.serializeToNBT());
                ItemStack stack = new ItemStack((ItemLike)HexItems.SCROLL_LARGE);
                stack.m_41751_(tag);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("command.hexcasting.pats.specific.success", new Object[]{stack.m_41611_(), targetId}), true);
                ItemEntity stackEntity = player.m_36176_(stack, false);
                if (stackEntity != null) {
                    stackEntity.m_32061_();
                    stackEntity.m_32047_(player.m_142081_());
                }
                return 1;
            }
            return 0;
        })))).then(Commands.m_82127_((String)"giveAll").executes(ctx -> {
            Entity sender = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (sender instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)sender;
                Map<String, Pair<ResourceLocation, HexDir>> lookup = PatternRegistry.getPerWorldPatterns(((CommandSourceStack)ctx.getSource()).m_81372_());
                lookup.forEach((pattern, entry) -> {
                    ResourceLocation opId = (ResourceLocation)entry.component1();
                    HexDir startDir = (HexDir)((Object)((Object)((Object)entry.component2())));
                    CompoundTag tag = new CompoundTag();
                    tag.m_128359_("op_id", opId.toString());
                    tag.m_128365_("pattern", (Tag)HexPattern.fromAngles(pattern, startDir).serializeToNBT());
                    ItemStack stack = new ItemStack((ItemLike)HexItems.SCROLL_LARGE);
                    stack.m_41751_(tag);
                    ItemEntity stackEntity = player.m_36176_(stack, false);
                    if (stackEntity != null) {
                        stackEntity.m_32061_();
                        stackEntity.m_32047_(player.m_142081_());
                    }
                });
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("command.hexcasting.pats.all", new Object[]{lookup.size()}), true);
                return lookup.size();
            }
            return 0;
        })));
    }

    private static int compareResLoc(ResourceLocation a, ResourceLocation b) {
        int ns = a.m_135827_().compareTo(b.m_135827_());
        if (ns != 0) {
            return ns;
        }
        return a.m_135815_().compareTo(b.m_135815_());
    }
}

