/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.operators.spells;

import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.RenderedSpell;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.SpellOperator;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.SpellContinuation;
import at.petrak.hexcasting.api.spell.mishaps.MishapImmuneEntity;
import at.petrak.hexcasting.api.spell.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.api.spell.mishaps.MishapLocationTooFarAway;
import at.petrak.hexcasting.api.spell.mishaps.MishapNotEnoughArgs;
import at.petrak.hexcasting.common.casting.operators.spells.great.OpTeleport;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lat/petrak/hexcasting/common/casting/operators/spells/OpBlink;", "Lat/petrak/hexcasting/api/spell/SpellOperator;", "()V", "argc", "", "getArgc", "()I", "execute", "Lkotlin/Triple;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "", "Lat/petrak/hexcasting/api/spell/ParticleSpray;", "args", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "Spell", "hexcasting-forge-1.18.2"})
public final class OpBlink
implements SpellOperator {
    @NotNull
    public static final OpBlink INSTANCE = new OpBlink();
    private static final int argc = 2;

    private OpBlink() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Triple<RenderedSpell, Integer, List<ParticleSpray>> execute(@NotNull List<? extends SpellDatum<?>> args, @NotNull CastingContext ctx) {
        int idx$iv;
        void $this$getChecked$iv22;
        int idx$iv2;
        void $this$getChecked$iv;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List<? extends SpellDatum<?>> list = args;
        boolean bl = false;
        int argc$iv22 = this.getArgc();
        boolean $i$f$getChecked = false;
        List<? extends SpellDatum<?>> list2 = $this$getChecked$iv;
        if (idx$iv2 > CollectionsKt.getLastIndex((List)list2)) {
            void it$iv = idx$iv2;
            boolean bl2 = false;
            throw new MishapNotEnoughArgs((int)(idx$iv2 + true), $this$getChecked$iv.size());
        }
        SpellDatum x$iv = (SpellDatum)list2.get(idx$iv2);
        if (!(x$iv.getPayload() instanceof Entity)) {
            throw MishapInvalidIota.Companion.ofClass(x$iv, argc$iv22 == 0 ? idx$iv2 : argc$iv22 - (idx$iv2 + true), Entity.class);
        }
        Entity target = (Entity)x$iv.getPayload();
        double argc$iv22 = 0.0;
        list2 = args;
        boolean it$iv = true;
        int argc$iv = this.getArgc();
        boolean $i$f$getChecked2 = false;
        void var12_22 = $this$getChecked$iv22;
        if (idx$iv > CollectionsKt.getLastIndex((List)var12_22)) {
            void it$iv2 = idx$iv;
            boolean bl3 = false;
            throw new MishapNotEnoughArgs((int)(idx$iv + true), $this$getChecked$iv22.size());
        }
        SpellDatum x$iv2 = (SpellDatum)var12_22.get(idx$iv);
        if (!(x$iv2.getPayload() instanceof Double)) {
            throw MishapInvalidIota.Companion.ofClass(x$iv2, argc$iv == 0 ? idx$iv : argc$iv - (idx$iv + true), Double.class);
        }
        double $this$getChecked$iv22 = ((Number)x$iv2.getPayload()).doubleValue();
        double delta = Math.max(argc$iv22, $this$getChecked$iv22);
        ctx.assertEntityInRange(target);
        if (!target.m_6072_()) {
            throw new MishapImmuneEntity(target);
        }
        Vec3 dvec = target.m_20154_().m_82490_(delta);
        Vec3 endPos = target.m_20182_().m_82549_(dvec);
        Vec3 vec3 = target.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"target.position()");
        ctx.assertVecInRange(vec3);
        Intrinsics.checkNotNullExpressionValue((Object)endPos, (String)"endPos");
        ctx.assertVecInRange(endPos);
        Vec3 vec32 = endPos.m_82492_(0.0, 1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"endPos.subtract(0.0, 1.0, 0.0)");
        if (!ctx.isVecInWorld(vec32)) {
            throw new MishapLocationTooFarAway(endPos, "too_close_to_out");
        }
        Vec3 targetMiddlePos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() / 2.0, 0.0);
        Spell spell = new Spell(target, delta);
        Integer n = MathKt.roundToInt((double)((double)50000 * delta * 0.5));
        Object[] objectArray = new ParticleSpray[2];
        Intrinsics.checkNotNullExpressionValue((Object)targetMiddlePos, (String)"targetMiddlePos");
        objectArray[0] = ParticleSpray.Companion.cloud(targetMiddlePos, 2.0, 50);
        Vec3 vec33 = targetMiddlePos.m_82549_(dvec);
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"targetMiddlePos.add(dvec)");
        objectArray[1] = ParticleSpray.Companion.burst(vec33, 2.0, 100);
        return new Triple((Object)spell, (Object)n, (Object)CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingContext ctx) {
        return SpellOperator.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingContext ctx) {
        return SpellOperator.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull SpellContinuation continuation, @NotNull List<SpellDatum<?>> stack, @NotNull SpellDatum<?> local, @NotNull CastingContext ctx) {
        return SpellOperator.DefaultImpls.operate(this, continuation, stack, local, ctx);
    }

    @Override
    public boolean isGreat() {
        return SpellOperator.DefaultImpls.isGreat(this);
    }

    @Override
    public boolean getAlwaysProcessGreatSpell() {
        return SpellOperator.DefaultImpls.getAlwaysProcessGreatSpell(this);
    }

    @Override
    public boolean getCausesBlindDiversion() {
        return SpellOperator.DefaultImpls.getCausesBlindDiversion(this);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return SpellOperator.DefaultImpls.getDisplayName(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lat/petrak/hexcasting/common/casting/operators/spells/OpBlink$Spell;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "target", "Lnet/minecraft/world/entity/Entity;", "delta", "", "(Lnet/minecraft/world/entity/Entity;D)V", "getDelta", "()D", "getTarget", "()Lnet/minecraft/world/entity/Entity;", "cast", "", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-forge-1.18.2"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final Entity target;
        private final double delta;

        public Spell(@NotNull Entity target, double delta) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.target = target;
            this.delta = delta;
        }

        @NotNull
        public final Entity getTarget() {
            return this.target;
        }

        public final double getDelta() {
            return this.delta;
        }

        @Override
        public void cast(@NotNull CastingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Vec3 delta = this.target.m_20154_().m_82490_(this.delta);
            Intrinsics.checkNotNullExpressionValue((Object)delta, (String)"delta");
            OpTeleport.INSTANCE.teleportRespectSticky(this.target, delta);
        }

        @NotNull
        public final Entity component1() {
            return this.target;
        }

        public final double component2() {
            return this.delta;
        }

        @NotNull
        public final Spell copy(@NotNull Entity target, double delta) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new Spell(target, delta);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, Entity entity, double d, int n, Object object) {
            if ((n & 1) != 0) {
                entity = spell.target;
            }
            if ((n & 2) != 0) {
                d = spell.delta;
            }
            return spell.copy(entity, d);
        }

        @NotNull
        public String toString() {
            return "Spell(target=" + this.target + ", delta=" + this.delta + ")";
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = result * 31 + Double.hashCode(this.delta);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.target, (Object)spell.target)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.delta, (Object)spell.delta);
        }
    }
}

