/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.entity;

import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockEntityStoredPlayerImpetus
extends BlockEntityAbstractImpetus {
    public static final String TAG_STORED_PLAYER = "stored_player";
    public static final String TAG_STORED_PLAYER_PROFILE = "stored_player_profile";
    private GameProfile storedPlayerProfile = null;
    private UUID storedPlayer = null;
    private GameProfile cachedDisplayProfile = null;
    private ItemStack cachedDisplayStack = null;

    public BlockEntityStoredPlayerImpetus(BlockPos pWorldPosition, BlockState pBlockState) {
        super(HexBlockEntities.IMPETUS_STOREDPLAYER_TILE, pWorldPosition, pBlockState);
    }

    @Override
    public boolean activatorAlwaysInRange() {
        return true;
    }

    @Override
    @Nullable
    protected Player getPlayer() {
        return this.storedPlayer == null ? null : this.f_58857_.m_46003_(this.storedPlayer);
    }

    @Nullable
    protected GameProfile getPlayerName() {
        Player player = this.getStoredPlayer();
        if (player != null) {
            return player.m_36316_();
        }
        return this.storedPlayerProfile;
    }

    public void setPlayer(GameProfile profile, UUID player) {
        this.storedPlayerProfile = profile;
        this.storedPlayer = player;
        this.m_6596_();
    }

    public void updatePlayerProfile() {
        GameProfile newProfile;
        Player player = this.getStoredPlayer();
        if (player != null && !(newProfile = player.m_36316_()).equals((Object)this.storedPlayerProfile)) {
            this.storedPlayerProfile = newProfile;
            this.m_6596_();
        }
    }

    @Nullable
    public Player getStoredPlayer() {
        return this.getPlayer();
    }

    @Override
    public void applyScryingLensOverlay(List<Pair<ItemStack, Component>> lines, BlockState state, BlockPos pos, Player observer, Level world, Direction hitFace) {
        super.applyScryingLensOverlay(lines, state, pos, observer, world, hitFace);
        GameProfile name = this.getPlayerName();
        if (name != null) {
            if (!name.equals((Object)this.cachedDisplayProfile) || this.cachedDisplayStack == null) {
                this.cachedDisplayProfile = name;
                ItemStack head = new ItemStack((ItemLike)Items.f_42680_);
                NBTHelper.put(head, "SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)name));
                head.m_41720_().m_142312_(head.m_41784_());
                this.cachedDisplayStack = head;
            }
            lines.add((Pair<ItemStack, Component>)new Pair((Object)this.cachedDisplayStack, (Object)new TranslatableComponent("hexcasting.tooltip.lens.impetus.storedplayer", new Object[]{name.getName()})));
        } else {
            lines.add((Pair<ItemStack, Component>)new Pair((Object)new ItemStack((ItemLike)Items.f_42127_), (Object)new TranslatableComponent("hexcasting.tooltip.lens.impetus.storedplayer.none")));
        }
    }

    @Override
    protected void saveModData(CompoundTag tag) {
        super.saveModData(tag);
        if (this.storedPlayer != null) {
            tag.m_128362_(TAG_STORED_PLAYER, this.storedPlayer);
        }
        if (this.storedPlayerProfile != null) {
            tag.m_128365_(TAG_STORED_PLAYER_PROFILE, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.storedPlayerProfile));
        }
    }

    @Override
    protected void loadModData(CompoundTag tag) {
        super.loadModData(tag);
        this.storedPlayer = tag.m_128425_(TAG_STORED_PLAYER, 11) ? tag.m_128342_(TAG_STORED_PLAYER) : null;
        this.storedPlayerProfile = tag.m_128425_(TAG_STORED_PLAYER_PROFILE, 10) ? NbtUtils.m_129228_((CompoundTag)tag.m_128469_(TAG_STORED_PLAYER_PROFILE)) : null;
    }
}

