/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.circles;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.blocks.circles.BlockEntitySlate;
import at.petrak.hexcasting.common.lib.HexItems;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockSlate
extends BlockCircleComponent
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<AttachFace> ATTACH_FACE = BlockStateProperties.f_61376_;
    public static final double THICKNESS = 1.0;
    public static final VoxelShape AABB_FLOOR = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final VoxelShape AABB_CEILING = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape AABB_EAST_WALL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    public static final VoxelShape AABB_WEST_WALL = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape AABB_SOUTH_WALL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    public static final VoxelShape AABB_NORTH_WALL = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockSlate(BlockBehaviour.Properties p_53182_) {
        super(p_53182_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ENERGIZED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7420_(BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    public boolean canEnterFromDirection(Direction enterDir, Direction normalDir, BlockPos pos, BlockState bs, Level world) {
        Direction thisNormal = this.normalDir(pos, bs, world);
        return enterDir != thisNormal && normalDir == thisNormal;
    }

    @Override
    public EnumSet<Direction> exitDirections(BlockPos pos, BlockState bs, Level world) {
        EnumSet<Direction> allDirs = EnumSet.allOf(Direction.class);
        Direction normal = this.normalDir(pos, bs, world);
        allDirs.remove(normal);
        allDirs.remove(normal.m_122424_());
        return allDirs;
    }

    @Override
    @Nullable
    public HexPattern getPattern(BlockPos pos, BlockState bs, Level world) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BlockEntitySlate) {
            BlockEntitySlate tile = (BlockEntitySlate)blockEntity;
            return tile.pattern;
        }
        return null;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof BlockEntitySlate) {
            BlockEntitySlate slate = (BlockEntitySlate)be;
            ItemStack stack = new ItemStack((ItemLike)HexItems.SLATE);
            if (slate.pattern != null) {
                HexItems.SLATE.writeDatum(stack, SpellDatum.make(slate.pattern));
            }
            return stack;
        }
        return new ItemStack((ItemLike)this);
    }

    @Override
    public Direction normalDir(BlockPos pos, BlockState bs, Level world, int recursionLeft) {
        return switch ((AttachFace)bs.m_61143_(ATTACH_FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> Direction.UP;
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.WALL -> (Direction)bs.m_61143_((Property)FACING);
        };
    }

    @Override
    public float particleHeight(BlockPos pos, BlockState bs, Level world) {
        return -0.4375f;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BlockEntitySlate(pPos, pState);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((AttachFace)pState.m_61143_(ATTACH_FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> AABB_FLOOR;
            case AttachFace.CEILING -> AABB_CEILING;
            case AttachFace.WALL -> {
                switch ((Direction)pState.m_61143_((Property)FACING)) {
                    case NORTH: {
                        yield AABB_NORTH_WALL;
                    }
                    case EAST: {
                        yield AABB_EAST_WALL;
                    }
                    case SOUTH: {
                        yield AABB_SOUTH_WALL;
                    }
                }
                yield AABB_WEST_WALL;
            }
        };
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.DESTROY;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, ATTACH_FACE, WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidState = pContext.m_43725_().m_6425_(pContext.m_8083_());
        for (Direction direction : pContext.m_6232_()) {
            BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACH_FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACH_FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!(blockstate = (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() == 8))).m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_())) continue;
            return blockstate;
        }
        return null;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return BlockSlate.canAttach(pLevel, pPos, BlockSlate.getConnectedDirection(pState).m_122424_());
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return BlockSlate.getConnectedDirection(pState).m_122424_() == pFacing && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? pState.m_60819_().m_76188_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public static boolean canAttach(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.m_142300_(pDirection);
        return pReader.m_8055_(blockpos).m_60783_((BlockGetter)pReader, blockpos, pDirection.m_122424_());
    }

    protected static Direction getConnectedDirection(BlockState pState) {
        return switch ((AttachFace)pState.m_61143_(ATTACH_FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)pState.m_61143_((Property)FACING);
        };
    }
}

