/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicFloodfiller;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicRecord;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockAkashicRecord
extends Block
implements EntityBlock {
    public BlockAkashicRecord(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BlockEntityAkashicRecord(pPos, pState);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity be = pLevel.m_7702_(pPos);
        if (be instanceof BlockEntityAkashicRecord) {
            BlockEntityAkashicRecord record = (BlockEntityAkashicRecord)be;
            return Math.min(15, record.getCount());
        }
        return 0;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        HashSet<BlockPos> seen = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        todo.add(pPos);
        while (!todo.isEmpty()) {
            BlockPos here = (BlockPos)todo.remove();
            for (Direction dir : Direction.values()) {
                BlockEntity blockEntity;
                BlockPos neighbor = here.m_142300_(dir);
                if (!seen.add(neighbor)) continue;
                BlockState bs = pLevel.m_8055_(neighbor);
                if (BlockAkashicFloodfiller.canItBeFloodedThrough(neighbor, bs, pLevel)) {
                    todo.add(neighbor);
                }
                if (!((blockEntity = pLevel.m_7702_(neighbor)) instanceof BlockEntityAkashicBookshelf)) continue;
                BlockEntityAkashicBookshelf shelf = (BlockEntityAkashicBookshelf)blockEntity;
                shelf.setNewData(null, null, DatumType.EMPTY);
            }
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }
}

