/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.gui;

import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.client.ClientTickCounter;
import at.petrak.hexcasting.client.RenderLib;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Pair;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.phys.Vec2;

public class PatternTooltipGreeble
implements ClientTooltipComponent,
TooltipComponent {
    public static final ResourceLocation PRISTINE_BG = new ResourceLocation("hexcasting:textures/gui/scroll.png");
    public static final ResourceLocation ANCIENT_BG = new ResourceLocation("hexcasting:textures/gui/scroll_ancient.png");
    public static final ResourceLocation SLATE_BG = new ResourceLocation("hexcasting:textures/gui/slate.png");
    private static final float SIZE = 72.0f;
    private final HexPattern pattern;
    private final List<Vec2> zappyPoints;
    private final List<Vec2> pathfinderDots;
    private final float scale;
    private final ResourceLocation background;

    public PatternTooltipGreeble(HexPattern pattern, ResourceLocation background) {
        this.pattern = pattern;
        this.background = background;
        Pair<Float, List<Vec2>> pair = RenderLib.getCenteredPattern(pattern, 72.0f, 72.0f, 8.0f);
        this.scale = ((Float)pair.getFirst()).floatValue();
        List dots = (List)pair.getSecond();
        this.zappyPoints = RenderLib.makeZappy((List<? extends Vec2>)dots, 10.0f, 0.8f, 0.0f, 0.0f);
        this.pathfinderDots = dots.stream().distinct().collect(Collectors.toList());
    }

    public void m_183452_(Font font, int mouseX, int mouseY, PoseStack ps, ItemRenderer pItemRenderer, int pBlitOffset) {
        int width = this.m_142069_(font);
        int height = this.m_142103_();
        ps.m_85836_();
        ps.m_85837_((double)mouseX, (double)mouseY, 500.0);
        RenderSystem.m_69478_();
        PatternTooltipGreeble.renderBG(ps, this.background);
        ps.m_85837_(0.0, 0.0, 100.0);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69464_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        ps.m_85837_((double)((float)width / 2.0f), (double)((float)height / 2.0f), 1.0);
        Matrix4f mat = ps.m_85850_().m_85861_();
        int outer = -2963256;
        int innerLight = -928275806;
        int innerDark = -936236237;
        RenderLib.drawLineSeq(mat, this.zappyPoints, 5.0f, 0.0f, outer, outer, null);
        RenderLib.drawLineSeq(mat, this.zappyPoints, 2.0f, 0.0f, innerDark, innerLight, Float.valueOf(ClientTickCounter.getTotal() / 40.0f));
        RenderLib.drawSpot(mat, this.zappyPoints.get(0), 2.5f, 1.0f, 0.1f, 0.15f, 0.6f);
        for (Vec2 dot : this.pathfinderDots) {
            RenderLib.drawSpot(mat, dot, 1.5f, 0.82f, 0.8f, 0.8f, 0.5f);
        }
        ps.m_85849_();
    }

    private static void renderBG(PoseStack ps, ResourceLocation background) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)background);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        Matrix4f neo = ps.m_85850_().m_85861_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(neo, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_85982_(neo, 0.0f, 72.0f, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_85982_(neo, 72.0f, 72.0f, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_85982_(neo, 72.0f, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)buffer);
    }

    public int m_142069_(Font pFont) {
        return 72;
    }

    public int m_142103_() {
        return 72;
    }
}

