/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.gui;

import at.petrak.hexcasting.api.misc.DiscoveryHandlers;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexItemTags;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.casting.ResolvedPattern;
import at.petrak.hexcasting.api.spell.casting.ResolvedPatternType;
import at.petrak.hexcasting.api.spell.math.HexAngle;
import at.petrak.hexcasting.api.spell.math.HexCoord;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.client.RenderLib;
import at.petrak.hexcasting.client.ShiftScrollListener;
import at.petrak.hexcasting.client.ktxt.ClientAccessorWrappers;
import at.petrak.hexcasting.client.sound.GridSoundInstance;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.network.MsgNewSpellPatternSyn;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00018B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J0\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001eH\u0016J \u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J \u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u001eH\u0016J\b\u0010,\u001a\u00020\u0019H\u0016J\u000e\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0013J\u0016\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020!J(\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u0002052\u0006\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020!2\u0006\u00106\u001a\u00020\u0017H\u0016J\b\u00107\u001a\u00020\u0019H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lat/petrak/hexcasting/client/gui/GuiSpellcasting;", "Lnet/minecraft/client/gui/screens/Screen;", "handOpenedWith", "Lnet/minecraft/world/InteractionHand;", "patterns", "", "Lat/petrak/hexcasting/api/spell/casting/ResolvedPattern;", "stackDescs", "", "Lnet/minecraft/network/chat/Component;", "(Lnet/minecraft/world/InteractionHand;Ljava/util/List;Ljava/util/List;)V", "ambianceSoundInstance", "Lat/petrak/hexcasting/client/sound/GridSoundInstance;", "drawState", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState;", "usedSpots", "", "Lat/petrak/hexcasting/api/spell/math/HexCoord;", "coordToPx", "Lnet/minecraft/world/phys/Vec2;", "coord", "coordsOffset", "hexSize", "", "init", "", "isPauseScreen", "", "mouseClicked", "mxOut", "", "myOut", "pButton", "", "mouseDragged", "pDragX", "pDragY", "mouseReleased", "mx", "my", "mouseScrolled", "pMouseX", "pMouseY", "pDelta", "onClose", "pxToCoord", "px", "recvServerUpdate", "info", "Lat/petrak/hexcasting/api/spell/casting/ControllerInfo;", "index", "render", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "pPartialTick", "tick", "PatternDrawState", "hexcasting-forge-1.18.2"})
public final class GuiSpellcasting
extends Screen {
    @NotNull
    private final InteractionHand handOpenedWith;
    @NotNull
    private List<ResolvedPattern> patterns;
    @NotNull
    private List<? extends Component> stackDescs;
    @NotNull
    private PatternDrawState drawState;
    @NotNull
    private final Set<HexCoord> usedSpots;
    @Nullable
    private GridSoundInstance ambianceSoundInstance;

    public GuiSpellcasting(@NotNull InteractionHand handOpenedWith, @NotNull List<ResolvedPattern> patterns, @NotNull List<? extends Component> stackDescs) {
        Intrinsics.checkNotNullParameter((Object)handOpenedWith, (String)"handOpenedWith");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        Intrinsics.checkNotNullParameter(stackDescs, (String)"stackDescs");
        super((Component)HexUtils.getAsTranslatedComponent("gui.hexcasting.spellcasting"));
        this.handOpenedWith = handOpenedWith;
        this.patterns = patterns;
        this.stackDescs = stackDescs;
        this.drawState = PatternDrawState.BetweenPatterns.INSTANCE;
        this.usedSpots = new HashSet();
        for (ResolvedPattern resolvedPattern : this.patterns) {
            HexPattern pattern = resolvedPattern.component1();
            HexCoord origin = resolvedPattern.component2();
            this.usedSpots.addAll((Collection<HexCoord>)pattern.positions(origin));
        }
    }

    public final void recvServerUpdate(@NotNull ControllerInfo info, int index) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.stackDescs = info.getStackDesc();
        ResolvedPattern resolvedPattern = (ResolvedPattern)CollectionsKt.getOrNull(this.patterns, (int)index);
        if (resolvedPattern != null) {
            ResolvedPattern it = resolvedPattern;
            boolean bl = false;
            it.setType(info.getResolutionType());
        }
        if (info.getResolutionType().getSuccess()) {
            SoundManager soundManager = Minecraft.m_91087_().m_91106_();
            float f = 1.0f + ((float)Math.random() - 0.5f) * 0.1f;
            GridSoundInstance gridSoundInstance = this.ambianceSoundInstance;
            Intrinsics.checkNotNull((Object)((Object)gridSoundInstance));
            double d = gridSoundInstance.m_7772_();
            GridSoundInstance gridSoundInstance2 = this.ambianceSoundInstance;
            Intrinsics.checkNotNull((Object)((Object)gridSoundInstance2));
            double d2 = gridSoundInstance2.m_7780_();
            GridSoundInstance gridSoundInstance3 = this.ambianceSoundInstance;
            Intrinsics.checkNotNull((Object)((Object)gridSoundInstance3));
            soundManager.m_120367_((SoundInstance)new SimpleSoundInstance(HexSounds.ADD_PATTERN, SoundSource.PLAYERS, 0.5f, f, d, d2, gridSoundInstance3.m_7778_()));
        }
    }

    protected void m_7856_() {
        Minecraft minecraft = Minecraft.m_91087_();
        SoundManager soundManager = minecraft.m_91106_();
        soundManager.m_120386_(HexSounds.CASTING_AMBIANCE.m_11660_(), null);
        LocalPlayer player = minecraft.f_91074_;
        if (player != null) {
            GridSoundInstance gridSoundInstance = this.ambianceSoundInstance = new GridSoundInstance((Player)player);
            Intrinsics.checkNotNull((Object)((Object)gridSoundInstance));
            soundManager.m_120367_((SoundInstance)gridSoundInstance);
        }
    }

    public void m_96624_() {
        ItemStack heldItem;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player != null && ((heldItem = player.m_21120_(this.handOpenedWith)).m_41619_() || !heldItem.m_204117_(HexItemTags.WANDS))) {
            this.m_7379_();
        }
    }

    public boolean m_6375_(double mxOut, double myOut, int pButton) {
        HexCoord coord;
        if (super.m_6375_(mxOut, myOut, pButton)) {
            return true;
        }
        double mx = Mth.m_14008_((double)mxOut, (double)0.0, (double)this.f_96543_);
        double my = Mth.m_14008_((double)myOut, (double)0.0, (double)this.f_96544_);
        if (this.drawState instanceof PatternDrawState.BetweenPatterns && !this.usedSpots.contains(coord = this.pxToCoord(new Vec2((float)mx, (float)my)))) {
            this.drawState = new PatternDrawState.JustStarted(coord);
            SoundManager soundManager = Minecraft.m_91087_().m_91106_();
            GridSoundInstance gridSoundInstance = this.ambianceSoundInstance;
            Intrinsics.checkNotNull((Object)((Object)gridSoundInstance));
            double d = gridSoundInstance.m_7772_();
            GridSoundInstance gridSoundInstance2 = this.ambianceSoundInstance;
            Intrinsics.checkNotNull((Object)((Object)gridSoundInstance2));
            double d2 = gridSoundInstance2.m_7780_();
            GridSoundInstance gridSoundInstance3 = this.ambianceSoundInstance;
            Intrinsics.checkNotNull((Object)((Object)gridSoundInstance3));
            soundManager.m_120367_((SoundInstance)new SimpleSoundInstance(HexSounds.START_PATTERN, SoundSource.PLAYERS, 0.25f, 1.0f, d, d2, gridSoundInstance3.m_7778_()));
        }
        return false;
    }

    public boolean m_7979_(double mxOut, double myOut, int pButton, double pDragX, double pDragY) {
        Vec2 mouse;
        Vec2 anchor;
        HexCoord hexCoord;
        if (super.m_7979_(mxOut, myOut, pButton, pDragX, pDragY)) {
            return true;
        }
        double mx = Mth.m_14008_((double)mxOut, (double)0.0, (double)this.f_96543_);
        double my = Mth.m_14008_((double)myOut, (double)0.0, (double)this.f_96544_);
        PatternDrawState patternDrawState = this.drawState;
        if (Intrinsics.areEqual((Object)patternDrawState, (Object)PatternDrawState.BetweenPatterns.INSTANCE)) {
            hexCoord = null;
        } else if (patternDrawState instanceof PatternDrawState.JustStarted) {
            hexCoord = ((PatternDrawState.JustStarted)this.drawState).getStart();
        } else if (patternDrawState instanceof PatternDrawState.Drawing) {
            hexCoord = ((PatternDrawState.Drawing)this.drawState).getCurrent();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        HexCoord anchorCoord = hexCoord;
        if (anchorCoord != null && (double)(anchor = this.coordToPx(anchorCoord)).m_165914_(mouse = new Vec2((float)mx, (float)my)) >= (double)(this.hexSize() * this.hexSize()) * 2.0 * HexConfig.client().gridSnapThreshold()) {
            float f;
            Vec2 delta = mouse.m_165910_(anchor.m_165913_());
            float angle = (float)Math.atan2(delta.f_82471_, delta.f_82470_);
            float f2 = angle / ((float)Math.PI * 2);
            float f3 = f2 % (f = 6.0f);
            float snappedAngle = !(f3 == 0.0f) && !(Math.signum(f3) == Math.signum(f)) ? f3 + f : f3;
            int n = MathKt.roundToInt((float)(snappedAngle * (float)6)) + 1;
            int n2 = 6;
            int n3 = n % n2;
            HexDir newdir = HexDir.values()[n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31)];
            HexCoord idealNextLoc = anchorCoord.plus(newdir);
            boolean playSound = false;
            if (!this.usedSpots.contains(idealNextLoc)) {
                if (this.drawState instanceof PatternDrawState.JustStarted) {
                    HexPattern pat = new HexPattern(newdir, null, 2, null);
                    this.drawState = new PatternDrawState.Drawing(anchorCoord, idealNextLoc, pat);
                    playSound = true;
                } else if (this.drawState instanceof PatternDrawState.Drawing) {
                    PatternDrawState.Drawing ds = (PatternDrawState.Drawing)this.drawState;
                    HexDir lastDir = ds.getWipPattern().finalDir();
                    if (newdir == lastDir.rotatedBy(HexAngle.BACK)) {
                        if (ds.getWipPattern().getAngles().isEmpty()) {
                            this.drawState = new PatternDrawState.JustStarted(ds.getCurrent().plus(newdir));
                        } else {
                            ds.setCurrent(ds.getCurrent().plus(newdir));
                            CollectionsKt.removeLast(ds.getWipPattern().getAngles());
                        }
                        playSound = true;
                    } else {
                        boolean success = ds.getWipPattern().tryAppendDir(newdir);
                        if (success) {
                            ds.setCurrent(idealNextLoc);
                        }
                        playSound = success;
                    }
                }
            }
            if (playSound) {
                SoundManager soundManager = Minecraft.m_91087_().m_91106_();
                float f4 = 1.0f + ((float)Math.random() - 0.5f) * 0.1f;
                GridSoundInstance gridSoundInstance = this.ambianceSoundInstance;
                Intrinsics.checkNotNull((Object)((Object)gridSoundInstance));
                double d = gridSoundInstance.m_7772_();
                GridSoundInstance gridSoundInstance2 = this.ambianceSoundInstance;
                Intrinsics.checkNotNull((Object)((Object)gridSoundInstance2));
                double d2 = gridSoundInstance2.m_7780_();
                GridSoundInstance gridSoundInstance3 = this.ambianceSoundInstance;
                Intrinsics.checkNotNull((Object)((Object)gridSoundInstance3));
                soundManager.m_120367_((SoundInstance)new SimpleSoundInstance(HexSounds.ADD_LINE, SoundSource.PLAYERS, 0.25f, f4, d, d2, gridSoundInstance3.m_7778_()));
            }
        }
        return false;
    }

    public boolean m_6348_(double mx, double my, int pButton) {
        if (super.m_6348_(mx, my, pButton)) {
            return true;
        }
        PatternDrawState patternDrawState = this.drawState;
        if (!Intrinsics.areEqual((Object)patternDrawState, (Object)PatternDrawState.BetweenPatterns.INSTANCE)) {
            if (patternDrawState instanceof PatternDrawState.JustStarted) {
                this.drawState = PatternDrawState.BetweenPatterns.INSTANCE;
            } else if (patternDrawState instanceof PatternDrawState.Drawing) {
                PatternDrawState.Drawing drawing = (PatternDrawState.Drawing)this.drawState;
                HexCoord start = drawing.component1();
                HexPattern pat = drawing.component3();
                this.drawState = PatternDrawState.BetweenPatterns.INSTANCE;
                this.patterns.add(new ResolvedPattern(pat, start, ResolvedPatternType.UNRESOLVED));
                this.usedSpots.addAll((Collection<HexCoord>)pat.positions(start));
                IClientXplatAbstractions.INSTANCE.sendPacketToServer(new MsgNewSpellPatternSyn(this.handOpenedWith, pat, this.patterns));
            }
        }
        return false;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        super.m_6050_(pMouseX, pMouseY, pDelta);
        MouseHandler mouseHandler = Minecraft.m_91087_().f_91067_;
        Intrinsics.checkNotNullExpressionValue((Object)mouseHandler, (String)"mouseHandler");
        if (!(ClientAccessorWrappers.getAccumulatedScroll(mouseHandler) == 0.0) && !(Math.signum(pDelta) == Math.signum(ClientAccessorWrappers.getAccumulatedScroll(mouseHandler)))) {
            ClientAccessorWrappers.setAccumulatedScroll(mouseHandler, 0.0);
        }
        ClientAccessorWrappers.setAccumulatedScroll(mouseHandler, ClientAccessorWrappers.getAccumulatedScroll(mouseHandler) + pDelta);
        int accumulation = (int)ClientAccessorWrappers.getAccumulatedScroll(mouseHandler);
        if (accumulation == 0) {
            return true;
        }
        ClientAccessorWrappers.setAccumulatedScroll(mouseHandler, ClientAccessorWrappers.getAccumulatedScroll(mouseHandler) - (double)accumulation);
        ShiftScrollListener.onScroll(pDelta, false);
        return true;
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91106_().m_120386_(HexSounds.CASTING_AMBIANCE.m_11660_(), null);
        super.m_7379_();
    }

    public void m_6305_(@NotNull PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        super.m_6305_(poseStack, pMouseX, pMouseY, pPartialTick);
        GridSoundInstance gridSoundInstance = this.ambianceSoundInstance;
        if (gridSoundInstance != null) {
            gridSoundInstance.setMousePosX((double)pMouseX / (double)this.f_96543_);
        }
        GridSoundInstance gridSoundInstance2 = this.ambianceSoundInstance;
        if (gridSoundInstance2 != null) {
            gridSoundInstance2.setMousePosY((double)pMouseX / (double)this.f_96543_);
        }
        Matrix4f mat = poseStack.m_85850_().m_85861_();
        ShaderInstance prevShader = RenderSystem.m_157196_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69465_();
        RenderSystem.m_69464_();
        Vec2 mousePos = new Vec2((float)pMouseX, (float)pMouseY);
        HexCoord mouseCoord = this.pxToCoord(mousePos);
        int radius = 3;
        Iterator<Object> iterator = mouseCoord.rangeAround(radius);
        while (iterator.hasNext()) {
            HexCoord hexCoord = iterator.next();
            if (this.usedSpots.contains(hexCoord)) continue;
            Vec2 dotPx = this.coordToPx(hexCoord);
            float delta = dotPx.m_165910_(mousePos.m_165913_()).m_165907_();
            float scaledDist = Mth.m_14036_((float)(1.0f - (delta - this.hexSize()) / ((float)radius * this.hexSize())), (float)0.0f, (float)1.0f);
            Intrinsics.checkNotNullExpressionValue((Object)mat, (String)"mat");
            RenderLib.drawSpot(mat, dotPx, scaledDist * 2.0f, Mth.m_14179_((float)scaledDist, (float)0.4f, (float)0.5f), Mth.m_14179_((float)scaledDist, (float)0.8f, (float)1.0f), Mth.m_14179_((float)scaledDist, (float)0.7f, (float)0.9f), scaledDist);
        }
        RenderSystem.m_69453_();
        for (ResolvedPattern resolvedPattern : this.patterns) {
            HexPattern pat = resolvedPattern.component1();
            HexCoord origin = resolvedPattern.component2();
            ResolvedPatternType valid = resolvedPattern.component3();
            Intrinsics.checkNotNullExpressionValue((Object)mat, (String)"mat");
            RenderLib.drawPatternFromPoints$default(mat, pat.toLines(this.hexSize(), this.coordToPx(origin)), true, valid.getColor() | 0xC8000000, valid.getFadeColor() | 0xC8000000, valid.getSuccess() ? 0.2f : 0.9f, null, 64, null);
        }
        if (!(this.drawState instanceof PatternDrawState.BetweenPatterns)) {
            List points = new ArrayList();
            if (this.drawState instanceof PatternDrawState.JustStarted) {
                PatternDrawState.JustStarted justStarted = (PatternDrawState.JustStarted)this.drawState;
                points.add(this.coordToPx(justStarted.getStart()));
            } else if (this.drawState instanceof PatternDrawState.Drawing) {
                PatternDrawState.Drawing drawing = (PatternDrawState.Drawing)this.drawState;
                for (HexCoord pos : HexPattern.positions$default(drawing.getWipPattern(), null, 1, null)) {
                    Vec2 pix = this.coordToPx(pos.plus(drawing.getStart()));
                    points.add(pix);
                }
            }
            points.add(mousePos);
            Intrinsics.checkNotNullExpressionValue((Object)mat, (String)"mat");
            RenderLib.drawPatternFromPoints$default(mat, points, false, -10172161, -78874, 0.1f, null, 64, null);
        }
        RenderSystem.m_157427_(() -> GuiSpellcasting.render$lambda-1(prevShader));
        RenderSystem.m_69482_();
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        Iterator<Object> iterator2 = this.stackDescs.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Component s = (Component)iterator2.next();
            int offsetIdx = this.stackDescs.size() - i - 1;
            font.m_92889_(poseStack, s, 10.0f, 10.0f + 9.0f * (float)offsetIdx, -1);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public final float hexSize() {
        float scaleModifier = DiscoveryHandlers.gridScaleModifier((Player)Minecraft.m_91087_().f_91074_);
        double baseScale = Math.sqrt((double)this.f_96543_ * (double)this.f_96544_ / 512.0);
        return (float)baseScale * scaleModifier;
    }

    @NotNull
    public final Vec2 coordsOffset() {
        return new Vec2((float)this.f_96543_ * 0.5f, (float)this.f_96544_ * 0.5f);
    }

    @NotNull
    public final Vec2 coordToPx(@NotNull HexCoord coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        return HexUtils.coordToPx(coord, this.hexSize(), this.coordsOffset());
    }

    @NotNull
    public final HexCoord pxToCoord(@NotNull Vec2 px) {
        Intrinsics.checkNotNullParameter((Object)px, (String)"px");
        return HexUtils.pxToCoord(px, this.hexSize(), this.coordsOffset());
    }

    private static final ShaderInstance render$lambda-1(ShaderInstance $prevShader) {
        return $prevShader;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState;", "", "()V", "BetweenPatterns", "Drawing", "JustStarted", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState$BetweenPatterns;", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState$JustStarted;", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState$Drawing;", "hexcasting-forge-1.18.2"})
    private static abstract class PatternDrawState {
        private PatternDrawState() {
        }

        public /* synthetic */ PatternDrawState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState$BetweenPatterns;", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState;", "()V", "hexcasting-forge-1.18.2"})
        public static final class BetweenPatterns
        extends PatternDrawState {
            @NotNull
            public static final BetweenPatterns INSTANCE = new BetweenPatterns();

            private BetweenPatterns() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState$JustStarted;", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState;", "start", "Lat/petrak/hexcasting/api/spell/math/HexCoord;", "(Lat/petrak/hexcasting/api/spell/math/HexCoord;)V", "getStart", "()Lat/petrak/hexcasting/api/spell/math/HexCoord;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-forge-1.18.2"})
        public static final class JustStarted
        extends PatternDrawState {
            @NotNull
            private final HexCoord start;

            public JustStarted(@NotNull HexCoord start) {
                Intrinsics.checkNotNullParameter((Object)start, (String)"start");
                super(null);
                this.start = start;
            }

            @NotNull
            public final HexCoord getStart() {
                return this.start;
            }

            @NotNull
            public final HexCoord component1() {
                return this.start;
            }

            @NotNull
            public final JustStarted copy(@NotNull HexCoord start) {
                Intrinsics.checkNotNullParameter((Object)start, (String)"start");
                return new JustStarted(start);
            }

            public static /* synthetic */ JustStarted copy$default(JustStarted justStarted, HexCoord hexCoord, int n, Object object) {
                if ((n & 1) != 0) {
                    hexCoord = justStarted.start;
                }
                return justStarted.copy(hexCoord);
            }

            @NotNull
            public String toString() {
                return "JustStarted(start=" + this.start + ")";
            }

            public int hashCode() {
                return this.start.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof JustStarted)) {
                    return false;
                }
                JustStarted justStarted = (JustStarted)other;
                return Intrinsics.areEqual((Object)this.start, (Object)justStarted.start);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState$Drawing;", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState;", "start", "Lat/petrak/hexcasting/api/spell/math/HexCoord;", "current", "wipPattern", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "(Lat/petrak/hexcasting/api/spell/math/HexCoord;Lat/petrak/hexcasting/api/spell/math/HexCoord;Lat/petrak/hexcasting/api/spell/math/HexPattern;)V", "getCurrent", "()Lat/petrak/hexcasting/api/spell/math/HexCoord;", "setCurrent", "(Lat/petrak/hexcasting/api/spell/math/HexCoord;)V", "getStart", "getWipPattern", "()Lat/petrak/hexcasting/api/spell/math/HexPattern;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-forge-1.18.2"})
        public static final class Drawing
        extends PatternDrawState {
            @NotNull
            private final HexCoord start;
            @NotNull
            private HexCoord current;
            @NotNull
            private final HexPattern wipPattern;

            public Drawing(@NotNull HexCoord start, @NotNull HexCoord current, @NotNull HexPattern wipPattern) {
                Intrinsics.checkNotNullParameter((Object)start, (String)"start");
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                Intrinsics.checkNotNullParameter((Object)wipPattern, (String)"wipPattern");
                super(null);
                this.start = start;
                this.current = current;
                this.wipPattern = wipPattern;
            }

            @NotNull
            public final HexCoord getStart() {
                return this.start;
            }

            @NotNull
            public final HexCoord getCurrent() {
                return this.current;
            }

            public final void setCurrent(@NotNull HexCoord hexCoord) {
                Intrinsics.checkNotNullParameter((Object)hexCoord, (String)"<set-?>");
                this.current = hexCoord;
            }

            @NotNull
            public final HexPattern getWipPattern() {
                return this.wipPattern;
            }

            @NotNull
            public final HexCoord component1() {
                return this.start;
            }

            @NotNull
            public final HexCoord component2() {
                return this.current;
            }

            @NotNull
            public final HexPattern component3() {
                return this.wipPattern;
            }

            @NotNull
            public final Drawing copy(@NotNull HexCoord start, @NotNull HexCoord current, @NotNull HexPattern wipPattern) {
                Intrinsics.checkNotNullParameter((Object)start, (String)"start");
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                Intrinsics.checkNotNullParameter((Object)wipPattern, (String)"wipPattern");
                return new Drawing(start, current, wipPattern);
            }

            public static /* synthetic */ Drawing copy$default(Drawing drawing, HexCoord hexCoord, HexCoord hexCoord2, HexPattern hexPattern, int n, Object object) {
                if ((n & 1) != 0) {
                    hexCoord = drawing.start;
                }
                if ((n & 2) != 0) {
                    hexCoord2 = drawing.current;
                }
                if ((n & 4) != 0) {
                    hexPattern = drawing.wipPattern;
                }
                return drawing.copy(hexCoord, hexCoord2, hexPattern);
            }

            @NotNull
            public String toString() {
                return "Drawing(start=" + this.start + ", current=" + this.current + ", wipPattern=" + this.wipPattern + ")";
            }

            public int hashCode() {
                int result = this.start.hashCode();
                result = result * 31 + this.current.hashCode();
                result = result * 31 + this.wipPattern.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Drawing)) {
                    return false;
                }
                Drawing drawing = (Drawing)other;
                if (!Intrinsics.areEqual((Object)this.start, (Object)drawing.start)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.current, (Object)drawing.current)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.wipPattern, (Object)drawing.wipPattern);
            }
        }
    }
}

