/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.entity;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec2;

public class WallScrollRenderer
extends EntityRenderer<EntityWallScroll> {
    private static final ResourceLocation PRISTINE_BG_LARGE = HexAPI.modLoc("textures/entity/scroll_large.png");
    private static final ResourceLocation PRISTINE_BG_MEDIUM = HexAPI.modLoc("textures/entity/scroll_medium.png");
    private static final ResourceLocation PRISTINE_BG_SMOL = HexAPI.modLoc("textures/block/scroll_paper.png");
    private static final ResourceLocation ANCIENT_BG_LARGE = HexAPI.modLoc("textures/entity/scroll_ancient_large.png");
    private static final ResourceLocation ANCIENT_BG_MEDIUM = HexAPI.modLoc("textures/entity/scroll_ancient_medium.png");
    private static final ResourceLocation ANCIENT_BG_SMOL = HexAPI.modLoc("textures/block/ancient_scroll_paper.png");
    private static final ResourceLocation WHITE = HexAPI.modLoc("textures/entity/white.png");

    public WallScrollRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(EntityWallScroll wallScroll, float yaw, float partialTicks, PoseStack ps, MultiBufferSource bufSource, int packedLight) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        ps.m_85836_();
        ps.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        ps.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)wallScroll.f_19853_, (BlockPos)wallScroll.m_31748_());
        ps.m_85836_();
        ps.m_85837_((double)((float)(-wallScroll.blockSize) / 2.0f), (double)((float)(-wallScroll.blockSize) / 2.0f), 0.03125);
        float dx = wallScroll.blockSize;
        float dy = wallScroll.blockSize;
        float dz = -0.0625f;
        float margin = 0.020833334f;
        PoseStack.Pose last = ps.m_85850_();
        Matrix4f mat = last.m_85861_();
        Matrix3f norm = last.m_85864_();
        VertexConsumer verts = bufSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(wallScroll)));
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, dz, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, dz, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, dz, 1.0f, 1.0f, 0.0f, 0.0f, -1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, dz, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, dz, 0.0f, margin, 0.0f, -1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, dz, 1.0f, margin, 0.0f, -1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, dz, margin, 1.0f, -1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, dz, margin, 0.0f, -1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, dz, 1.0f - margin, 0.0f, 1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, dz, 1.0f - margin, 1.0f, 1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, dz, 0.0f, 1.0f - margin, 0.0f, 1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, dz, 1.0f, 1.0f - margin, 0.0f, 1.0f, 0.0f);
        ps.m_85849_();
        if (wallScroll.zappyPoints != null) {
            List<Vec2> points = wallScroll.zappyPoints;
            ps.m_85836_();
            ps.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            ps.m_85837_(0.0, 0.0, (double)0.06875f);
            float unCharlieKirk = Mth.m_14116_((float)(wallScroll.blockSize * wallScroll.blockSize + 60));
            float scale = 0.0033333334f * unCharlieKirk;
            ps.m_85841_(scale, scale, 0.01f);
            PoseStack.Pose last2 = ps.m_85850_();
            Matrix4f mat2 = last2.m_85861_();
            Matrix3f norm2 = last2.m_85864_();
            int outer = -2963256;
            int inner = -936236237;
            VertexConsumer verts2 = bufSource.m_6299_(RenderType.m_110452_((ResourceLocation)WHITE));
            WallScrollRenderer.theCoolerDrawLineSeq(mat2, norm2, light, verts2, points, (float)wallScroll.blockSize * 5.0f / 3.0f, outer);
            ps.m_85837_(0.0, 0.0, 0.01);
            WallScrollRenderer.theCoolerDrawLineSeq(mat2, norm2, light, verts2, points, (float)wallScroll.blockSize * 2.0f / 3.0f, inner);
            if (wallScroll.getShowsStrokeOrder()) {
                float spotFrac = 0.8f * (float)wallScroll.blockSize;
                float animTime = (float)wallScroll.f_19797_ + partialTicks;
                double pointCircuit = (double)animTime * HexConfig.client().patternPointSpeedMultiplier() % (double)(points.size() + 10);
                if (pointCircuit < (double)(points.size() - 1)) {
                    int pointMacro = Mth.m_14107_((double)pointCircuit);
                    double pointMicro = pointCircuit - (double)pointMacro;
                    Vec2 p1 = points.get(pointMacro);
                    Vec2 p2 = points.get((pointMacro + 1) % points.size());
                    Vec2 drawPos = new Vec2((float)((double)p1.f_82470_ + (double)(p2.f_82470_ - p1.f_82470_) * pointMicro), (float)((double)p1.f_82471_ + (double)(p2.f_82471_ - p1.f_82471_) * pointMicro));
                    ps.m_85837_(0.0, 0.0, 0.01);
                    WallScrollRenderer.theCoolerDrawSpot(mat2, norm2, light, verts2, drawPos, 0.88886666f * spotFrac, -3170061);
                    ps.m_85837_(0.0, 0.0, 0.01);
                    WallScrollRenderer.theCoolerDrawSpot(mat2, norm2, light, verts2, drawPos, 0.6666667f * spotFrac, -7509300);
                } else {
                    ps.m_85837_(0.0, 0.0, 0.02);
                }
                ps.m_85837_(0.0, 0.0, 0.01);
                WallScrollRenderer.theCoolerDrawSpot(mat2, norm2, light, verts2, points.get(0), spotFrac, -11974957);
                ps.m_85837_(0.0, 0.0, 0.01);
                WallScrollRenderer.theCoolerDrawSpot(mat2, norm2, light, verts2, points.get(0), 0.6666667f * spotFrac, -10781737);
            }
            ps.m_85849_();
        }
        ps.m_85849_();
        super.m_7392_((Entity)wallScroll, yaw, partialTicks, ps, bufSource, packedLight);
    }

    public ResourceLocation getTextureLocation(EntityWallScroll wallScroll) {
        if (wallScroll.isAncient) {
            if (wallScroll.blockSize <= 1) {
                return ANCIENT_BG_SMOL;
            }
            if (wallScroll.blockSize == 2) {
                return ANCIENT_BG_MEDIUM;
            }
            return ANCIENT_BG_LARGE;
        }
        if (wallScroll.blockSize <= 1) {
            return PRISTINE_BG_SMOL;
        }
        if (wallScroll.blockSize == 2) {
            return PRISTINE_BG_MEDIUM;
        }
        return PRISTINE_BG_LARGE;
    }

    private static void vertex(Matrix4f mat, Matrix3f normal, int light, VertexConsumer verts, float x, float y, float z, float u, float v, float nx, float ny, float nz) {
        verts.m_85982_(mat, x, y, z).m_193479_(-1).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normal, nx, ny, nz).m_5752_();
    }

    private static void vertexCol(Matrix4f mat, Matrix3f normal, int light, VertexConsumer verts, int col, float x, float y) {
        verts.m_85982_(mat, -x, y, 0.0f).m_193479_(col).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private static void theCoolerDrawLineSeq(Matrix4f mat, Matrix3f normal, int light, VertexConsumer verts, List<Vec2> points, float width, int color) {
        if (points.size() <= 1) {
            return;
        }
        Vec2 p1 = points.get(0);
        Vec2 p2 = points.get(1);
        float dx = p2.f_82470_ - p1.f_82470_;
        float dy = p2.f_82471_ - p1.f_82471_;
        float nx = -dy;
        float ny = dx;
        float tlen = Mth.m_14116_((float)(nx * nx + ny * ny)) / (width * 0.5f);
        float tx = nx / tlen;
        float ty = ny / tlen;
        float prevXHi = p1.f_82470_ - tx;
        float prevYHi = p1.f_82471_ - ty;
        float prevXLo = p1.f_82470_ + tx;
        float prevYLo = p1.f_82471_ + ty;
        for (int i = 0; i < points.size() - 1; ++i) {
            Vec2 p12 = points.get(i);
            Vec2 p22 = points.get(i + 1);
            float dx2 = p22.f_82470_ - p12.f_82470_;
            float dy2 = p22.f_82471_ - p12.f_82471_;
            float nx2 = -dy2;
            float ny2 = dx2;
            float tlen2 = Mth.m_14116_((float)(nx2 * nx2 + ny2 * ny2)) / (width * 0.5f);
            float tx2 = nx2 / tlen2;
            float ty2 = ny2 / tlen2;
            float xHi = p22.f_82470_ - tx2;
            float yHi = p22.f_82471_ - ty2;
            float xLo = p22.f_82470_ + tx2;
            float yLo = p22.f_82471_ + ty2;
            WallScrollRenderer.vertexCol(mat, normal, light, verts, color, prevXHi, prevYHi);
            WallScrollRenderer.vertexCol(mat, normal, light, verts, color, prevXLo, prevYLo);
            WallScrollRenderer.vertexCol(mat, normal, light, verts, color, xLo, yLo);
            WallScrollRenderer.vertexCol(mat, normal, light, verts, color, xHi, yHi);
            prevXHi = xHi;
            prevYHi = yHi;
            prevXLo = xLo;
            prevYLo = yLo;
        }
    }

    private static void theCoolerDrawSpot(Matrix4f mat, Matrix3f normal, int light, VertexConsumer verts, Vec2 point, float radius, int color) {
        int fracOfCircle = 6;
        for (int i = 0; i < fracOfCircle; ++i) {
            WallScrollRenderer.vertexCol(mat, normal, light, verts, color, point.f_82470_, point.f_82471_);
            WallScrollRenderer.vertexCol(mat, normal, light, verts, color, point.f_82470_, point.f_82471_);
            for (int j = 0; j <= 1; ++j) {
                float theta = (float)(i - j) / (float)fracOfCircle * ((float)Math.PI * 2);
                float rx = Mth.m_14089_((float)theta) * radius + point.f_82470_;
                float ry = Mth.m_14031_((float)theta) * radius + point.f_82471_;
                WallScrollRenderer.vertexCol(mat, normal, light, verts, color, rx, ry);
            }
        }
    }
}

