/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell.casting;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.misc.DiscoveryHandlers;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.api.spell.casting.SpellCircleContext;
import at.petrak.hexcasting.api.spell.mishaps.MishapEntityTooFarAway;
import at.petrak.hexcasting.api.spell.mishaps.MishapEvalTooDeep;
import at.petrak.hexcasting.api.spell.mishaps.MishapLocationTooFarAway;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u0000 J2\u00020\u0001:\u0001JB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0016J\u000e\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\u001bJ\u000e\u0010)\u001a\u00020%2\u0006\u0010(\u001a\u00020\u001bJ\u000e\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\bH\u00c6\u0003J)\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u00101\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J,\u00103\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u0005042\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u000b07H\u0086\b\u00f8\u0001\u0000J\u0016\u00108\u001a\u0004\u0018\u0001052\f\u00109\u001a\b\u0012\u0004\u0012\u0002050:J\u000e\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\u0016J\t\u0010=\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010>\u001a\u00020%J\u000e\u0010?\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u0016J\u000e\u0010@\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u0016J\u000e\u0010A\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u001bJ\u000e\u0010B\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u001bJ\u000e\u0010C\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0016J\t\u0010D\u001a\u00020EH\u00d6\u0001J\u001e\u0010F\u001a\u00020\u000b2\u0006\u0010G\u001a\u0002052\u0006\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u00020\u000bR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006K"}, d2={"Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "", "caster", "Lnet/minecraft/server/level/ServerPlayer;", "castingHand", "Lnet/minecraft/world/InteractionHand;", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/InteractionHand;)V", "spellCircle", "Lat/petrak/hexcasting/api/spell/casting/SpellCircleContext;", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/InteractionHand;Lat/petrak/hexcasting/api/spell/casting/SpellCircleContext;)V", "canOvercast", "", "getCanOvercast", "()Z", "getCaster", "()Lnet/minecraft/server/level/ServerPlayer;", "getCastingHand", "()Lnet/minecraft/world/InteractionHand;", "depth", "", "entitiesGivenMotion", "", "Lnet/minecraft/world/entity/Entity;", "isCasterEnlightened", "otherHand", "getOtherHand", "position", "Lnet/minecraft/world/phys/Vec3;", "getPosition", "()Lnet/minecraft/world/phys/Vec3;", "getSpellCircle", "()Lat/petrak/hexcasting/api/spell/casting/SpellCircleContext;", "world", "Lnet/minecraft/server/level/ServerLevel;", "getWorld", "()Lnet/minecraft/server/level/ServerLevel;", "assertEntityInRange", "", "entity", "assertVecInRange", "vec", "assertVecInWorld", "canEditBlockAt", "pos", "Lnet/minecraft/core/BlockPos;", "component1", "component2", "component3", "copy", "equals", "other", "getHeldItemToOperateOn", "Lkotlin/Pair;", "Lnet/minecraft/world/item/ItemStack;", "acceptItemIf", "Lkotlin/Function1;", "getOperativeSlot", "stackOK", "Ljava/util/function/Predicate;", "hasBeenGivenMotion", "target", "hashCode", "incDepth", "isEntityInRange", "isEntityInWorld", "isVecInRange", "isVecInWorld", "markEntityAsMotionAdded", "toString", "", "withdrawItem", "item", "count", "actuallyRemove", "Companion", "hexcasting-forge-1.18.2"})
public final class CastingContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerPlayer caster;
    @NotNull
    private final InteractionHand castingHand;
    @Nullable
    private final SpellCircleContext spellCircle;
    private int depth;
    @NotNull
    private final Set<Entity> entitiesGivenMotion;

    public CastingContext(@NotNull ServerPlayer caster, @NotNull InteractionHand castingHand, @Nullable SpellCircleContext spellCircle) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)castingHand, (String)"castingHand");
        this.caster = caster;
        this.castingHand = castingHand;
        this.spellCircle = spellCircle;
        this.entitiesGivenMotion = new LinkedHashSet();
    }

    public /* synthetic */ CastingContext(ServerPlayer serverPlayer, InteractionHand interactionHand, SpellCircleContext spellCircleContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            spellCircleContext = null;
        }
        this(serverPlayer, interactionHand, spellCircleContext);
    }

    @NotNull
    public final ServerPlayer getCaster() {
        return this.caster;
    }

    @NotNull
    public final InteractionHand getCastingHand() {
        return this.castingHand;
    }

    @Nullable
    public final SpellCircleContext getSpellCircle() {
        return this.spellCircle;
    }

    public CastingContext(@NotNull ServerPlayer caster, @NotNull InteractionHand castingHand) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)castingHand, (String)"castingHand");
        this(caster, castingHand, null);
    }

    @NotNull
    public final ServerLevel getWorld() {
        ServerLevel serverLevel = this.caster.m_183503_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"caster.getLevel()");
        return serverLevel;
    }

    @NotNull
    public final InteractionHand getOtherHand() {
        return HexUtils.otherHand(this.castingHand);
    }

    @NotNull
    public final Vec3 getPosition() {
        Vec3 vec3 = this.caster.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"caster.position()");
        return vec3;
    }

    @NotNull
    public final Pair<ItemStack, InteractionHand> getHeldItemToOperateOn(@NotNull Function1<? super ItemStack, Boolean> acceptItemIf) {
        Intrinsics.checkNotNullParameter(acceptItemIf, (String)"acceptItemIf");
        boolean $i$f$getHeldItemToOperateOn = false;
        ItemStack handItem = this.getCaster().m_21120_(this.getOtherHand());
        Intrinsics.checkNotNullExpressionValue((Object)handItem, (String)"handItem");
        if (!((Boolean)acceptItemIf.invoke((Object)handItem)).booleanValue()) {
            ItemStack castingItem = this.getCaster().m_21120_(this.getCastingHand());
            Intrinsics.checkNotNullExpressionValue((Object)castingItem, (String)"castingItem");
            if (((Boolean)acceptItemIf.invoke((Object)castingItem)).booleanValue()) {
                return TuplesKt.to((Object)castingItem, (Object)this.getCastingHand());
            }
        }
        return TuplesKt.to((Object)handItem, (Object)this.getOtherHand());
    }

    public final void incDepth() {
        int n = this.depth;
        this.depth = n + 1;
        int maxAllowedDepth = HexConfig.server().maxRecurseDepth();
        if (this.depth > maxAllowedDepth) {
            throw new MishapEvalTooDeep();
        }
    }

    public final void assertVecInWorld(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        if (!this.isVecInWorld(vec)) {
            throw new MishapLocationTooFarAway(vec, "out_of_world");
        }
    }

    public final void assertVecInRange(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        if (!this.isVecInRange(vec)) {
            throw new MishapLocationTooFarAway(vec, null, 2, null);
        }
        this.assertVecInWorld(vec);
    }

    public final void assertEntityInRange(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(entity instanceof Player) && !this.isEntityInRange(entity)) {
            throw new MishapEntityTooFarAway(entity);
        }
    }

    public final boolean hasBeenGivenMotion(@NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.entitiesGivenMotion.contains(target);
    }

    public final boolean isVecInWorld(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        return this.getWorld().m_46739_(new BlockPos(vec)) && this.getWorld().m_6857_().m_187562_(vec.f_82479_, vec.f_82481_, 0.5);
    }

    public final boolean isVecInRange(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        Sentinel sentinel = IXplatAbstractions.INSTANCE.getSentinel((Player)this.caster);
        if (sentinel.hasSentinel() && sentinel.extendsRange() && Intrinsics.areEqual((Object)this.getWorld().m_46472_(), sentinel.dimension()) && vec.m_82557_(sentinel.position()) < 256.0) {
            return true;
        }
        if (this.spellCircle != null) {
            float range = this.caster.m_20206_();
            if (this.spellCircle.getActivatorAlwaysInRange() && vec.m_82557_(this.caster.m_146892_()) < (double)(range * range)) {
                return true;
            }
            return this.spellCircle.getAabb().m_82390_(vec);
        }
        return vec.m_82557_(this.caster.m_20182_()) < 1024.0;
    }

    public final boolean isEntityInWorld(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Vec3 vec3 = entity.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"entity.position()");
        return this.isVecInWorld(vec3);
    }

    public final boolean isEntityInRange(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (this.spellCircle != null && this.spellCircle.getActivatorAlwaysInRange() && Intrinsics.areEqual((Object)this.caster, (Object)entity)) {
            return true;
        }
        Vec3 vec3 = entity.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"entity.position()");
        return this.isVecInRange(vec3);
    }

    public final boolean canEditBlockAt(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)pos));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(pos)");
        return this.isVecInRange(vec3) && this.caster.f_8941_.m_9290_() != GameType.ADVENTURE && this.getWorld().m_7966_((Player)this.caster, pos);
    }

    @Nullable
    public final ItemStack getOperativeSlot(@NotNull Predicate<ItemStack> stackOK) {
        Intrinsics.checkNotNullParameter(stackOK, (String)"stackOK");
        List<ItemStack> operable = DiscoveryHandlers.collectOperableSlots(this);
        for (ItemStack stack : operable) {
            if (!stackOK.test(stack)) continue;
            return stack;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean withdrawItem(@NotNull ItemStack item, int count, boolean actuallyRemove) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (this.caster.m_7500_()) {
            return true;
        }
        List<ItemStack> stacksToExamine = DiscoveryHandlers.collectItemSlots(this);
        Intrinsics.checkNotNullExpressionValue(stacksToExamine, (String)"stacksToExamine");
        Iterable iterable = stacksToExamine;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void stack;
            ItemStack itemStack = (ItemStack)element$iv;
            int acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
            accumulator$iv = acc + (CastingContext.withdrawItem$matches(item, (ItemStack)stack) ? stack.m_41613_() : 0);
        }
        int presentCount = accumulator$iv;
        if (presentCount < count) {
            return false;
        }
        if (!actuallyRemove) {
            return true;
        }
        int remaining = count;
        for (ItemStack stack : stacksToExamine) {
            Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
            if (!CastingContext.withdrawItem$matches(item, stack)) continue;
            int toWithdraw = Math.min(stack.m_41613_(), remaining);
            stack.m_41774_(toWithdraw);
            if ((remaining -= toWithdraw) > 0) continue;
            return true;
        }
        throw new RuntimeException("unreachable");
    }

    public final void markEntityAsMotionAdded(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.entitiesGivenMotion.add(entity);
    }

    public final boolean getCanOvercast() {
        Advancement adv = this.getWorld().m_142572_().m_129889_().m_136041_(HexAPI.modLoc("y_u_no_cast_angy"));
        PlayerAdvancements advs = this.caster.m_8960_();
        Advancement advancement = adv;
        Intrinsics.checkNotNull((Object)advancement);
        return advs.m_135996_(advancement).m_8193_();
    }

    public final boolean isCasterEnlightened() {
        Advancement adv = this.getWorld().m_142572_().m_129889_().m_136041_(HexAPI.modLoc("enlightenment"));
        PlayerAdvancements advs = this.caster.m_8960_();
        Advancement advancement = adv;
        Intrinsics.checkNotNull((Object)advancement);
        return advs.m_135996_(advancement).m_8193_();
    }

    @NotNull
    public final ServerPlayer component1() {
        return this.caster;
    }

    @NotNull
    public final InteractionHand component2() {
        return this.castingHand;
    }

    @Nullable
    public final SpellCircleContext component3() {
        return this.spellCircle;
    }

    @NotNull
    public final CastingContext copy(@NotNull ServerPlayer caster, @NotNull InteractionHand castingHand, @Nullable SpellCircleContext spellCircle) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)castingHand, (String)"castingHand");
        return new CastingContext(caster, castingHand, spellCircle);
    }

    public static /* synthetic */ CastingContext copy$default(CastingContext castingContext, ServerPlayer serverPlayer, InteractionHand interactionHand, SpellCircleContext spellCircleContext, int n, Object object) {
        if ((n & 1) != 0) {
            serverPlayer = castingContext.caster;
        }
        if ((n & 2) != 0) {
            interactionHand = castingContext.castingHand;
        }
        if ((n & 4) != 0) {
            spellCircleContext = castingContext.spellCircle;
        }
        return castingContext.copy(serverPlayer, interactionHand, spellCircleContext);
    }

    @NotNull
    public String toString() {
        return "CastingContext(caster=" + this.caster + ", castingHand=" + this.castingHand + ", spellCircle=" + this.spellCircle + ")";
    }

    public int hashCode() {
        int result = this.caster.hashCode();
        result = result * 31 + this.castingHand.hashCode();
        result = result * 31 + (this.spellCircle == null ? 0 : this.spellCircle.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CastingContext)) {
            return false;
        }
        CastingContext castingContext = (CastingContext)other;
        if (!Intrinsics.areEqual((Object)this.caster, (Object)castingContext.caster)) {
            return false;
        }
        if (this.castingHand != castingContext.castingHand) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.spellCircle, (Object)castingContext.spellCircle);
    }

    private static final boolean withdrawItem$matches(ItemStack $item, ItemStack stack) {
        return !stack.m_41619_() && ItemStack.m_150942_((ItemStack)$item, (ItemStack)stack);
    }

    private static final List _init_$lambda-3(CastingContext it) {
        List list;
        Inventory inv = it.caster.m_150109_();
        NonNullList nonNullList = inv.f_35974_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"inv.items");
        List $this$lambda_u2d3_u24lambda_u2d1 = list = CollectionsKt.toMutableList((Collection)((Collection)nonNullList));
        boolean bl = false;
        $this$lambda_u2d3_u24lambda_u2d1.remove(inv.f_35977_);
        List $this$lambda_u2d3_u24lambda_u2d2 = list = CollectionsKt.toMutableList((Collection)CollectionsKt.asReversedMutable((List)list));
        boolean bl2 = false;
        NonNullList nonNullList2 = inv.f_35976_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList2, (String)"inv.offhand");
        $this$lambda_u2d3_u24lambda_u2d2.addAll((Collection)nonNullList2);
        $this$lambda_u2d3_u24lambda_u2d2.add(inv.m_36056_());
        return list;
    }

    private static final List _init_$lambda-4(CastingContext it) {
        List slots = new ArrayList();
        int anchorSlot = it.castingHand == InteractionHand.MAIN_HAND ? (it.caster.m_150109_().f_35977_ + 1) % 9 : 0;
        ItemStack itemStack = it.caster.m_21120_(it.getOtherHand());
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"it.caster.getItemInHand(it.otherHand)");
        slots.add(itemStack);
        for (int delta = 0; delta < 9; ++delta) {
            int slot = (anchorSlot + delta) % 9;
            ItemStack itemStack2 = it.caster.m_150109_().m_8020_(slot);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"it.caster.inventory.getItem(slot)");
            slots.add(itemStack2);
        }
        return slots;
    }

    static {
        DiscoveryHandlers.addItemSlotDiscoverer(CastingContext::_init_$lambda-3);
        DiscoveryHandlers.addOperativeSlotDiscoverer(CastingContext::_init_$lambda-4);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lat/petrak/hexcasting/api/spell/casting/CastingContext$Companion;", "", "()V", "hexcasting-forge-1.18.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

