/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell;

import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.SpellList;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.spell.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.api.spell.mishaps.MishapNotEnoughArgs;
import at.petrak.hexcasting.api.utils.HexUtils;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\n\u001a&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u001d\u001a\u00020\u001e\u001a&\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u001d\u001a\u00020\u001e\u001a&\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00180\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u001d\u001a\u00020\u001e\u001a)\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00032\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#\"\u00020$\u00a2\u0006\u0002\u0010%\u001a:\u0010&\u001a\u0002H'\"\n\b\u0000\u0010'\u0018\u0001*\u00020$*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00032\u0006\u0010(\u001a\u00020\u001e2\b\b\u0002\u0010)\u001a\u00020\u001eH\u0086\b\u00a2\u0006\u0002\u0010*\u001a\u0012\u0010+\u001a\u00020\u000e*\u00020$2\u0006\u0010,\u001a\u00020$\u001a\u001c\u0010+\u001a\u00020\u000e*\u00020$2\u0006\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u001eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\" \u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\" \u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003*\u00020\b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\" \u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003*\u00020\n8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u000b\" \u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003*\u00020\f8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\r\" \u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003*\u00020\u000e8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u000f\" \u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003*\u00020\u00018\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0010\" \u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003*\u00020\u00118\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0012\"*\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0013\" \u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003*\u00020\u00148\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0015\"\"\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003*\u0004\u0018\u00010\u00168\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0017\" \u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003*\u00020\u00188\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0019\u00a8\u0006."}, d2={"TOLERANCE", "", "asSpellResult", "", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "Lat/petrak/hexcasting/api/spell/SpellList;", "getAsSpellResult", "(Lat/petrak/hexcasting/api/spell/SpellList;)Ljava/util/List;", "Lat/petrak/hexcasting/api/spell/Widget;", "(Lat/petrak/hexcasting/api/spell/Widget;)Ljava/util/List;", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "(Lat/petrak/hexcasting/api/spell/math/HexPattern;)Ljava/util/List;", "Lcom/mojang/math/Vector3f;", "(Lcom/mojang/math/Vector3f;)Ljava/util/List;", "", "(Z)Ljava/util/List;", "(D)Ljava/util/List;", "", "(Ljava/lang/Number;)Ljava/util/List;", "(Ljava/util/List;)Ljava/util/List;", "Lnet/minecraft/core/BlockPos;", "(Lnet/minecraft/core/BlockPos;)Ljava/util/List;", "Lnet/minecraft/world/entity/Entity;", "(Lnet/minecraft/world/entity/Entity;)Ljava/util/List;", "Lnet/minecraft/world/phys/Vec3;", "(Lnet/minecraft/world/phys/Vec3;)Ljava/util/List;", "evaluatable", "Lcom/mojang/datafixers/util/Either;", "datum", "reverseIdx", "", "numOrList", "numOrVec", "spellListOf", "vs", "", "", "([Ljava/lang/Object;)Ljava/util/List;", "getChecked", "T", "idx", "argc", "(Ljava/util/List;II)Ljava/lang/Object;", "tolerantEquals", "that", "recursionsLeft", "hexcasting-forge-1.18.2"})
@JvmName(name="OperatorUtils")
public final class OperatorUtils {
    private static final double TOLERANCE = 1.0E-4;

    @NotNull
    public static final Either<Double, Vec3> numOrVec(@NotNull SpellDatum<?> datum, int reverseIdx) {
        Either either;
        Intrinsics.checkNotNullParameter(datum, (String)"datum");
        Object obj = datum.getPayload();
        if (obj instanceof Double) {
            Either either2 = Either.left(datum.getPayload());
            either = either2;
            Intrinsics.checkNotNullExpressionValue((Object)either2, (String)"left(datum.payload)");
        } else if (obj instanceof Vec3) {
            Either either3 = Either.right(datum.getPayload());
            either = either3;
            Intrinsics.checkNotNullExpressionValue((Object)either3, (String)"right(datum.payload)");
        } else {
            throw new MishapInvalidIota(datum, reverseIdx, (Component)HexUtils.getAsTranslatedComponent("hexcasting.mishap.invalid_value.numvec"));
        }
        return either;
    }

    @NotNull
    public static final Either<Double, SpellList> numOrList(@NotNull SpellDatum<?> datum, int reverseIdx) {
        Either either;
        Intrinsics.checkNotNullParameter(datum, (String)"datum");
        Object obj = datum.getPayload();
        if (obj instanceof Double) {
            Either either2 = Either.left(datum.getPayload());
            either = either2;
            Intrinsics.checkNotNullExpressionValue((Object)either2, (String)"left(datum.payload)");
        } else if (obj instanceof SpellList) {
            Either either3 = Either.right(datum.getPayload());
            either = either3;
            Intrinsics.checkNotNullExpressionValue((Object)either3, (String)"right(datum.payload)");
        } else {
            throw new MishapInvalidIota(datum, reverseIdx, (Component)HexUtils.getAsTranslatedComponent("hexcasting.mishap.invalid_value.numlist"));
        }
        return either;
    }

    @NotNull
    public static final Either<HexPattern, SpellList> evaluatable(@NotNull SpellDatum<?> datum, int reverseIdx) {
        Either either;
        Intrinsics.checkNotNullParameter(datum, (String)"datum");
        Object obj = datum.getPayload();
        if (obj instanceof HexPattern) {
            Either either2 = Either.left(datum.getPayload());
            either = either2;
            Intrinsics.checkNotNullExpressionValue((Object)either2, (String)"left(datum.payload)");
        } else if (obj instanceof SpellList) {
            Either either3 = Either.right(datum.getPayload());
            either = either3;
            Intrinsics.checkNotNullExpressionValue((Object)either3, (String)"right(datum.payload)");
        } else {
            throw new MishapInvalidIota(datum, reverseIdx, (Component)HexUtils.getAsTranslatedComponent("hexcasting.mishap.invalid_value.evaluatable"));
        }
        return either;
    }

    @NotNull
    public static final List<SpellDatum<?>> spellListOf(Object ... vs) {
        Intrinsics.checkNotNullParameter((Object)vs, (String)"vs");
        ArrayList out = new ArrayList(vs.length);
        for (Object v : vs) {
            out.add(SpellDatum.Companion.make(v));
        }
        return out;
    }

    public static final /* synthetic */ <T> T getChecked(List<? extends SpellDatum<?>> $this$getChecked, int idx, int argc) {
        Intrinsics.checkNotNullParameter($this$getChecked, (String)"<this>");
        boolean $i$f$getChecked = false;
        List<SpellDatum<?>> list = $this$getChecked;
        if (idx < 0 || idx > CollectionsKt.getLastIndex(list)) {
            int it = idx;
            boolean bl = false;
            throw new MishapNotEnoughArgs(idx + 1, $this$getChecked.size());
        }
        SpellDatum<?> x = list.get(idx);
        Object obj = x.getPayload();
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (obj instanceof Object) {
            return (T)x.getPayload();
        }
        int n = argc == 0 ? idx : argc - (idx + 1);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        throw MishapInvalidIota.Companion.ofClass(x, n, Object.class);
    }

    public static /* synthetic */ Object getChecked$default(List $this$getChecked_u24default, int idx, int argc, int n, Object object) {
        if ((n & 2) != 0) {
            argc = 0;
        }
        Intrinsics.checkNotNullParameter((Object)$this$getChecked_u24default, (String)"<this>");
        boolean $i$f$getChecked = false;
        List list = $this$getChecked_u24default;
        if (idx < 0 || idx > CollectionsKt.getLastIndex((List)list)) {
            int it = idx;
            boolean bl = false;
            throw new MishapNotEnoughArgs(idx + 1, $this$getChecked_u24default.size());
        }
        SpellDatum x = (SpellDatum)list.get(idx);
        Object t = x.getPayload();
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (t instanceof Object) {
            return x.getPayload();
        }
        int n2 = argc == 0 ? idx : argc - (idx + 1);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        throw MishapInvalidIota.Companion.ofClass(x, n2, Object.class);
    }

    @NotNull
    public static final List<SpellDatum<?>> getAsSpellResult(boolean $this$asSpellResult) {
        boolean $i$f$getAsSpellResult = false;
        Object[] objectArray = new Object[]{$this$asSpellResult ? 1.0 : 0.0};
        return OperatorUtils.spellListOf(objectArray);
    }

    @NotNull
    public static final List<SpellDatum<?>> getAsSpellResult(double $this$asSpellResult) {
        boolean $i$f$getAsSpellResult = false;
        Object[] objectArray = new Object[]{$this$asSpellResult};
        return OperatorUtils.spellListOf(objectArray);
    }

    @NotNull
    public static final List<SpellDatum<?>> getAsSpellResult(@NotNull Number $this$asSpellResult) {
        Intrinsics.checkNotNullParameter((Object)$this$asSpellResult, (String)"<this>");
        boolean $i$f$getAsSpellResult = false;
        Object[] objectArray = new Object[]{$this$asSpellResult.doubleValue()};
        return OperatorUtils.spellListOf(objectArray);
    }

    @NotNull
    public static final List<SpellDatum<?>> getAsSpellResult(@NotNull SpellList $this$asSpellResult) {
        Intrinsics.checkNotNullParameter((Object)$this$asSpellResult, (String)"<this>");
        boolean $i$f$getAsSpellResult = false;
        Object[] objectArray = new Object[]{$this$asSpellResult};
        return OperatorUtils.spellListOf(objectArray);
    }

    @NotNull
    public static final List<SpellDatum<?>> getAsSpellResult(@NotNull List<? extends SpellDatum<?>> $this$asSpellResult) {
        Intrinsics.checkNotNullParameter($this$asSpellResult, (String)"<this>");
        boolean $i$f$getAsSpellResult = false;
        Object[] objectArray = new Object[]{$this$asSpellResult};
        return OperatorUtils.spellListOf(objectArray);
    }

    @NotNull
    public static final List<SpellDatum<?>> getAsSpellResult(@NotNull Widget $this$asSpellResult) {
        Intrinsics.checkNotNullParameter((Object)$this$asSpellResult, (String)"<this>");
        boolean $i$f$getAsSpellResult = false;
        Object[] objectArray = new Object[]{$this$asSpellResult};
        return OperatorUtils.spellListOf(objectArray);
    }

    @NotNull
    public static final List<SpellDatum<?>> getAsSpellResult(@NotNull BlockPos $this$asSpellResult) {
        Intrinsics.checkNotNullParameter((Object)$this$asSpellResult, (String)"<this>");
        boolean $i$f$getAsSpellResult = false;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)Vec3.m_82512_((Vec3i)((Vec3i)$this$asSpellResult)), (String)"atCenterOf(this)");
        return OperatorUtils.spellListOf(objectArray);
    }

    @NotNull
    public static final List<SpellDatum<?>> getAsSpellResult(@NotNull Vector3f $this$asSpellResult) {
        Intrinsics.checkNotNullParameter((Object)$this$asSpellResult, (String)"<this>");
        boolean $i$f$getAsSpellResult = false;
        Object[] objectArray = new Object[]{new Vec3($this$asSpellResult)};
        return OperatorUtils.spellListOf(objectArray);
    }

    @NotNull
    public static final List<SpellDatum<?>> getAsSpellResult(@NotNull Vec3 $this$asSpellResult) {
        Intrinsics.checkNotNullParameter((Object)$this$asSpellResult, (String)"<this>");
        boolean $i$f$getAsSpellResult = false;
        Object[] objectArray = new Object[]{$this$asSpellResult};
        return OperatorUtils.spellListOf(objectArray);
    }

    @NotNull
    public static final List<SpellDatum<?>> getAsSpellResult(@Nullable Entity $this$asSpellResult) {
        boolean $i$f$getAsSpellResult = false;
        Object[] objectArray = new Object[1];
        Object object = $this$asSpellResult;
        if (object == null) {
            object = Widget.NULL;
        }
        objectArray[0] = object;
        return OperatorUtils.spellListOf(objectArray);
    }

    @NotNull
    public static final List<SpellDatum<?>> getAsSpellResult(@NotNull HexPattern $this$asSpellResult) {
        Intrinsics.checkNotNullParameter((Object)$this$asSpellResult, (String)"<this>");
        boolean $i$f$getAsSpellResult = false;
        Object[] objectArray = new Object[]{$this$asSpellResult};
        return OperatorUtils.spellListOf(objectArray);
    }

    public static final boolean tolerantEquals(@NotNull Object $this$tolerantEquals, @NotNull Object that) {
        Intrinsics.checkNotNullParameter((Object)$this$tolerantEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return OperatorUtils.tolerantEquals($this$tolerantEquals, that, 64);
    }

    private static final boolean tolerantEquals(Object $this$tolerantEquals, Object that, int recursionsLeft) {
        boolean bl;
        Object self = $this$tolerantEquals instanceof SpellDatum ? ((SpellDatum)$this$tolerantEquals).getPayload() : $this$tolerantEquals;
        Object other = that instanceof SpellDatum ? ((SpellDatum)that).getPayload() : that;
        if (self instanceof HexPattern && other instanceof HexPattern) {
            bl = Intrinsics.areEqual(((HexPattern)self).getAngles(), ((HexPattern)other).getAngles());
        } else if (self instanceof Double && other instanceof Double) {
            bl = Math.abs(((Number)self).doubleValue() - ((Number)other).doubleValue()) < 1.0E-4;
        } else if (self instanceof Vec3 && other instanceof Vec3) {
            bl = ((Vec3)self).m_82546_((Vec3)other).m_82556_() < 1.0E-8;
        } else if (self instanceof SpellList && other instanceof SpellList) {
            List castA = CollectionsKt.toList((Iterable)((Iterable)self));
            List castB = CollectionsKt.toList((Iterable)((Iterable)other));
            if (castA.size() != castB.size() || recursionsLeft == 0) {
                return false;
            }
            int n = castA.size();
            for (int i = 0; i < n; ++i) {
                if (OperatorUtils.tolerantEquals(((SpellDatum)castA.get(i)).getPayload(), ((SpellDatum)castB.get(i)).getPayload(), recursionsLeft - 1)) continue;
                return false;
            }
            bl = true;
        } else {
            bl = self instanceof Entity && other instanceof Entity ? Intrinsics.areEqual((Object)((Entity)self).m_142081_(), (Object)((Entity)other).m_142081_()) : Intrinsics.areEqual((Object)self, (Object)other);
        }
        return bl;
    }
}

