/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.dynamo;

import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class NumismaticFuel
extends ThermalFuel {
    public NumismaticFuel(ResourceLocation recipeId, int energy, @Nullable List<Ingredient> inputItems, @Nullable List<FluidIngredient> inputFluids) {
        super(recipeId, energy, inputItems, inputFluids);
        int minEnergy = 1000;
        int maxEnergy = 20000000;
        if (this.energy < minEnergy || this.energy > maxEnergy) {
            ThermalCore.LOG.warn("Energy value for " + recipeId + " was out of allowable range and has been clamped between + " + minEnergy + " and " + maxEnergy + ".");
            this.energy = MathHelper.clamp((int)this.energy, (int)minEnergy, (int)maxEnergy);
        }
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ThermalCore.RECIPE_SERIALIZERS.get(TCoreRecipeTypes.ID_FUEL_NUMISMATIC);
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return TCoreRecipeTypes.FUEL_NUMISMATIC;
    }
}

