/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.fluid.IFluidStackHolder;
import cofh.lib.api.inventory.IItemStackHolder;
import cofh.lib.util.crafting.ComparableItemStack;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.SimpleMachineRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CrystallizerRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final CrystallizerRecipeManager INSTANCE = new CrystallizerRecipeManager();
    protected static final int DEFAULT_ENERGY = 20000;
    protected Map<CrystallizerMapWrapper, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Set<Fluid> validFluids = new ObjectOpenHashSet();
    protected Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected int maxInputItems = 2;
    protected int maxOutputItems = 1;
    protected int maxOutputFluids = 0;

    public static CrystallizerRecipeManager instance() {
        return INSTANCE;
    }

    private CrystallizerRecipeManager() {
        super(20000);
        this.basePower = 5;
    }

    public void addRecipe(ThermalRecipe recipe) {
        switch (recipe.getInputItems().size()) {
            case 1: {
                for (ItemStack firstInput : recipe.getInputItems().get(0).m_43908_()) {
                    for (FluidStack fluidInput : recipe.getInputFluids().get(0).getFluids()) {
                        this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(firstInput), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                    }
                }
                break;
            }
            case 2: {
                for (ItemStack firstInput : recipe.getInputItems().get(0).m_43908_()) {
                    for (ItemStack secondInput : recipe.getInputItems().get(1).m_43908_()) {
                        for (FluidStack fluidInput : recipe.getInputFluids().get(0).getFluids()) {
                            this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                        }
                    }
                }
                break;
            }
        }
    }

    public boolean validItem(ItemStack item) {
        return this.validItems.contains(CrystallizerRecipeManager.convert(item));
    }

    public boolean validFluid(FluidStack fluid) {
        return this.validFluids.contains(fluid.getFluid());
    }

    protected void clear() {
        this.recipeMap.clear();
        this.validFluids.clear();
        this.validItems.clear();
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackHolder> inputSlots, List<? extends IFluidStackHolder> inputTanks) {
        if (inputSlots.isEmpty() || inputTanks.isEmpty() || inputSlots.get(0).isEmpty() && inputTanks.get(0).isEmpty()) {
            return null;
        }
        ArrayList<ComparableItemStack> convertedItems = new ArrayList<ComparableItemStack>(this.maxInputItems);
        for (int i = 0; i < this.maxInputItems; ++i) {
            if (inputSlots.get(i).isEmpty()) continue;
            ComparableItemStack compStack = CrystallizerRecipeManager.convert(inputSlots.get(i).getItemStack());
            convertedItems.add(compStack);
        }
        return this.recipeMap.get(new CrystallizerMapWrapper(convertedItems, inputTanks.get(0).getFluidStack()));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputItems.isEmpty() || inputFluids.isEmpty() || outputItems.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        for (ItemStack itemStack : inputItems) {
            if (!itemStack.m_41619_()) continue;
            return null;
        }
        FluidStack inputFluid = inputFluids.get(0);
        if (inputFluid.isEmpty()) {
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.m_41619_()) continue;
            return null;
        }
        ArrayList<ComparableItemStack> arrayList = new ArrayList<ComparableItemStack>(inputItems.size());
        for (ItemStack stack : inputItems) {
            if (inputItems.isEmpty()) continue;
            ComparableItemStack compStack = CrystallizerRecipeManager.convert(stack);
            this.validItems.add(compStack);
            arrayList.add(compStack);
        }
        this.validFluids.add(inputFluid.getFluid());
        energy = (int)((float)energy * this.getDefaultScale());
        SimpleMachineRecipe simpleMachineRecipe = new SimpleMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(new CrystallizerMapWrapper(arrayList, inputFluid), simpleMachineRecipe);
        return simpleMachineRecipe;
    }

    @Override
    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    @Override
    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.m_44054_(TCoreRecipeTypes.RECIPE_CRYSTALLIZER);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)((Object)entry.getValue()));
        }
    }

    protected static class CrystallizerMapWrapper {
        Set<Integer> hashes;
        int hashCode;

        CrystallizerMapWrapper(List<ComparableItemStack> itemStacks) {
            this.hashes = new ObjectOpenHashSet(itemStacks.size());
            for (ComparableItemStack itemStack : itemStacks) {
                if (itemStack.hashCode() == 0) continue;
                this.hashes.add(itemStack.hashCode());
                this.hashCode += itemStack.hashCode();
            }
        }

        CrystallizerMapWrapper(List<ComparableItemStack> itemStacks, FluidStack fluidStack) {
            this.hashes = new ObjectOpenHashSet(itemStacks.size());
            for (ComparableItemStack itemStack : itemStacks) {
                if (itemStack.hashCode() == 0) continue;
                this.hashes.add(itemStack.hashCode());
                this.hashCode += itemStack.hashCode();
            }
            if (!fluidStack.isEmpty()) {
                int fluidHash = FluidHelper.fluidHashcodeNoTag((FluidStack)fluidStack);
                this.hashes.add(fluidHash);
                this.hashCode += fluidHash;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CrystallizerMapWrapper that = (CrystallizerMapWrapper)o;
            return this.hashes.size() == that.hashes.size() && this.hashes.containsAll(that.hashes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

