/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.dynamo;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.dynamo.DisenchantmentFuel;
import cofh.thermal.lib.util.managers.SingleItemFuelManager;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import cofh.thermal.lib.util.recipes.internal.IDynamoFuel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class DisenchantmentFuelManager
extends SingleItemFuelManager {
    private static final DisenchantmentFuelManager INSTANCE = new DisenchantmentFuelManager();
    protected static final int DEFAULT_ENERGY = 16000;
    protected List<DisenchantmentFuel> convertedFuels = new ArrayList<DisenchantmentFuel>();

    public static DisenchantmentFuelManager instance() {
        return INSTANCE;
    }

    private DisenchantmentFuelManager() {
        super(16000);
    }

    @Override
    public boolean validFuel(ItemStack input) {
        if (input.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return false;
        }
        return this.getEnergy(input) > 0;
    }

    @Override
    protected void clear() {
        this.fuelMap.clear();
    }

    public int getEnergy(ItemStack stack) {
        IDynamoFuel fuel = this.getFuel(stack);
        return fuel != null ? fuel.getEnergy() : this.getEnergyFromEnchantments(stack);
    }

    public int getEnergyFromEnchantments(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
        int energy = 0;
        for (Enchantment enchant : enchants.keySet()) {
            energy += enchant.m_6183_(((Integer)enchants.get(enchant)).intValue());
        }
        energy += enchants.size() * (enchants.size() + 1) / 2;
        return energy *= 8000;
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.m_44054_(TCoreRecipeTypes.FUEL_DISENCHANTMENT);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addFuel((ThermalFuel)((Object)entry.getValue()));
        }
        this.createConvertedRecipes(recipeManager);
    }

    public List<DisenchantmentFuel> getConvertedFuels() {
        return this.convertedFuels;
    }

    protected void createConvertedRecipes(RecipeManager recipeManager) {
        ArrayList<ItemStack> books = new ArrayList<ItemStack>();
        for (Enchantment enchant : ForgeRegistries.ENCHANTMENTS) {
            books.add(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchant, enchant.m_6586_())));
        }
        for (ItemStack book : books) {
            try {
                if (this.getFuel(book) != null || !this.validFuel(book)) continue;
                this.convertedFuels.add(this.convert(book, this.getEnergy(book)));
            }
            catch (Exception e) {
                ThermalCore.LOG.error(book.m_41720_().getRegistryName() + " threw an exception when querying the fuel value as the mod author is doing non-standard things in their item code (possibly tag related). It may not display in JEI but should function as fuel.");
            }
        }
    }

    protected DisenchantmentFuel convert(ItemStack item, int energy) {
        return new DisenchantmentFuel(new ResourceLocation("thermal", "disenchantment_" + item.m_41720_().getRegistryName().m_135815_()), energy, Collections.singletonList(Ingredient.m_43927_((ItemStack[])new ItemStack[]{item})), Collections.emptyList());
    }
}

