/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.device;

import cofh.lib.util.crafting.ComparableItemStack;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.device.TreeExtractorBoost;
import cofh.thermal.core.util.recipes.device.TreeExtractorMapping;
import cofh.thermal.lib.util.managers.AbstractManager;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class TreeExtractorManager
extends AbstractManager {
    private static final TreeExtractorManager INSTANCE = new TreeExtractorManager();
    protected Map<ComparableItemStack, FluidStack> itemMap = new Object2ObjectOpenHashMap();
    protected Map<ComparableItemStack, Pair<Integer, Float>> boostMap = new Object2ObjectOpenHashMap();
    protected IdentityHashMap<BlockState, FluidStack> trunkMap = new IdentityHashMap();
    protected SetMultimap<BlockState, BlockState> leafMap = HashMultimap.create();

    protected TreeExtractorManager() {
        super(8);
    }

    public static TreeExtractorManager instance() {
        return INSTANCE;
    }

    protected void clear() {
        this.itemMap.clear();
        this.boostMap.clear();
        this.trunkMap.clear();
        this.leafMap.clear();
    }

    public Set<BlockState> getMatchingLeaves(BlockState trunk) {
        return this.leafMap.get((Object)trunk);
    }

    public boolean validTrunk(BlockState trunk) {
        return this.trunkMap.containsKey(trunk);
    }

    public FluidStack getFluid(BlockState trunk) {
        return this.validTrunk(trunk) ? this.trunkMap.get(trunk) : FluidStack.EMPTY;
    }

    public boolean addTrunkMapping(BlockState trunk, FluidStack stack) {
        if (stack.isEmpty() || trunk == null || trunk.m_60734_() == Blocks.f_50016_) {
            return false;
        }
        this.trunkMap.put(trunk, stack);
        return true;
    }

    public boolean addLeafMapping(BlockState trunk, BlockState leaf) {
        if (trunk == null || trunk.m_60734_() == Blocks.f_50016_ || leaf == null || leaf.m_60734_() == Blocks.f_50016_) {
            return false;
        }
        this.leafMap.put((Object)trunk, (Object)leaf);
        return true;
    }

    public void addMapping(TreeExtractorMapping mapping) {
        this.addDefaultMappings(mapping.getTrunk(), mapping.getLeaves(), mapping.getFluid());
    }

    public boolean validBoost(ItemStack item) {
        return this.boostMap.containsKey(TreeExtractorManager.convert(item));
    }

    public void addBoost(TreeExtractorBoost boost) {
        for (ItemStack ingredient : boost.getIngredient().m_43908_()) {
            this.boostMap.put(TreeExtractorManager.convert(ingredient), (Pair<Integer, Float>)Pair.of((Object)boost.getCycles(), (Object)Float.valueOf(boost.getOutputMod())));
        }
    }

    public int getBoostCycles(ItemStack item) {
        return this.validBoost(item) ? (Integer)this.boostMap.get(TreeExtractorManager.convert(item)).getLeft() : 0;
    }

    public float getBoostOutputMod(ItemStack item) {
        return this.validBoost(item) ? ((Float)this.boostMap.get(TreeExtractorManager.convert(item)).getRight()).floatValue() : 1.0f;
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map mappings = recipeManager.m_44054_(TCoreRecipeTypes.MAPPING_TREE_EXTRACTOR);
        for (Map.Entry entry : mappings.entrySet()) {
            this.addMapping((TreeExtractorMapping)((Object)entry.getValue()));
        }
        Map boosts = recipeManager.m_44054_(TCoreRecipeTypes.BOOST_TREE_EXTRACTOR);
        for (Map.Entry entry : boosts.entrySet()) {
            this.addBoost((TreeExtractorBoost)((Object)entry.getValue()));
        }
    }

    private void addDefaultMappings(Block trunk, Block leaf, FluidStack stack) {
        if (trunk instanceof RotatedPillarBlock && leaf instanceof LeavesBlock && !stack.isEmpty()) {
            BlockState state = trunk.m_49966_();
            this.addTrunkMapping(state, stack);
            for (int i = 1; i <= 7; ++i) {
                this.addLeafMapping(state, (BlockState)((BlockState)leaf.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(i))).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false)));
            }
        }
    }
}

