/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.init.CoreBlocks;
import cofh.core.item.ItemCoFH;
import cofh.core.util.AreaUtils;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.entity.projectile.BlizzProjectile;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;

public class IceChargeItem
extends ItemCoFH {
    private static final DispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            Position iposition = DispenserBlock.m_52720_((BlockSource)source);
            double d0 = iposition.m_7096_() + (double)((float)direction.m_122429_() * 0.3f);
            double d1 = iposition.m_7098_() + (double)((float)direction.m_122430_() * 0.3f);
            double d2 = iposition.m_7094_() + (double)((float)direction.m_122431_() * 0.3f);
            ServerLevel world = source.m_7727_();
            Random random = world.f_46441_;
            double d3 = random.nextGaussian() * 0.05 + (double)direction.m_122429_();
            double d4 = random.nextGaussian() * 0.05 + (double)direction.m_122430_();
            double d5 = random.nextGaussian() * 0.05 + (double)direction.m_122431_();
            world.m_7967_((Entity)new BlizzProjectile(d0, d1, d2, d3, d4, d5, (Level)world));
            stack.m_41774_(1);
            return stack;
        }

        protected void m_6823_(BlockSource source) {
            source.m_7727_().m_46796_(1018, source.m_7961_(), 0);
        }
    };

    public IceChargeItem(Item.Properties builder) {
        super(builder);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        boolean isFull;
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = world.m_8055_(pos);
        boolean used = false;
        if (AreaUtils.isLitCampfire((BlockState)state)) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
            used = true;
        }
        if (world.m_46859_(pos = pos.m_142300_(context.m_43719_())) && AreaUtils.isValidSnowPosition((Level)world, (BlockPos)pos)) {
            world.m_46597_(pos, Blocks.f_50125_.m_49966_());
            used = true;
        }
        if ((state = world.m_8055_(pos)).m_60734_() == Blocks.f_50083_) {
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            used = true;
        }
        boolean bl = isFull = state.m_60734_() == Blocks.f_49990_ && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
        if (state.m_60767_() == Material.f_76305_ && isFull && state.m_60710_((LevelReader)world, pos) && world.m_45752_(state, pos, CollisionContext.m_82749_())) {
            world.m_46597_(pos, ThermalCoreConfig.permanentWater.get() != false ? Blocks.f_50126_.m_49966_() : Blocks.f_50449_.m_49966_());
            used = true;
            if (!ThermalCoreConfig.permanentWater.get().booleanValue()) {
                world.m_186460_(pos, Blocks.f_50449_, MathHelper.nextInt((Random)world.f_46441_, (int)60, (int)120));
            }
        }
        boolean bl2 = isFull = state.m_60734_() == Blocks.f_49991_ && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
        if (state.m_60767_() == Material.f_76307_ && isFull && state.m_60710_((LevelReader)world, pos) && world.m_45752_(state, pos, CollisionContext.m_82749_())) {
            world.m_46597_(pos, ThermalCoreConfig.permanentLava.get() != false ? Blocks.f_50080_.m_49966_() : ((Block)CoreBlocks.GLOSSED_MAGMA.get()).m_49966_());
            used = true;
            if (!ThermalCoreConfig.permanentLava.get().booleanValue()) {
                world.m_186460_(pos, (Block)CoreBlocks.GLOSSED_MAGMA.get(), MathHelper.nextInt((Random)world.f_46441_, (int)60, (int)120));
            }
        }
        if (used) {
            this.playUseSound(world, pos);
            context.m_43722_().m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void playUseSound(Level worldIn, BlockPos pos) {
        worldIn.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, (worldIn.f_46441_.nextFloat() - worldIn.f_46441_.nextFloat()) * 0.2f + 1.0f);
    }
}

