/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.machine;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.BrewerRecipe;
import cofh.thermal.lib.compat.crt.RecipePrintingUtil;
import cofh.thermal.lib.compat.crt.actions.ActionRemoveThermalRecipeByOutput;
import cofh.thermal.lib.compat.crt.base.CRTHelper;
import cofh.thermal.lib.compat.crt.base.CRTRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.helper.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.Brewer")
@IRecipeHandler.For(value=BrewerRecipe.class)
public class CRTBrewerManager
implements IRecipeManager,
IRecipeHandler<BrewerRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, IFluidStack output, IIngredientWithAmount ingredient, CTFluidIngredient fluidInput, int energy) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CRTRecipe crtRecipe = new CRTRecipe(resourceLocation).energy(energy).input(ingredient).input(fluidInput).output(output);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)crtRecipe.recipe(BrewerRecipe::new)));
    }

    public RecipeType<BrewerRecipe> getRecipeType() {
        return TCoreRecipeTypes.RECIPE_BREWER;
    }

    public void remove(IIngredient output) {
        throw new IllegalArgumentException("The Brewer only outputs fluids! Please provide an IFluidStack");
    }

    @ZenCodeType.Method
    public void removeRecipe(IFluidStack output) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveThermalRecipeByOutput((IRecipeManager)this, new IFluidStack[]{output}));
    }

    public String dumpToCommandString(IRecipeManager manager, BrewerRecipe recipe) {
        return String.format("<recipetype:%s>.addRecipe(\"%s\", %s, %s, %s, %s);", recipe.m_6671_(), recipe.m_6423_(), RecipePrintingUtil.stringifyFluidStacks(recipe.getOutputFluids(), " | "), RecipePrintingUtil.stringifyIngredients(recipe.getInputItems(), " | "), CRTHelper.stringifyFluidIngredients(recipe.getInputFluids()), recipe.getEnergy());
    }

    public Optional<Function<ResourceLocation, BrewerRecipe>> replaceIngredients(IRecipeManager manager, BrewerRecipe recipe, List<IReplacementRule> rules) throws IRecipeHandler.ReplacementNotSupportedException {
        return ReplacementHandlerHelper.replaceIngredientList(recipe.getInputItems(), Ingredient.class, (Recipe)recipe, rules, newIngredients -> id -> new CRTRecipe((ResourceLocation)id).energy(recipe.getEnergy()).setInputItems((List<Ingredient>)newIngredients).setInputFluids(recipe.getInputFluids()).setOutputFluids(recipe.getOutputFluids()).recipe(BrewerRecipe::new));
    }
}

