/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.gui.storage;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.ElementButton;
import cofh.core.client.gui.element.ElementFluidStorage;
import cofh.core.client.gui.element.ElementTexture;
import cofh.core.network.packet.server.TileConfigPacket;
import cofh.core.util.helpers.GuiHelper;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.api.block.entity.ITileCallback;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.block.entity.storage.FluidCellTile;
import cofh.thermal.core.inventory.container.storage.FluidCellContainer;
import cofh.thermal.lib.client.gui.CellScreenReconfigurable;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class FluidCellScreen
extends CellScreenReconfigurable<FluidCellContainer> {
    public static final String TEX_PATH = "thermal:textures/gui/container/fluid_cell.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermal:textures/gui/container/fluid_cell.png");
    public static final String TEX_INCREMENT = "cofh_core:textures/gui/elements/button_increment.png";
    public static final String TEX_DECREMENT = "cofh_core:textures/gui/elements/button_decrement.png";
    protected FluidCellTile tile;

    public FluidCellScreen(FluidCellContainer container, Inventory inv, Component titleIn) {
        super(container, inv, container.tile, (Component)StringHelper.getTextComponent((String)"block.thermal.fluid_cell"));
        this.tile = container.tile;
        this.texture = TEXTURE;
        this.info = GuiHelper.generatePanelInfo((String)"info.thermal.fluid_cell");
        this.name = "fluid_cell";
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.addElement(new ElementTexture((IGuiAccess)this, 24, 16).setSize(20, 20).setTexture("cofh_core:textures/gui/elements/info_input.png", 20, 20));
        this.addElement(new ElementTexture((IGuiAccess)this, 132, 16).setSize(20, 20).setTexture("cofh_core:textures/gui/elements/info_output.png", 20, 20));
        this.addElement((ElementBase)GuiHelper.setClearable((ElementFluidStorage)GuiHelper.createMediumFluidStorage((IGuiAccess)this, (int)80, (int)22, (FluidStorageCoFH)this.tile.getTank(0)), (ITileCallback)this.tile, (int)0));
        this.addButtons();
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        String input = StringHelper.format((long)this.tile.amountInput);
        String output = StringHelper.format((long)this.tile.amountOutput);
        this.getFontRenderer().m_92883_(matrixStack, input, (float)this.getCenteredOffset(input, 34), 42.0f, 0x404040);
        this.getFontRenderer().m_92883_(matrixStack, output, (float)this.getCenteredOffset(output, 142), 42.0f, 0x404040);
        super.m_7027_(matrixStack, mouseX, mouseY);
    }

    public boolean handleElementButtonClick(String buttonName, int mouseButton) {
        int change = 1000;
        float pitch = 0.7f;
        if (FluidCellScreen.m_96638_()) {
            change *= 10;
            pitch += 0.1f;
        }
        if (FluidCellScreen.m_96637_()) {
            change /= 100;
            pitch -= 0.2f;
        }
        if (mouseButton == 1) {
            change /= 10;
            pitch -= 0.1f;
        }
        int curInput = this.tile.amountInput;
        int curOutput = this.tile.amountOutput;
        switch (buttonName) {
            case "DecInput": {
                this.tile.amountInput -= change;
                pitch -= 0.1f;
                break;
            }
            case "IncInput": {
                this.tile.amountInput += change;
                pitch += 0.1f;
                break;
            }
            case "DecOutput": {
                this.tile.amountOutput -= change;
                pitch -= 0.1f;
                break;
            }
            case "IncOutput": {
                this.tile.amountOutput += change;
                pitch += 0.1f;
            }
        }
        SoundHelper.playClickSound((float)pitch);
        TileConfigPacket.sendToServer((IPacketHandlerTile)this.tile);
        this.tile.amountInput = curInput;
        this.tile.amountOutput = curOutput;
        return true;
    }

    protected void addButtons() {
        ElementBase decInput = new ElementButton((IGuiAccess)this, 19, 56).setTooltipFactory((element, mouseX, mouseY) -> {
            if (element.enabled()) {
                int change = 1000;
                if (FluidCellScreen.m_96638_()) {
                    change *= 10;
                }
                if (FluidCellScreen.m_96637_()) {
                    change /= 100;
                }
                return Collections.singletonList(new TextComponent(StringHelper.localize((String)"info.cofh.decrease_by") + " " + StringHelper.format((long)change) + "/" + StringHelper.format((long)(change / 10))));
            }
            return Collections.emptyList();
        }).setName("DecInput").setSize(14, 14).setTexture(TEX_DECREMENT, 42, 14).setEnabled(() -> this.tile.amountInput > 0);
        ElementBase incInput = new ElementButton((IGuiAccess)this, 35, 56).setTooltipFactory((element, mouseX, mouseY) -> {
            if (element.enabled()) {
                int change = 1000;
                if (FluidCellScreen.m_96638_()) {
                    change *= 10;
                }
                if (FluidCellScreen.m_96637_()) {
                    change /= 100;
                }
                return Collections.singletonList(new TextComponent(StringHelper.localize((String)"info.cofh.increase_by") + " " + StringHelper.format((long)change) + "/" + StringHelper.format((long)(change / 10))));
            }
            return Collections.emptyList();
        }).setName("IncInput").setSize(14, 14).setTexture(TEX_INCREMENT, 42, 14).setEnabled(() -> this.tile.amountInput < this.tile.getMaxInput());
        ElementBase decOutput = new ElementButton((IGuiAccess)this, 127, 56).setTooltipFactory((element, mouseX, mouseY) -> {
            if (element.enabled()) {
                int change = 1000;
                if (FluidCellScreen.m_96638_()) {
                    change *= 10;
                }
                if (FluidCellScreen.m_96637_()) {
                    change /= 100;
                }
                return Collections.singletonList(new TextComponent(StringHelper.localize((String)"info.cofh.decrease_by") + " " + StringHelper.format((long)change) + "/" + StringHelper.format((long)(change / 10))));
            }
            return Collections.emptyList();
        }).setName("DecOutput").setSize(14, 14).setTexture(TEX_DECREMENT, 42, 14).setEnabled(() -> this.tile.amountOutput > 0);
        ElementBase incOutput = new ElementButton((IGuiAccess)this, 143, 56).setTooltipFactory((element, mouseX, mouseY) -> {
            if (element.enabled()) {
                int change = 1000;
                if (FluidCellScreen.m_96638_()) {
                    change *= 10;
                }
                if (FluidCellScreen.m_96637_()) {
                    change /= 100;
                }
                return Collections.singletonList(new TextComponent(StringHelper.localize((String)"info.cofh.increase_by") + " " + StringHelper.format((long)change) + "/" + StringHelper.format((long)(change / 10))));
            }
            return Collections.emptyList();
        }).setName("IncOutput").setSize(14, 14).setTexture(TEX_INCREMENT, 42, 14).setEnabled(() -> this.tile.amountOutput < this.tile.getMaxOutput());
        this.addElement(decInput);
        this.addElement(incInput);
        this.addElement(decOutput);
        this.addElement(incOutput);
    }
}

