/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.device;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.InventoryHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.IAreaEffectTile;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.xp.XpStorage;
import cofh.thermal.core.client.ThermalTextures;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.core.inventory.container.device.DeviceCollectorContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.items.IItemHandler;

public class DeviceCollectorTile
extends DeviceTileBase
implements ITickableTile.IServerTickable,
IAreaEffectTile {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Area", "Filter");
    protected static final int TIME_CONSTANT = 20;
    protected static final IModelData MODEL_DATA = new ModelDataMap.Builder().withInitial(ModelUtils.UNDERLAY, (Object)ThermalTextures.DEVICE_COLLECTOR_UNDERLAY_LOC).build();
    protected static final Predicate<ItemEntity> VALID_ITEM_ENTITY = item -> {
        if (!item.m_6084_() || item.m_32063_()) {
            return false;
        }
        CompoundTag data = item.getPersistentData();
        return !data.m_128471_("PreventRemoteMovement") || data.m_128471_("AllowMachineRemoteMovement");
    };
    protected static final int RADIUS = 4;
    public int radius = 4;
    protected AABB area;
    protected int process = 1;

    public DeviceCollectorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TCoreTileEntities.DEVICE_COLLECTOR_TILE.get(), pos, state);
        this.inventory.addSlots(StorageGroup.ACCESSIBLE, 15, item -> this.filter.valid(item));
        this.xpStorage = new XpStorage(this.getBaseXpStorage());
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
    }

    @Override
    protected void updateActiveState(boolean prevActive) {
        if (!prevActive && this.isActive) {
            this.process = 1;
        }
        super.updateActiveState(prevActive);
    }

    public void tickServer() {
        this.updateActiveState();
        if (!this.isActive) {
            return;
        }
        --this.process;
        if (this.process > 0) {
            return;
        }
        this.process = this.getTimeConstant();
        this.collectItemsAndXp();
    }

    @Nonnull
    public IModelData getModelData() {
        return MODEL_DATA;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DeviceCollectorContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    public int getRadius() {
        return this.radius;
    }

    public int getTimeConstant() {
        return 20;
    }

    protected void collectItemsAndXp() {
        this.collectItems(this.getArea());
        if (this.xpStorageFeature) {
            this.collectXpOrbs(this.getArea());
        }
    }

    protected void collectItems(AABB area) {
        IItemHandler handler = this.inventory.getHandler(StorageGroup.ACCESSIBLE);
        List items = this.f_58857_.m_6443_(ItemEntity.class, area, VALID_ITEM_ENTITY);
        Predicate filterRules = this.filter.getItemRules();
        for (ItemEntity item : items) {
            ItemStack entityStack = item.m_32055_();
            if (!filterRules.test(entityStack)) continue;
            if ((entityStack = InventoryHelper.insertStackIntoInventory((IItemHandler)handler, (ItemStack)entityStack, (boolean)false)).m_41619_()) {
                item.m_146870_();
                continue;
            }
            item.m_32045_(entityStack);
        }
    }

    protected void collectXpOrbs(AABB area) {
        List orbs = this.f_58857_.m_6443_(ExperienceOrb.class, area, EntitySelector.f_20402_);
        for (ExperienceOrb orb : orbs) {
            orb.f_20770_ -= this.xpStorage.receiveXp(orb.m_20801_(), false);
            if (orb.f_20770_ > 0) continue;
            orb.m_146870_();
        }
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.radius = 4;
    }

    @Override
    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.radius = (int)((float)this.radius + AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"Radius"));
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.area = null;
    }

    public AABB getArea() {
        if (this.area == null) {
            this.area = new AABB(this.f_58858_.m_142082_(-this.radius, -1, -this.radius), this.f_58858_.m_142082_(1 + this.radius, 1 + this.radius, 1 + this.radius));
        }
        return this.area;
    }

    public int getColor() {
        return this.isActive ? 11017314 : 0x555555;
    }
}

