/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import java.util.Map;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.CongealedSlimeBlock;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.BloodSlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.ClayIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.EarthSlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.EnderSlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.SkySlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.SlimeIslandPiece;
import slimeknights.tconstruct.world.worldgen.trees.SupplierBlockStateProvider;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeFungusConfig;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeTreeConfig;
import slimeknights.tconstruct.world.worldgen.trees.feature.SlimeFungusFeature;
import slimeknights.tconstruct.world.worldgen.trees.feature.SlimeTreeFeature;

public final class TinkerStructures
extends TinkerModule {
    static final Logger log = Util.getLogger("tinker_structures");
    public static final RegistryObject<BlockStateProviderType<SupplierBlockStateProvider>> supplierBlockstateProvider = BLOCK_STATE_PROVIDER_TYPES.register("supplier_state_provider", () -> new BlockStateProviderType(SupplierBlockStateProvider.CODEC));
    public static final RegistryObject<SlimeTreeFeature> slimeTree = FEATURES.register("slime_tree", () -> new SlimeTreeFeature(SlimeTreeConfig.CODEC));
    public static final RegistryObject<SlimeFungusFeature> slimeFungus = FEATURES.register("slime_fungus", () -> new SlimeFungusFeature(SlimeFungusConfig.CODEC));
    public static final RegistryObject<ConfiguredFeature<SlimeTreeConfig, SlimeTreeFeature>> earthSlimeTree = CONFIGURED_FEATURES.registerStatic("earth_slime_tree", slimeTree, new SlimeTreeConfig.Builder().planted().trunk(() -> TinkerWorld.greenheart.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.EARTH)).m_49966_()).baseHeight(4).randomHeight(3).build());
    public static final RegistryObject<ConfiguredFeature<SlimeTreeConfig, SlimeTreeFeature>> earthSlimeIslandTree = CONFIGURED_FEATURES.registerStatic("earth_slime_island_tree", slimeTree, new SlimeTreeConfig.Builder().trunk(() -> TinkerWorld.greenheart.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.EARTH)).m_49966_()).baseHeight(4).randomHeight(3).build());
    public static final RegistryObject<ConfiguredFeature<SlimeTreeConfig, SlimeTreeFeature>> skySlimeTree = CONFIGURED_FEATURES.registerStatic("sky_slime_tree", slimeTree, new SlimeTreeConfig.Builder().planted().canDoubleHeight().trunk(() -> TinkerWorld.skyroot.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.SKY)).m_49966_()).build());
    public static final RegistryObject<ConfiguredFeature<SlimeTreeConfig, SlimeTreeFeature>> skySlimeIslandTree = CONFIGURED_FEATURES.registerStatic("sky_slime_island_tree", slimeTree, new SlimeTreeConfig.Builder().canDoubleHeight().trunk(() -> TinkerWorld.skyroot.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.SKY)).m_49966_()).vines(() -> (BlockState)((SlimeVineBlock)TinkerWorld.skySlimeVine.get()).m_49966_().m_61124_(SlimeVineBlock.STAGE, (Comparable)((Object)SlimeVineBlock.VineStage.MIDDLE))).build());
    public static final RegistryObject<ConfiguredFeature<SlimeTreeConfig, SlimeTreeFeature>> enderSlimeTree = CONFIGURED_FEATURES.registerStatic("ender_slime_tree", slimeTree, new SlimeTreeConfig.Builder().planted().trunk(() -> TinkerWorld.greenheart.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.ENDER)).m_49966_()).build());
    public static final RegistryObject<ConfiguredFeature<SlimeTreeConfig, SlimeTreeFeature>> enderSlimeIslandTree = CONFIGURED_FEATURES.registerStatic("ender_slime_island_tree", slimeTree, new SlimeTreeConfig.Builder().trunk(() -> TinkerWorld.greenheart.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.ENDER)).m_49966_()).vines(() -> (BlockState)((SlimeVineBlock)TinkerWorld.enderSlimeVine.get()).m_49966_().m_61124_(SlimeVineBlock.STAGE, (Comparable)((Object)SlimeVineBlock.VineStage.MIDDLE))).build());
    public static final RegistryObject<ConfiguredFeature<HugeFungusConfiguration, SlimeFungusFeature>> bloodSlimeFungus = CONFIGURED_FEATURES.registerSupplier("blood_slime_fungus", slimeFungus, () -> new SlimeFungusConfig(TinkerTags.Blocks.SLIMY_SOIL, TinkerWorld.bloodshroom.getLog().m_49966_(), ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.BLOOD)).m_49966_(), ((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).m_49966_(), true));
    public static final RegistryObject<ConfiguredFeature<HugeFungusConfiguration, SlimeFungusFeature>> bloodSlimeIslandFungus = CONFIGURED_FEATURES.registerSupplier("blood_slime_island_fungus", slimeFungus, () -> new SlimeFungusConfig(TinkerTags.Blocks.SLIMY_NYLIUM, TinkerWorld.bloodshroom.getLog().m_49966_(), ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.BLOOD)).m_49966_(), ((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).m_49966_(), false));
    public static final RegistryObject<ConfiguredFeature<HugeFungusConfiguration, SlimeFungusFeature>> ichorSlimeFungus = CONFIGURED_FEATURES.registerSupplier("ichor_slime_fungus", slimeFungus, () -> new SlimeFungusConfig(TinkerTags.Blocks.SLIMY_SOIL, TinkerWorld.bloodshroom.getLog().m_49966_(), ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.ICHOR)).m_49966_(), ((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).m_49966_(), false));
    public static final RegistryObject<StructurePieceType> slimeIslandPiece = STRUCTURE_PIECE.register("slime_island_piece", () -> SlimeIslandPiece::new);
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> earthSlimeIsland = STRUCTURE_FEATURES.register("earth_slime_island", EarthSlimeIslandStructure::new);
    public static final RegistryObject<ConfiguredStructureFeature<?, ?>> configuredEarthSlimeIsland = CONFIGURED_STRUCTURE_FEATURES.register("earth_slime_island", () -> ((StructureFeature)earthSlimeIsland.get()).m_209773_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_, TinkerTags.Biomes.EARTHSLIME_ISLANDS, false, TinkerStructures.monsterOverride((EntityType)TinkerWorld.earthSlimeEntity.get(), 4, 4)));
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> skySlimeIsland = STRUCTURE_FEATURES.register("sky_slime_island", SkySlimeIslandStructure::new);
    public static final RegistryObject<ConfiguredStructureFeature<?, ?>> configuredSkySlimeIsland = CONFIGURED_STRUCTURE_FEATURES.register("sky_slime_island", () -> ((StructureFeature)skySlimeIsland.get()).m_209773_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_, TinkerTags.Biomes.SKYSLIME_ISLANDS, false, TinkerStructures.monsterOverride((EntityType)TinkerWorld.skySlimeEntity.get(), 3, 4)));
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> clayIsland = STRUCTURE_FEATURES.register("clay_island", ClayIslandStructure::new);
    public static final RegistryObject<ConfiguredStructureFeature<?, ?>> configuredClayIsland = CONFIGURED_STRUCTURE_FEATURES.register("clay_island", () -> ((StructureFeature)clayIsland.get()).m_209773_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_, TinkerTags.Biomes.CLAY_ISLANDS, false, TinkerStructures.monsterOverride((EntityType)TinkerWorld.terracubeEntity.get(), 2, 4)));
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> bloodIsland = STRUCTURE_FEATURES.register("blood_island", BloodSlimeIslandStructure::new);
    public static final RegistryObject<ConfiguredStructureFeature<?, ?>> configuredBloodIsland = CONFIGURED_STRUCTURE_FEATURES.register("blood_island", () -> ((StructureFeature)bloodIsland.get()).m_209773_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_, TinkerTags.Biomes.BLOOD_ISLANDS, false, TinkerStructures.monsterOverride(EntityType.f_20468_, 4, 6)));
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> endSlimeIsland = STRUCTURE_FEATURES.register("end_slime_island", EnderSlimeIslandStructure::new);
    public static final RegistryObject<ConfiguredStructureFeature<?, ?>> configuredEndSlimeIsland = CONFIGURED_STRUCTURE_FEATURES.register("end_slime_island", () -> ((StructureFeature)endSlimeIsland.get()).m_209773_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_, TinkerTags.Biomes.ENDERSLIME_ISLANDS, false, TinkerStructures.monsterOverride((EntityType)TinkerWorld.enderSlimeEntity.get(), 4, 4)));

    private static Map<MobCategory, StructureSpawnOverride> monsterOverride(EntityType<?> entity, int min, int max) {
        return Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(entity, 1, min, max)})));
    }
}

