/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.impl.TankModifier;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SearingModifier
extends Modifier {
    private static final SearingContainer CONTAINER = new SearingContainer();
    private static final Map<Item, Boolean> BOOSTED_BLOCKS = new ConcurrentHashMap<Item, Boolean>();

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        ((TankModifier)TinkerModifiers.tank.get()).addCapacity(volatileData, 250);
    }

    private static boolean isEffective(Level world, Item item) {
        CONTAINER.setStack(new ItemStack((ItemLike)item));
        boolean effective = world.m_7465_().m_44015_((RecipeType)TinkerRecipeTypes.MELTING.get(), (Container)CONTAINER, world).isPresent();
        CONTAINER.setStack(ItemStack.f_41583_);
        return effective;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Level world;
        BlockState state;
        Item item;
        if (isEffective && (item = (state = event.getState()).m_60734_().m_5456_()) != Items.f_41852_ && BOOSTED_BLOCKS.computeIfAbsent(item, arg_0 -> SearingModifier.lambda$onBreakSpeed$1(world = event.getPlayer().f_19853_, arg_0)) == Boolean.TRUE) {
            event.setNewSpeed(event.getNewSpeed() + (float)(level * 6) * tool.getMultiplier(ToolStats.MINING_SPEED) * miningSpeedModifier);
        }
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        this.addStatTooltip(tool, ToolStats.MINING_SPEED, TinkerTags.Items.HARVEST, 7 * level, tooltip);
    }

    private static /* synthetic */ Boolean lambda$onBreakSpeed$1(Level world, Item i) {
        return SearingModifier.isEffective(world, i);
    }

    static {
        RecipeCacheInvalidator.addReloadListener(client -> BOOSTED_BLOCKS.clear());
    }

    private static class SearingContainer
    implements IMeltingContainer {
        private ItemStack stack = ItemStack.f_41583_;

        private SearingContainer() {
        }

        @Override
        public IMeltingContainer.IOreRate getOreRate() {
            return Config.COMMON.melterOreRate;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
        }
    }
}

