/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.general;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.events.teleport.EnderportingTeleportEvent;
import slimeknights.tconstruct.library.modifiers.hooks.IHarvestModifier;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class EnderportingModifier
extends NoLevelsModifier
implements IHarvestModifier {
    private static final Set<ClientboundPlayerPositionPacket.RelativeArgument> PACKET_FLAGS = ImmutableSet.of((Object)ClientboundPlayerPositionPacket.RelativeArgument.X, (Object)ClientboundPlayerPositionPacket.RelativeArgument.Y, (Object)ClientboundPlayerPositionPacket.RelativeArgument.Z);

    @Override
    public int getPriority() {
        return 75;
    }

    private static boolean tryTeleport(LivingEntity living, double x, double y, double z) {
        Level world = living.m_20193_();
        if (world.f_46443_) {
            return false;
        }
        float scaledWidth = living.m_20205_() * 0.8f;
        float eyeHeight = living.m_20192_();
        AABB aabb = AABB.m_165882_((Vec3)new Vec3(x, y + (double)(eyeHeight / 2.0f), z), (double)scaledWidth, (double)eyeHeight, (double)scaledWidth);
        boolean didCollide = world.m_186434_((Entity)living, aabb).iterator().hasNext();
        if (didCollide && living.m_20206_() > 1.0f) {
            aabb = aabb.m_82386_(0.0, -1.0, 0.0);
            didCollide = world.m_186434_((Entity)living, aabb).iterator().hasNext();
            y -= 1.0;
        }
        if (!didCollide) {
            EnderportingTeleportEvent event = new EnderportingTeleportEvent(living, x, y, z);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                if (living instanceof ServerPlayer) {
                    ServerPlayer playerMP = (ServerPlayer)living;
                    playerMP.f_8906_.m_9780_(x, y, z, playerMP.m_146908_(), playerMP.m_146909_(), PACKET_FLAGS);
                } else {
                    living.m_6034_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                }
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    for (int i = 0; i < 32; ++i) {
                        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123760_, living.m_20185_(), living.m_20186_() + world.f_46441_.nextDouble() * 2.0, living.m_20189_(), 1, world.f_46441_.nextGaussian(), 0.0, world.f_46441_.nextGaussian(), 0.0);
                    }
                }
                world.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), Sounds.ENDERPORTING.getSound(), living.m_5720_(), 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        LivingEntity target;
        if (!context.isExtraAttack() && (target = context.getLivingTarget()) != null && target.m_21223_() == 0.0f) {
            Vec3 pos = target.m_20182_();
            if (EnderportingModifier.tryTeleport(context.getAttacker(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_())) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void finishBreakingBlocks(IToolStackView tool, int level, ToolHarvestContext context) {
        if (context.canHarvest()) {
            BlockPos pos = context.getPos();
            LivingEntity living = context.getLiving();
            if (EnderportingModifier.tryTeleport(living, (float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f)) {
                ToolDamageUtil.damageAnimated(tool, 2, living);
            }
        }
    }

    @Override
    public void afterHarvest(IToolStackView tool, int level, UseOnContext context, ServerLevel world, BlockState state, BlockPos pos) {
        Player living;
        if (context.m_8083_().equals((Object)pos) && (living = context.m_43723_()) != null && EnderportingModifier.tryTeleport((LivingEntity)living, (float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f)) {
            ToolDamageUtil.damageAnimated(tool, 2, (LivingEntity)living);
        }
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        return EnderportingModifier.tryModuleMatch(type, IHarvestModifier.class, this);
    }
}

