/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.data;

import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.fluid.transfer.AbstractFluidContainerTransferProvider;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.fluids.item.EmptyPotionTransfer;
import slimeknights.tconstruct.library.fluid.transfer.FillFluidContainerTransfer;
import slimeknights.tconstruct.library.fluid.transfer.FillFluidWithNBTTransfer;

public class FluidContainerTransferProvider
extends AbstractFluidContainerTransferProvider {
    public FluidContainerTransferProvider(DataGenerator generator) {
        super(generator, "tconstruct");
    }

    protected void addTransfers() {
        this.addFillEmpty("honey_bottle_", (ItemLike)Items.f_42787_, (ItemLike)Items.f_42590_, (Fluid)TinkerFluids.honey.get(), TinkerFluids.honey.getForgeTag(), 250, new ICondition[0]);
        this.addFillEmpty("beetroot_soup_", (ItemLike)Items.f_42734_, (ItemLike)Items.f_42399_, (Fluid)TinkerFluids.beetrootSoup.get(), TinkerFluids.beetrootSoup.getForgeTag(), 250, new ICondition[0]);
        this.addFillEmpty("mushroom_stew_", (ItemLike)Items.f_42400_, (ItemLike)Items.f_42399_, (Fluid)TinkerFluids.mushroomStew.get(), TinkerFluids.mushroomStew.getForgeTag(), 250, new ICondition[0]);
        this.addFillEmpty("rabbit_stew_", (ItemLike)Items.f_42699_, (ItemLike)Items.f_42399_, (Fluid)TinkerFluids.rabbitStew.get(), TinkerFluids.rabbitStew.getForgeTag(), 250, new ICondition[0]);
        this.addPotion("potion_", (ItemLike)Items.f_42589_, (ItemLike)Items.f_42590_, null);
        this.addPotion("potion_splash_", (ItemLike)Items.f_42736_, (ItemLike)TinkerFluids.splashBottle, TinkerTags.Items.SPLASH_BOTTLE);
        this.addPotion("potion_lingering_", (ItemLike)Items.f_42739_, (ItemLike)TinkerFluids.lingeringBottle, TinkerTags.Items.LINGERING_BOTTLE);
    }

    protected void addPotion(String prefix, ItemLike filled, ItemLike containerItem, @Nullable TagKey<Item> containerTag) {
        this.addTransfer(prefix + "empty", new EmptyPotionTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{filled}), ItemOutput.fromItem((ItemLike)containerItem), new FluidStack((Fluid)TinkerFluids.potion.get(), 250)), new ICondition[0]);
        Ingredient container = containerTag == null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{containerItem}) : Ingredient.m_204132_(containerTag);
        this.addTransfer(prefix + "fill", new FillFluidWithNBTTransfer(container, ItemOutput.fromItem((ItemLike)filled), FluidIngredient.of(TinkerTags.Fluids.POTION, (int)250)), new ICondition[0]);
        this.addTransfer(prefix + "water", new FillFluidContainerTransfer(container, ItemOutput.fromStack((ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack(filled), (Potion)Potions.f_43599_)), FluidIngredient.of((TagKey)FluidTags.f_13131_, (int)500)), new ICondition[0]);
    }

    public String m_6055_() {
        return "Tinkers' Construct Fluid Container Transfer";
    }
}

