/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.modifiers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeI18n;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierIngredientRenderer;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;

public class ModifierRecipeCategory
implements IRecipeCategory<IDisplayModifierRecipe> {
    protected static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/tinker_station.png");
    private static final Component TITLE = TConstruct.makeTranslation("jei", "modifiers.title");
    private static final List<Component> TEXT_FREE = Collections.singletonList(TConstruct.makeTranslation("jei", "modifiers.free"));
    private static final List<Component> TEXT_INCREMENTAL = Collections.singletonList(TConstruct.makeTranslation("jei", "modifiers.incremental"));
    private static final String KEY_SLOT = TConstruct.makeTranslationKey("jei", "modifiers.slot");
    private static final String KEY_SLOTS = TConstruct.makeTranslationKey("jei", "modifiers.slots");
    private static final String KEY_MAX = TConstruct.makeTranslationKey("jei", "modifiers.max");
    private final ModifierIngredientRenderer modifierRenderer = new ModifierIngredientRenderer(124, 10);
    private final IDrawable background;
    private final IDrawable icon;
    private final String maxPrefix;
    private final IDrawable requirements;
    private final IDrawable incremental;
    private final IDrawable[] slotIcons;
    private final Map<SlotType, TextureAtlasSprite> slotTypeSprites = new HashMap<SlotType, TextureAtlasSprite>();

    public ModifierRecipeCategory(IGuiHelper helper) {
        this.maxPrefix = ForgeI18n.getPattern((String)KEY_MAX);
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 0, 128, 77);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)CreativeSlotItem.withSlot(new ItemStack(TinkerModifiers.creativeSlotItem), SlotType.UPGRADE));
        this.slotIcons = new IDrawable[6];
        for (int i = 0; i < 6; ++i) {
            this.slotIcons[i] = helper.createDrawable(BACKGROUND_LOC, 128 + i * 16, 0, 16, 16);
        }
        this.requirements = helper.createDrawable(BACKGROUND_LOC, 128, 17, 16, 16);
        this.incremental = helper.createDrawable(BACKGROUND_LOC, 128, 33, 16, 16);
    }

    public ResourceLocation getUid() {
        return TConstructJEIConstants.MODIFIERS.getUid();
    }

    public RecipeType<IDisplayModifierRecipe> getRecipeType() {
        return TConstructJEIConstants.MODIFIERS;
    }

    public Component getTitle() {
        return TITLE;
    }

    public Class<? extends IDisplayModifierRecipe> getRecipeClass() {
        return IDisplayModifierRecipe.class;
    }

    private void drawSlot(PoseStack matrices, IDisplayModifierRecipe recipe, int slot, int x, int y) {
        List<ItemStack> stacks = recipe.getDisplayItems(slot);
        if (stacks.isEmpty()) {
            this.slotIcons[slot].draw(matrices, x + 1, y + 1);
        }
    }

    private void drawSlotType(PoseStack matrices, @Nullable SlotType slotType, int x, int y) {
        TextureAtlasSprite sprite;
        Minecraft minecraft = Minecraft.m_91087_();
        if (this.slotTypeSprites.containsKey(slotType)) {
            sprite = this.slotTypeSprites.get(slotType);
        } else {
            ModelManager modelManager = minecraft.m_91304_();
            BakedModel model = minecraft.m_91291_().m_115103_().m_109394_((Item)TinkerModifiers.creativeSlotItem.get());
            if (model != null && model.m_7343_() instanceof NBTKeyModel.Overrides) {
                Material material = ((NBTKeyModel.Overrides)model.m_7343_()).getTexture(slotType == null ? "slotless" : slotType.getName());
                sprite = modelManager.m_119428_(material.m_119193_()).m_118316_(material.m_119203_());
            } else {
                sprite = modelManager.m_119428_(InventoryMenu.f_39692_).m_118316_(MissingTextureAtlasSprite.m_118071_());
            }
            this.slotTypeSprites.put(slotType, sprite);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Screen.m_93200_((PoseStack)matrices, (int)x, (int)y, (int)0, (int)16, (int)16, (TextureAtlasSprite)sprite);
    }

    public void draw(IDisplayModifierRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrices, double mouseX, double mouseY) {
        SlotType.SlotCount slots;
        this.drawSlot(matrices, recipe, 0, 2, 32);
        this.drawSlot(matrices, recipe, 1, 24, 14);
        this.drawSlot(matrices, recipe, 2, 46, 32);
        this.drawSlot(matrices, recipe, 3, 42, 57);
        this.drawSlot(matrices, recipe, 4, 6, 57);
        if (recipe.hasRequirements()) {
            this.requirements.draw(matrices, 66, 58);
        }
        if (recipe.isIncremental()) {
            this.incremental.draw(matrices, 83, 59);
        }
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int max = recipe.getMaxLevel();
        if (max > 0) {
            fontRenderer.m_92883_(matrices, this.maxPrefix + max, 66.0f, 16.0f, Color.GRAY.getRGB());
        }
        if ((slots = recipe.getSlots()) == null) {
            this.drawSlotType(matrices, null, 110, 58);
        } else {
            this.drawSlotType(matrices, slots.getType(), 110, 58);
            String text = Integer.toString(slots.getCount());
            int x = 111 - fontRenderer.m_92895_(text);
            fontRenderer.m_92883_(matrices, text, (float)x, 63.0f, Color.GRAY.getRGB());
        }
    }

    public List<Component> getTooltipStrings(IDisplayModifierRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int checkX = (int)mouseX;
        int checkY = (int)mouseY;
        if (recipe.hasRequirements() && GuiUtil.isHovered(checkX, checkY, 66, 58, 16, 16)) {
            return Collections.singletonList(new TranslatableComponent(recipe.getRequirementsError()));
        }
        if (recipe.isIncremental() && GuiUtil.isHovered(checkX, checkY, 83, 59, 16, 16)) {
            return TEXT_INCREMENTAL;
        }
        if (GuiUtil.isHovered(checkX, checkY, 98, 58, 24, 16)) {
            SlotType.SlotCount slots = recipe.getSlots();
            if (slots != null) {
                int count = slots.getCount();
                if (count == 1) {
                    return Collections.singletonList(new TranslatableComponent(KEY_SLOT, new Object[]{slots.getType().getDisplayName()}));
                }
                if (count > 1) {
                    return Collections.singletonList(new TranslatableComponent(KEY_SLOTS, new Object[]{slots, slots.getType().getDisplayName()}));
                }
            } else {
                return TEXT_FREE;
            }
        }
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IDisplayModifierRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 33).addItemStacks(recipe.getDisplayItems(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 25, 15).addItemStacks(recipe.getDisplayItems(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 47, 33).addItemStacks(recipe.getDisplayItems(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 43, 58).addItemStacks(recipe.getDisplayItems(3));
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 58).addItemStacks(recipe.getDisplayItems(4));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 3, 3).setCustomRenderer(TConstructJEIConstants.MODIFIER_TYPE, (IIngredientRenderer)this.modifierRenderer).addIngredient(TConstructJEIConstants.MODIFIER_TYPE, (Object)recipe.getDisplayResult());
        builder.addSlot(RecipeIngredientRole.CATALYST, 25, 38).addItemStacks(recipe.getToolWithoutModifier());
        builder.addSlot(RecipeIngredientRole.CATALYST, 105, 34).addItemStacks(recipe.getToolWithModifier());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

