/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class EquipmentChangeContext
extends EquipmentContext {
    private final EquipmentSlot changedSlot;
    private final ItemStack original;
    private final ItemStack replacement;
    @Nullable
    private final IToolStackView originalTool;

    public EquipmentChangeContext(LivingEntity entity, EquipmentSlot changedSlot, ItemStack original, ItemStack replacement) {
        super(entity);
        this.changedSlot = changedSlot;
        this.original = original;
        this.replacement = replacement;
        this.originalTool = EquipmentChangeContext.getToolStackIfModifiable(original);
        int replacementIndex = changedSlot.m_20750_();
        this.toolsInSlots[replacementIndex] = EquipmentChangeContext.getToolStackIfModifiable(replacement);
        this.fetchedTool[replacementIndex] = true;
    }

    @Nullable
    public IToolStackView getReplacementTool() {
        return this.getToolInSlot(this.changedSlot);
    }

    public EquipmentSlot getChangedSlot() {
        return this.changedSlot;
    }

    public ItemStack getOriginal() {
        return this.original;
    }

    public ItemStack getReplacement() {
        return this.replacement;
    }

    @Nullable
    public IToolStackView getOriginalTool() {
        return this.originalTool;
    }
}

