/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SwappableModifierRecipe
extends ModifierRecipe {
    private final String value;

    public SwappableModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierId result, String value, @Nullable SlotType.SlotCount slots) {
        super(id, inputs, toolRequirement, maxToolSize, requirements, requirementsError, new ModifierEntry(result, 1), 1, slots);
        this.value = value;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        SlotType.SlotCount slots;
        ValidatedResult commonError;
        boolean needsModifier;
        ItemStack tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        ModifierId modifier = this.result.getId();
        if (tool.getUpgrades().getLevel(modifier) == 0) {
            needsModifier = true;
            commonError = this.validatePrerequisites(tool);
        } else {
            needsModifier = false;
            commonError = this.validateRequirements(tool);
        }
        if (commonError.hasError()) {
            return commonError;
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (needsModifier && (slots = this.getSlots()) != null) {
            persistentData.addSlots(slots.getType(), -slots.getCount());
        }
        persistentData.putString(modifier, this.value);
        if (needsModifier) {
            tool.addModifier(this.result.getId(), 1);
        } else {
            tool.rebuildStats();
        }
        ValidatedResult toolValidation = tool.validate();
        if (toolValidation.hasError()) {
            return toolValidation;
        }
        return ValidatedResult.success(tool.createStack(Math.min(tinkerable.m_41613_(), this.shrinkToolSlotBy())));
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.swappableModifierSerializer.get();
    }

    @Override
    public List<ItemStack> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            ModifierId id = this.result.getId();
            this.toolWithModifier = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, this.result, data -> data.putString(id, this.value))).collect(Collectors.toList());
            this.toolWithModifier = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, this.result, data -> data.putString(id, this.value))).collect(Collectors.toList());
        }
        return this.toolWithModifier;
    }

    public static class Serializer
    extends AbstractModifierRecipe.Serializer<SwappableModifierRecipe> {
        @Override
        protected ModifierEntry readResult(JsonObject json) {
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            return new ModifierEntry(ModifierId.getFromJson(result, "name"), 1);
        }

        @Override
        public SwappableModifierRecipe fromJson(ResourceLocation id, JsonObject json, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            String value = GsonHelper.m_13906_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (String)"value");
            return new SwappableModifierRecipe(id, (List<SizedIngredient>)ingredients, toolRequirement, maxToolSize, requirements, requirementsError, result.getId(), value, slots);
        }

        @Override
        public SwappableModifierRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            int size = buffer.m_130242_();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)SizedIngredient.read((FriendlyByteBuf)buffer));
            }
            String value = buffer.m_130277_();
            return new SwappableModifierRecipe(id, (List<SizedIngredient>)builder.build(), toolRequirement, maxToolSize, requirements, requirementsError, result.getId(), value, slots);
        }

        @Override
        protected void toNetworkSafe(FriendlyByteBuf buffer, SwappableModifierRecipe recipe) {
            super.toNetworkSafe(buffer, recipe);
            buffer.m_130130_(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            buffer.m_130070_(recipe.value);
        }
    }
}

