/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialFluidRecipe
implements ICustomOutputRecipe<ICastingContainer> {
    private final ResourceLocation id;
    private final FluidIngredient fluid;
    private final int temperature;
    @Nullable
    private final MaterialVariant input;
    private final MaterialVariant output;

    public MaterialFluidRecipe(ResourceLocation id, FluidIngredient fluid, int temperature, @Nullable MaterialVariantId inputId, MaterialVariantId outputId) {
        this.id = id;
        this.fluid = fluid;
        this.temperature = temperature;
        this.input = inputId == null ? null : MaterialVariant.of(inputId);
        this.output = MaterialVariant.of(outputId);
        MaterialCastingLookup.registerFluid(this);
    }

    public boolean matches(ICastingContainer inv) {
        if (this.output.isUnknown() || !this.fluid.test(inv.getFluid())) {
            return false;
        }
        if (this.input != null) {
            if (this.input.isUnknown()) {
                return false;
            }
            return this.input.matchesVariant(inv.getStack());
        }
        return true;
    }

    public int getFluidAmount(Fluid fluid) {
        return this.fluid.getAmount(fluid);
    }

    public List<FluidStack> getFluids() {
        return this.fluid.getFluids();
    }

    public final boolean matches(ICastingContainer inv, Level worldIn) {
        return this.matches(inv);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.materialFluidRecipe.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.DATA.get();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getTemperature() {
        return this.temperature;
    }

    @Nullable
    public MaterialVariant getInput() {
        return this.input;
    }

    public MaterialVariant getOutput() {
        return this.output;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<MaterialFluidRecipe> {
        public MaterialFluidRecipe fromJson(ResourceLocation id, JsonObject json) {
            FluidIngredient fluid = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            int temperature = GsonHelper.m_13927_((JsonObject)json, (String)"temperature");
            MaterialVariantId input = null;
            if (json.has("input")) {
                input = MaterialVariantId.fromJson(json, "input");
            }
            MaterialVariantId output = MaterialVariantId.fromJson(json, "output");
            return new MaterialFluidRecipe(id, fluid, temperature, input, output);
        }

        @Nullable
        protected MaterialFluidRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            FluidIngredient fluid = FluidIngredient.read((FriendlyByteBuf)buffer);
            int temperature = buffer.readInt();
            MaterialVariantId input = null;
            if (buffer.readBoolean()) {
                input = MaterialVariantId.parse(buffer.m_130136_(Short.MAX_VALUE));
            }
            MaterialVariantId output = MaterialVariantId.parse(buffer.m_130136_(Short.MAX_VALUE));
            return new MaterialFluidRecipe(id, fluid, temperature, input, output);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, MaterialFluidRecipe recipe) {
            recipe.fluid.write(buffer);
            buffer.writeInt(recipe.temperature);
            if (recipe.input != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(recipe.input.getVariant().toString());
            } else {
                buffer.writeBoolean(false);
            }
            buffer.m_130070_(recipe.output.getVariant().toString());
        }
    }
}

