/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.spilling.effects;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.utils.JsonUtils;

public record EffectSpillingEffect(MobEffect effect, int time, int level) implements ISpillingEffect
{
    public static final ResourceLocation ID = TConstruct.getResource("effect");
    public static final JsonDeserializer<EffectSpillingEffect> LOADER = (element, type, context) -> {
        JsonObject json = element.getAsJsonObject();
        ResourceLocation id = JsonHelper.getResourceLocation((JsonObject)json, (String)"name");
        if (!ForgeRegistries.MOB_EFFECTS.containsKey(id)) {
            throw new JsonSyntaxException("Unknown effect " + id);
        }
        MobEffect effect = Objects.requireNonNull((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(id));
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        int level = GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1);
        return new EffectSpillingEffect(effect, time, level);
    };

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        int time;
        LivingEntity target = context.getLivingTarget();
        if (target != null && (time = (int)((float)(this.time * 20) * scale)) > 0) {
            target.m_7292_(new MobEffectInstance(this.effect, time, this.level - 1));
        }
    }

    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = JsonUtils.withType(ID);
        json.addProperty("name", Objects.requireNonNull(this.effect.getRegistryName()).toString());
        json.addProperty("time", (Number)this.time);
        json.addProperty("level", (Number)this.level);
        return json;
    }
}

