/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.dynamic;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierAttribute;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.modifiers.util.ModifierStatBoost;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

public class StatBoostModifier
extends IncrementalModifier {
    @Nullable
    private final Rarity rarity;
    private final List<ModifierStatBoost> stats;
    private final List<ModifierAttribute> attributes;
    private final List<ResourceLocation> flags;
    private final ModifierLevelDisplay levelDisplay;
    private final ModifierDisplay modifierDisplay;
    public static final GenericLoaderRegistry.IGenericLoader<StatBoostModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<StatBoostModifier>(){

        public StatBoostModifier deserialize(JsonObject json) {
            Rarity rarity = null;
            if (json.has("rarity")) {
                rarity = (Rarity)JsonHelper.getAsEnum((JsonObject)json, (String)"rarity", Rarity.class);
            }
            List stats = Collections.emptyList();
            if (json.has("stats")) {
                stats = JsonHelper.parseList((JsonObject)json, (String)"stats", ModifierStatBoost::fromJson);
            }
            List attributes = Collections.emptyList();
            if (json.has("attributes")) {
                attributes = JsonHelper.parseList((JsonObject)json, (String)"attributes", ModifierAttribute::fromJson);
            }
            List flags = Collections.emptyList();
            if (json.has("flags")) {
                flags = JsonHelper.parseList((JsonObject)json, (String)"flags", JsonHelper::convertToResourceLocation);
            }
            ModifierLevelDisplay display = (ModifierLevelDisplay)ModifierLevelDisplay.LOADER.getAndDeserialize(json, "level_display");
            ModifierDisplay modifierDisplay = ModifierDisplay.ALWAYS;
            if (json.has("modifier_display")) {
                modifierDisplay = (ModifierDisplay)JsonHelper.getAsEnum((JsonObject)json, (String)"modifier_display", ModifierDisplay.class);
            }
            return new StatBoostModifier(rarity, stats, attributes, flags, display, modifierDisplay);
        }

        public void serialize(StatBoostModifier object, JsonObject json) {
            JsonArray stats;
            json.add("level_display", ModifierLevelDisplay.LOADER.serialize((GenericLoaderRegistry.IHaveLoader)object.levelDisplay));
            if (object.rarity != null) {
                json.addProperty("rarity", object.rarity.name().toLowerCase(Locale.ROOT));
            }
            if (!object.stats.isEmpty()) {
                stats = new JsonArray();
                for (ModifierStatBoost boost : object.stats) {
                    stats.add((JsonElement)boost.toJson());
                }
                json.add("stats", (JsonElement)stats);
            }
            if (!object.attributes.isEmpty()) {
                JsonArray attributes = new JsonArray();
                for (ModifierAttribute attribute : object.attributes) {
                    attributes.add((JsonElement)attribute.toJson());
                }
                json.add("attributes", (JsonElement)attributes);
            }
            if (!object.flags.isEmpty()) {
                stats = new JsonArray();
                for (ResourceLocation flag : object.flags) {
                    stats.add(flag.toString());
                }
                json.add("flags", (JsonElement)stats);
            }
            if (object.modifierDisplay != ModifierDisplay.ALWAYS) {
                json.addProperty("modifier_display", object.modifierDisplay.getName());
            }
        }

        public StatBoostModifier fromNetwork(FriendlyByteBuf buffer) {
            Rarity rarity = null;
            if (buffer.readBoolean()) {
                rarity = (Rarity)buffer.m_130066_(Rarity.class);
            }
            int size = buffer.m_130242_();
            ImmutableList.Builder stats = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                stats.add((Object)ModifierStatBoost.fromNetwork(buffer));
            }
            size = buffer.m_130242_();
            ImmutableList.Builder attributes = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                attributes.add((Object)ModifierAttribute.fromNetwork(buffer));
            }
            size = buffer.m_130242_();
            ImmutableList.Builder flags = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                flags.add((Object)buffer.m_130281_());
            }
            ModifierLevelDisplay levelDisplay = (ModifierLevelDisplay)ModifierLevelDisplay.LOADER.fromNetwork(buffer);
            ModifierDisplay modifierDisplay = (ModifierDisplay)buffer.m_130066_(ModifierDisplay.class);
            return new StatBoostModifier(rarity, (List<ModifierStatBoost>)stats.build(), (List<ModifierAttribute>)attributes.build(), (List<ResourceLocation>)flags.build(), levelDisplay, modifierDisplay);
        }

        public void toNetwork(StatBoostModifier object, FriendlyByteBuf buffer) {
            if (object.rarity != null) {
                buffer.writeBoolean(true);
                buffer.m_130068_((Enum)object.rarity);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.m_130130_(object.stats.size());
            for (ModifierStatBoost boost : object.stats) {
                boost.toNetwork(buffer);
            }
            buffer.m_130130_(object.attributes.size());
            for (ModifierAttribute attribute : object.attributes) {
                attribute.toNetwork(buffer);
            }
            buffer.m_130130_(object.flags.size());
            for (ResourceLocation flag : object.flags) {
                buffer.m_130085_(flag);
            }
            ModifierLevelDisplay.LOADER.toNetwork((GenericLoaderRegistry.IHaveLoader)object.levelDisplay, buffer);
            buffer.m_130068_((Enum)object.modifierDisplay);
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Component getDisplayName(int level) {
        return this.levelDisplay.nameForLevel(this, level);
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        if (this.rarity != null) {
            IModifiable.setRarity(volatileData, this.rarity);
        }
        for (ResourceLocation flag : this.flags) {
            volatileData.putBoolean(flag, true);
        }
    }

    @Override
    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
        float scaledLevel = this.getScaledLevel(context, level);
        for (ModifierStatBoost boost : this.stats) {
            boost.apply(context, scaledLevel, builder);
        }
    }

    @Override
    public void addAttributes(IToolStackView tool, int level, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        float scaledLevel = this.getScaledLevel(tool, level);
        for (ModifierAttribute attribute : this.attributes) {
            attribute.apply(tool, scaledLevel, slot, consumer);
        }
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.modifierDisplay.shouldDisplay(advanced);
    }

    protected StatBoostModifier(@Nullable Rarity rarity, List<ModifierStatBoost> stats, List<ModifierAttribute> attributes, List<ResourceLocation> flags, ModifierLevelDisplay levelDisplay, ModifierDisplay modifierDisplay) {
        this.rarity = rarity;
        this.stats = stats;
        this.attributes = attributes;
        this.flags = flags;
        this.levelDisplay = levelDisplay;
        this.modifierDisplay = modifierDisplay;
    }

    public static class Builder {
        private Rarity rarity = null;
        private final ImmutableList.Builder<ModifierStatBoost> boosts = ImmutableList.builder();
        private final ImmutableList.Builder<ModifierAttribute> attributes = ImmutableList.builder();
        private final ImmutableList.Builder<ResourceLocation> flags = ImmutableList.builder();
        private ModifierLevelDisplay display = ModifierLevelDisplay.DEFAULT;
        private ModifierDisplay modifierDisplay = ModifierDisplay.ALWAYS;

        @SafeVarargs
        public final <T> Builder update(IToolStat<T> stat, T value, TagKey<Item> ... tagRequirements) {
            this.boosts.add(new ModifierStatBoost.StatUpdate<T>(stat, value, List.of(tagRequirements)));
            return this;
        }

        private Builder boost(INumericToolStat<?> stat, ModifierStatBoost.BoostType type, float amount, TagKey<Item>[] tagRequirements) {
            this.boosts.add((Object)new ModifierStatBoost.StatBoost(stat, type, amount, List.of(tagRequirements)));
            return this;
        }

        @SafeVarargs
        public final Builder add(INumericToolStat<?> stat, float amount, TagKey<Item> ... tagRequirements) {
            return this.boost(stat, ModifierStatBoost.BoostType.ADD, amount, tagRequirements);
        }

        @SafeVarargs
        public final Builder multiplyBase(INumericToolStat<?> stat, float amount, TagKey<Item> ... tagRequirements) {
            return this.boost(stat, ModifierStatBoost.BoostType.MULTIPLY_BASE, amount, tagRequirements);
        }

        @SafeVarargs
        public final Builder multiplyConditional(INumericToolStat<?> stat, float amount, TagKey<Item> ... tagRequirements) {
            return this.boost(stat, ModifierStatBoost.BoostType.MULTIPLY_CONDITIONAL, amount, tagRequirements);
        }

        @SafeVarargs
        public final Builder multiplyAll(INumericToolStat<?> stat, float amount, TagKey<Item> ... tagRequirements) {
            return this.boost(stat, ModifierStatBoost.BoostType.MULTIPLY_ALL, amount, tagRequirements);
        }

        public Builder attribute(String unique, Attribute attribute, AttributeModifier.Operation operation, float amount, EquipmentSlot ... slots) {
            this.attributes.add((Object)new ModifierAttribute(unique, attribute, operation, amount, slots));
            return this;
        }

        public Builder addFlag(ResourceLocation flag) {
            this.flags.add((Object)flag);
            return this;
        }

        public StatBoostModifier build() {
            return new StatBoostModifier(this.rarity, (List<ModifierStatBoost>)this.boosts.build(), (List<ModifierAttribute>)this.attributes.build(), (List<ResourceLocation>)this.flags.build(), this.display, this.modifierDisplay);
        }

        public Builder rarity(Rarity rarity) {
            this.rarity = rarity;
            return this;
        }

        public Builder display(ModifierLevelDisplay display) {
            this.display = display;
            return this;
        }

        public Builder modifierDisplay(ModifierDisplay modifierDisplay) {
            this.modifierDisplay = modifierDisplay;
            return this;
        }
    }

    public static enum ModifierDisplay {
        ALWAYS(true, true),
        TABLE(true, false),
        NEVER(false, false);

        private final boolean normal;
        private final boolean advanced;
        private final String name = this.name().toLowerCase(Locale.ROOT);

        public boolean shouldDisplay(boolean isAdvanced) {
            return isAdvanced ? this.advanced : this.normal;
        }

        private ModifierDisplay(boolean normal, boolean advanced) {
            this.normal = normal;
            this.advanced = advanced;
        }

        public String getName() {
            return this.name;
        }
    }
}

