/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;

public class LazyMaterial
implements Supplier<IMaterial> {
    private final MaterialId id;
    private IMaterial material;

    protected LazyMaterial(IMaterial material) {
        this.id = material.getIdentifier();
        this.material = material;
    }

    public static LazyMaterial of(MaterialId id) {
        return new LazyMaterial(id);
    }

    public static LazyMaterial of(IMaterial material) {
        return new LazyMaterial(material);
    }

    @Override
    public IMaterial get() {
        if (this.material == null) {
            if (!MaterialRegistry.isFullyLoaded()) {
                return IMaterial.UNKNOWN;
            }
            this.material = MaterialRegistry.getMaterial(this.id);
        }
        return this.material;
    }

    public boolean isUnknown() {
        return this.get() == IMaterial.UNKNOWN;
    }

    public boolean matches(MaterialId material) {
        return this.id.equals(material);
    }

    public String toString() {
        return "LazyMaterial{" + this.id + "}";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.id.equals(((LazyMaterial)other).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected LazyMaterial(MaterialId id) {
        this.id = id;
    }

    public MaterialId getId() {
        return this.id;
    }
}

