/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class BreakableModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = new Unbaked(-1, 0);
    private final Material[] sprites;
    private final int color;
    private final int luminosity;

    public BreakableModifierModel(@Nullable Material normalSmall, @Nullable Material brokenSmall, @Nullable Material normalLarge, @Nullable Material brokenLarge, int color, int luminosity) {
        this.color = color;
        this.luminosity = luminosity;
        this.sprites = new Material[]{normalSmall, brokenSmall, normalLarge, brokenLarge};
    }

    public BreakableModifierModel(@Nullable Material normalSmall, @Nullable Material brokenSmall, @Nullable Material normalLarge, @Nullable Material brokenLarge) {
        this(normalSmall, brokenSmall, normalLarge, brokenLarge, -1, 0);
    }

    @Override
    public ImmutableList<BakedQuad> getQuads(IToolStackView tool, ModifierEntry entry, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        int index = (isLarge ? 2 : 0) | (tool.isBroken() ? 1 : 0);
        return MantleItemLayerModel.getQuadsForSprite((int)this.color, (int)-1, (TextureAtlasSprite)spriteGetter.apply(this.sprites[index]), (Transformation)transforms, (int)this.luminosity, (ItemLayerPixels)pixels);
    }

    private static class Unbaked
    implements IUnbakedModifierModel {
        private final int color;
        private final int luminosity;

        @Override
        @Nullable
        public IBakedModifierModel forTool(Function<String, Material> smallGetter, Function<String, Material> largeGetter) {
            Material normalSmall = smallGetter.apply("");
            Material brokenSmall = smallGetter.apply("_broken");
            Material normalLarge = smallGetter.apply("");
            Material brokenLarge = smallGetter.apply("_broken");
            if (normalSmall != null || brokenSmall != null || normalLarge != null || brokenLarge != null) {
                return new BreakableModifierModel(normalSmall, brokenSmall, normalLarge, brokenLarge, this.color, this.luminosity);
            }
            return null;
        }

        @Override
        public IUnbakedModifierModel configure(JsonObject data) {
            int color = JsonHelper.parseColor((String)GsonHelper.m_13851_((JsonObject)data, (String)"color", (String)""));
            int luminosity = GsonHelper.m_13927_((JsonObject)data, (String)"luminosity");
            if (color != this.color || luminosity != this.luminosity) {
                return new Unbaked(color, luminosity);
            }
            return this;
        }

        public Unbaked(int color, int luminosity) {
            this.color = color;
            this.luminosity = luminosity;
        }
    }
}

