/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.tools;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.ReversedListBuilder;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.ModifierModelManager;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolModel
implements IModelGeometry<ToolModel> {
    private static final Logger log = LogManager.getLogger(ToolModel.class);
    public static final Loader LOADER = new Loader();
    public static final ItemColor COLOR_HANDLER = (stack, index) -> {
        ItemOverrides patt4438$temp;
        BakedModel itemModel;
        if (index >= 0 && (itemModel = Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(stack.m_41720_())) != null && (patt4438$temp = itemModel.m_7343_()) instanceof MaterialOverrideHandler) {
            MaterialOverrideHandler overrides = (MaterialOverrideHandler)patt4438$temp;
            ToolStack tool = ToolStack.from(stack);
            int localIndex = 0;
            List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
            for (int i = modifiers.size() - 1; i >= 0; --i) {
                ModifierEntry entry = modifiers.get(i);
                IBakedModifierModel modifierModel = overrides.getModifierModel(entry.getModifier());
                if (modifierModel == null) continue;
                int modelIndexes = modifierModel.getTintIndexes();
                if (localIndex + modelIndexes > index) {
                    return modifierModel.getTint(tool, entry, index - localIndex);
                }
                localIndex += modelIndexes;
            }
        }
        return -1;
    };
    private final List<ToolPart> toolParts;
    private final boolean isLarge;
    private final Vec2 offset;
    private final List<ResourceLocation> smallModifierRoots;
    private final List<ResourceLocation> largeModifierRoots;
    private final List<ModifierId> firstModifiers;
    private Map<ModifierId, IBakedModifierModel> modifierModels = Collections.emptyMap();

    public static void registerItemColors(ItemColors colors, Supplier<? extends IModifiable> item) {
        colors.m_92689_(COLOR_HANDLER, new ItemLike[]{item.get()});
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet allTextures;
        block6: {
            block5: {
                allTextures = Sets.newHashSet();
                if (!this.toolParts.isEmpty()) break block5;
                allTextures.add(owner.resolveTexture("tool"));
                if (owner.isTexturePresent("broken")) {
                    allTextures.add(owner.resolveTexture("broken"));
                }
                if (!this.isLarge) break block6;
                allTextures.add(owner.resolveTexture("tool_large"));
                if (!owner.isTexturePresent("broken_large")) break block6;
                allTextures.add(owner.resolveTexture("broken_large"));
                break block6;
            }
            for (ToolPart part : this.toolParts) {
                if (part.hasMaterials()) {
                    MaterialModel.getMaterialTextures(allTextures, owner, part.getName(false, false), null);
                    if (part.hasBroken()) {
                        MaterialModel.getMaterialTextures(allTextures, owner, part.getName(true, false), null);
                    }
                    if (!this.isLarge) continue;
                    MaterialModel.getMaterialTextures(allTextures, owner, part.getName(false, true), null);
                    if (!part.hasBroken()) continue;
                    MaterialModel.getMaterialTextures(allTextures, owner, part.getName(true, true), null);
                    continue;
                }
                allTextures.add(owner.resolveTexture(part.getName(false, false)));
                if (part.hasBroken()) {
                    allTextures.add(owner.resolveTexture(part.getName(true, false)));
                }
                if (!this.isLarge) continue;
                allTextures.add(owner.resolveTexture(part.getName(false, true)));
                if (!part.hasBroken()) continue;
                allTextures.add(owner.resolveTexture(part.getName(true, true)));
            }
        }
        this.modifierModels = ModifierModelManager.getModelsForTool(this.smallModifierRoots, this.isLarge ? this.largeModifierRoots : Collections.emptyList(), allTextures);
        return allTextures;
    }

    private static void addModifierQuads(Function<Material, TextureAtlasSprite> spriteGetter, Map<ModifierId, IBakedModifierModel> modifierModels, List<ModifierId> firstModifiers, IToolStackView tool, Consumer<ImmutableList<BakedQuad>> quadConsumer, ItemLayerPixels pixels, Transformation transforms, boolean isLarge) {
        if (!modifierModels.isEmpty()) {
            int modelIndex = 0;
            List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
            if (!modifiers.isEmpty()) {
                int i;
                FirstModifier[] firsts = new FirstModifier[firstModifiers.size()];
                for (i = modifiers.size() - 1; i >= 0; --i) {
                    ModifierEntry entry = modifiers.get(i);
                    ModifierId modifier = entry.getModifier().getId();
                    IBakedModifierModel model = modifierModels.get((Object)modifier);
                    if (model == null) continue;
                    int index = firstModifiers.indexOf((Object)modifier);
                    if (index == -1) {
                        quadConsumer.accept(model.getQuads(tool, entry, spriteGetter, transforms, isLarge, modelIndex, pixels));
                    } else {
                        firsts[index] = new FirstModifier(entry, model, modelIndex);
                    }
                    modelIndex += model.getTintIndexes();
                }
                for (i = firsts.length - 1; i >= 0; --i) {
                    FirstModifier first = firsts[i];
                    if (first == null) continue;
                    quadConsumer.accept(first.model.getQuads(tool, first.entry, spriteGetter, transforms, isLarge, first.modelIndex, pixels));
                }
            }
        }
    }

    private static BakedModel bakeInternal(IModelConfiguration owner, Function<Material, TextureAtlasSprite> spriteGetter, @Nullable Transformation largeTransforms, List<ToolPart> parts, Map<ModifierId, IBakedModifierModel> modifierModels, List<ModifierId> firstModifiers, List<MaterialVariantId> materials, @Nullable IToolStackView tool, ItemOverrides overrides) {
        boolean isBroken = tool != null && tool.isBroken();
        TextureAtlasSprite particle = null;
        ReversedListBuilder smallBuilder = new ReversedListBuilder();
        ReversedListBuilder largeBuilder = new ReversedListBuilder();
        ItemLayerPixels smallPixels = new ItemLayerPixels();
        ItemLayerPixels largePixels = new ItemLayerPixels();
        Consumer<ImmutableList<BakedQuad>> largeConsumer = arg_0 -> ((ReversedListBuilder)largeBuilder).addAll(arg_0);
        Consumer<Object> smallConsumer = largeTransforms != null ? quads -> smallBuilder.addAll((Collection)quads.stream().filter(quad -> quad.m_111306_() == Direction.SOUTH).collect(Collectors.toList())) : arg_0 -> ((ReversedListBuilder)smallBuilder).addAll(arg_0);
        if (tool != null && !modifierModels.isEmpty()) {
            ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, smallConsumer, smallPixels, Transformation.m_121093_(), false);
            if (largeTransforms != null) {
                ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, largeConsumer, largePixels, largeTransforms, true);
            }
        }
        if (parts.isEmpty()) {
            particle = spriteGetter.apply(owner.resolveTexture(isBroken && owner.isTexturePresent("broken") ? "broken" : "tool"));
            smallConsumer.accept((ImmutableList<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)particle, (Transformation)Transformation.m_121093_(), (int)0, (ItemLayerPixels)smallPixels));
            if (largeTransforms != null) {
                largeConsumer.accept((ImmutableList<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)spriteGetter.apply(owner.resolveTexture(isBroken && owner.isTexturePresent("broken_large") ? "broken_large" : "tool_large")), (Transformation)largeTransforms, (int)0, (ItemLayerPixels)largePixels));
            }
        } else {
            for (int i = parts.size() - 1; i >= 0; --i) {
                ToolPart part = parts.get(i);
                if (part.hasMaterials()) {
                    int index = part.index();
                    MaterialVariantId material = null;
                    if (index < materials.size()) {
                        material = materials.get(index);
                    }
                    particle = MaterialModel.getPartQuads(smallConsumer, owner, spriteGetter, Transformation.m_121093_(), part.getName(isBroken, false), -1, material, smallPixels);
                    if (largeTransforms == null) continue;
                    MaterialModel.getPartQuads(largeConsumer, owner, spriteGetter, largeTransforms, part.getName(isBroken, true), -1, material, largePixels);
                    continue;
                }
                particle = spriteGetter.apply(owner.resolveTexture(part.getName(isBroken, false)));
                smallConsumer.accept((ImmutableList<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)particle, (Transformation)Transformation.m_121093_(), (int)0, (ItemLayerPixels)smallPixels));
                if (largeTransforms == null) continue;
                largeConsumer.accept((ImmutableList<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)spriteGetter.apply(owner.resolveTexture(part.getName(isBroken, true))), (Transformation)largeTransforms, (int)0, (ItemLayerPixels)largePixels));
            }
        }
        ImmutableMap transformMap = Maps.immutableEnumMap((Map)PerspectiveMapWrapper.getTransforms((ModelState)owner.getCombinedTransform()));
        if (largeTransforms != null) {
            return new BakedLargeToolModel((ImmutableList<BakedQuad>)largeBuilder.build(), (ImmutableList<BakedQuad>)smallBuilder.build(), particle, (ImmutableMap<ItemTransforms.TransformType, Transformation>)transformMap, overrides, owner.isSideLit());
        }
        return new BakedItemModel(smallBuilder.build(), particle, transformMap, overrides, true, owner.isSideLit());
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        Transformation largeTransforms = this.isLarge ? new Transformation(new Vector3f((this.offset.f_82470_ - 8.0f) / 32.0f, (-this.offset.f_82471_ - 8.0f) / 32.0f, 0.0f), null, new Vector3f(2.0f, 2.0f, 1.0f), null) : null;
        overrides = new MaterialOverrideHandler(owner, this.toolParts, this.firstModifiers, largeTransforms, this.modifierModels);
        return ToolModel.bakeInternal(owner, spriteGetter, largeTransforms, this.toolParts, this.modifierModels, this.firstModifiers, Collections.emptyList(), null, overrides);
    }

    public ToolModel(List<ToolPart> toolParts, boolean isLarge, Vec2 offset, List<ResourceLocation> smallModifierRoots, List<ResourceLocation> largeModifierRoots, List<ModifierId> firstModifiers) {
        this.toolParts = toolParts;
        this.isLarge = isLarge;
        this.offset = offset;
        this.smallModifierRoots = smallModifierRoots;
        this.largeModifierRoots = largeModifierRoots;
        this.firstModifiers = firstModifiers;
    }

    private record ToolPart(String name, int index, @Nullable String broken) {
        public boolean hasBroken() {
            return this.broken != null;
        }

        public boolean hasMaterials() {
            return this.index >= 0;
        }

        public String getName(boolean isBroken, boolean isLarge) {
            Object name = this.name;
            if (isBroken && this.broken != null) {
                name = this.broken;
            }
            if (isLarge) {
                name = "large_" + (String)name;
            }
            return name;
        }

        public static ToolPart read(JsonObject json) {
            String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            int index = GsonHelper.m_13824_((JsonObject)json, (String)"index", (int)-1);
            String broken = null;
            if (json.has("broken")) {
                broken = GsonHelper.m_13906_((JsonObject)json, (String)"broken");
            }
            return new ToolPart(name, index, broken);
        }
    }

    private record FirstModifier(ModifierEntry entry, IBakedModifierModel model, int modelIndex) {
    }

    private static class BakedLargeToolModel
    implements BakedModel {
        private final ImmutableList<BakedQuad> largeQuads;
        private final TextureAtlasSprite particleIcon;
        private final ImmutableMap<ItemTransforms.TransformType, Transformation> transforms;
        private final ItemOverrides overrides;
        private final boolean usesBlockLight;
        private final BakedModel guiModel;

        private BakedLargeToolModel(ImmutableList<BakedQuad> largeQuads, ImmutableList<BakedQuad> smallQuads, TextureAtlasSprite particle, ImmutableMap<ItemTransforms.TransformType, Transformation> transforms, ItemOverrides overrides, boolean isSideLit) {
            this.largeQuads = largeQuads;
            this.particleIcon = particle;
            this.transforms = transforms;
            this.overrides = overrides;
            this.usesBlockLight = isSideLit;
            this.guiModel = new BakedLargeToolGui(this, (List<BakedQuad>)smallQuads);
        }

        public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            if (side == null) {
                return this.largeQuads;
            }
            return ImmutableList.of();
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType type, PoseStack mat) {
            if (type == ItemTransforms.TransformType.GUI) {
                return this.guiModel.handlePerspective(type, mat);
            }
            return PerspectiveMapWrapper.handlePerspective((BakedModel)this, this.transforms, (ItemTransforms.TransformType)type, (PoseStack)mat);
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return false;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particleIcon;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public boolean m_7547_() {
            return this.usesBlockLight;
        }
    }

    public static final class MaterialOverrideHandler
    extends ItemOverrides {
        private final Cache<ToolCacheKey, BakedModel> cache = CacheBuilder.newBuilder().maximumSize((long)MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos().size() * 3L / 2L).build();
        private final IModelConfiguration owner;
        private final List<ToolPart> toolParts;
        private final List<ModifierId> firstModifiers;
        @Nullable
        private final Transformation largeTransforms;
        private final Map<ModifierId, IBakedModifierModel> modifierModels;

        private MaterialOverrideHandler(IModelConfiguration owner, List<ToolPart> toolParts, List<ModifierId> firstModifiers, @Nullable Transformation largeTransforms, Map<ModifierId, IBakedModifierModel> modifierModels) {
            this.owner = owner;
            this.toolParts = toolParts;
            this.firstModifiers = firstModifiers;
            this.largeTransforms = largeTransforms;
            this.modifierModels = modifierModels;
        }

        @Nullable
        public IBakedModifierModel getModifierModel(Modifier modifier) {
            return this.modifierModels.get((Object)modifier.getId());
        }

        private BakedModel bakeDynamic(List<MaterialVariantId> materials, IToolStackView tool) {
            return ToolModel.bakeInternal(this.owner, ForgeModelBakery.defaultTextureGetter(), this.largeTransforms, this.toolParts, this.modifierModels, this.firstModifiers, materials, tool, ItemOverrides.f_111734_);
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            List<MaterialVariantId> materialIds = MaterialIdNBT.from(stack).getMaterials();
            ToolStack tool = ToolStack.from(stack);
            boolean broken = ToolDamageUtil.isBroken(stack);
            if (!broken && materialIds.isEmpty() && tool.getUpgrades().isEmpty()) {
                return originalModel;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ModifierEntry entry : tool.getUpgrades().getModifiers()) {
                Object cacheKey;
                IBakedModifierModel model = this.getModifierModel(entry.getModifier());
                if (model == null || (cacheKey = model.getCacheKey(tool, entry)) == null) continue;
                builder.add(cacheKey);
            }
            try {
                return (BakedModel)this.cache.get((Object)new ToolCacheKey(materialIds, (List<Object>)builder.build(), broken), () -> this.bakeDynamic(materialIds, tool));
            }
            catch (ExecutionException e) {
                log.error((Object)e);
                return originalModel;
            }
        }
    }

    private static class Loader
    implements IModelLoader<ToolModel> {
        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        public ToolModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            List parts = Collections.emptyList();
            if (modelContents.has("parts")) {
                parts = JsonHelper.parseList((JsonObject)modelContents, (String)"parts", ToolPart::read);
            }
            boolean isLarge = GsonHelper.m_13855_((JsonObject)modelContents, (String)"large", (boolean)false);
            Vec2 offset = Vec2.f_82462_;
            if (modelContents.has("large_offset")) {
                offset = MaterialModel.arrayToObject(modelContents, "large_offset");
            }
            List smallModifierRoots = Collections.emptyList();
            List largeModifierRoots = Collections.emptyList();
            if (modelContents.has("modifier_roots")) {
                if (isLarge) {
                    JsonObject modifierRoots = GsonHelper.m_13930_((JsonObject)modelContents, (String)"modifier_roots");
                    BiFunction<JsonElement, String, ResourceLocation> parser = (element, string) -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)element, (String)string));
                    smallModifierRoots = JsonHelper.parseList((JsonObject)modifierRoots, (String)"small", parser);
                    largeModifierRoots = JsonHelper.parseList((JsonObject)modifierRoots, (String)"large", parser);
                } else {
                    smallModifierRoots = JsonHelper.parseList((JsonObject)modelContents, (String)"modifier_roots", (element, string) -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)element, (String)string)));
                }
            }
            List firstModifiers = Collections.emptyList();
            if (modelContents.has("first_modifiers")) {
                firstModifiers = JsonHelper.parseList((JsonObject)modelContents, (String)"first_modifiers", ModifierId::convertFromJson);
            }
            return new ToolModel(parts, isLarge, offset, smallModifierRoots, largeModifierRoots, firstModifiers);
        }
    }

    private record ToolCacheKey(List<MaterialVariantId> materials, List<Object> modifierData, boolean broken) {
    }

    private static class BakedLargeToolGui
    extends BakedModelWrapper<BakedLargeToolModel> {
        private final List<BakedQuad> guiQuads;

        public BakedLargeToolGui(BakedLargeToolModel model, List<BakedQuad> guiQuads) {
            super((BakedModel)model);
            this.guiQuads = guiQuads;
        }

        public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            if (side == null) {
                return this.guiQuads;
            }
            return ImmutableList.of();
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType transform, PoseStack mat) {
            return PerspectiveMapWrapper.handlePerspective((BakedModel)this, ((BakedLargeToolModel)this.originalModel).transforms, (ItemTransforms.TransformType)transform, (PoseStack)mat);
        }
    }
}

