/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.recipe.charging;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.recipe.CARecipeSerializer;
import com.mrh0.createaddition.recipe.charging.ChargingRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ChargingRecipeSerializer
extends CARecipeSerializer<ChargingRecipe> {
    public ChargingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int energy = buffer.readInt();
        ItemStack output = buffer.m_130267_();
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        return new ChargingRecipe(recipeId, input, output, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, ChargingRecipe recipe) {
        buffer.writeInt(recipe.energy);
        buffer.m_130055_(recipe.output);
        recipe.ingredient.m_43923_(buffer);
    }

    @Override
    public ItemStack getIcon() {
        return CABlocks.TESLA_COIL.asStack();
    }

    @Override
    public ChargingRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        int energy = json.get("energy").getAsInt();
        ItemStack output = this.readOutput(json.get("result"));
        Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
        return new ChargingRecipe(recipeId, input, output, energy);
    }
}

